/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import org.jhotdraw.app.Disposable;
import org.jhotdraw.draw.DefaultDrawingEditor;
import org.jhotdraw.draw.DefaultDrawingView;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.ImageHolderFigure;
import org.jhotdraw.draw.QuadTreeDrawing;
import org.jhotdraw.draw.io.ImageInputFormat;
import org.jhotdraw.draw.io.ImageOutputFormat;
import org.jhotdraw.draw.io.InputFormat;
import org.jhotdraw.draw.io.OutputFormat;
import org.jhotdraw.draw.io.TextInputFormat;
import org.jhotdraw.gui.ToolBarLayout;
import org.jhotdraw.gui.plaf.palette.PaletteLookAndFeel;
import org.jhotdraw.samples.svg.figures.SVGImageFigure;
import org.jhotdraw.samples.svg.figures.SVGTextFigure;
import org.jhotdraw.samples.svg.gui.ActionsToolBar;
import org.jhotdraw.samples.svg.gui.AlignToolBar;
import org.jhotdraw.samples.svg.gui.ArrangeToolBar;
import org.jhotdraw.samples.svg.gui.CanvasToolBar;
import org.jhotdraw.samples.svg.gui.FigureToolBar;
import org.jhotdraw.samples.svg.gui.FillToolBar;
import org.jhotdraw.samples.svg.gui.FontToolBar;
import org.jhotdraw.samples.svg.gui.LinkToolBar;
import org.jhotdraw.samples.svg.gui.StrokeToolBar;
import org.jhotdraw.samples.svg.gui.ToolsToolBar;
import org.jhotdraw.samples.svg.gui.ViewToolBar;
import org.jhotdraw.samples.svg.io.ImageMapOutputFormat;
import org.jhotdraw.samples.svg.io.SVGOutputFormat;
import org.jhotdraw.samples.svg.io.SVGZInputFormat;
import org.jhotdraw.samples.svg.io.SVGZOutputFormat;
import org.jhotdraw.undo.UndoRedoManager;
import org.jhotdraw.util.ResourceBundleUtil;
import org.jhotdraw.util.prefs.PreferencesUtil;

public class SVGDrawingPanel
extends JPanel
implements Disposable {
    private UndoRedoManager undoManager;
    @Nullable
    private DrawingEditor editor;
    private ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.samples.svg.Labels");
    private Preferences prefs;
    @Nullable
    private ContainerListener containerHandler;
    private ActionsToolBar actionToolBar;
    private AlignToolBar alignToolBar;
    private ArrangeToolBar arrangeToolBar;
    private CanvasToolBar canvasToolBar;
    private ToolsToolBar creationToolBar;
    private FigureToolBar figureToolBar;
    private FillToolBar fillToolBar;
    private FontToolBar fontToolBar;
    private LinkToolBar linkToolBar;
    private JScrollPane scrollPane;
    private StrokeToolBar strokeToolBar;
    private ButtonGroup toolButtonGroup;
    private JPanel toolsPane;
    private JPanel toolsPanel;
    private JScrollPane toolsScrollPane;
    private DefaultDrawingView view;
    private ViewToolBar viewToolBar;

    public UndoRedoManager getUndoRedoManager() {
        return this.undoManager;
    }

    public void setUndoRedoManager(UndoRedoManager undo) {
        if (this.undoManager != null && this.getView().getDrawing() != null) {
            this.getView().getDrawing().removeUndoableEditListener(this.undoManager);
        }
        this.undoManager = undo;
        if (this.undoManager != null && this.getView().getDrawing() != null) {
            this.getView().getDrawing().addUndoableEditListener(this.undoManager);
        }
    }

    public SVGDrawingPanel() {
        try {
            this.prefs = PreferencesUtil.userNodeForPackage(this.getClass());
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.initComponents();
        this.toolsPane.setLayout(new ToolBarLayout());
        this.toolsPane.setBackground(new Color(0xF0F0F0));
        this.toolsPane.setOpaque(true);
        this.viewToolBar.setView(this.view);
        this.undoManager = new UndoRedoManager();
        Drawing drawing = this.createDrawing();
        this.view.setDrawing(drawing);
        drawing.addUndoableEditListener(this.undoManager);
        try {
            this.view.setTransferHandler((TransferHandler)Class.forName("org.jhotdraw.draw.DnDDrawingViewTransferHandler").newInstance());
        }
        catch (Exception exception) {
            // empty catch block
        }
        ArrayList<JToolBar> sortme = new ArrayList<JToolBar>();
        for (Component c : this.toolsPane.getComponents()) {
            if (!(c instanceof JToolBar)) continue;
            sortme.add((JToolBar)c);
        }
        Collections.sort(sortme, new Comparator<JToolBar>(){

            @Override
            public int compare(JToolBar tb1, JToolBar tb2) {
                int i1 = SVGDrawingPanel.this.prefs.getInt("toolBarIndex." + tb1.getName(), 0);
                int i2 = SVGDrawingPanel.this.prefs.getInt("toolBarIndex." + tb2.getName(), 0);
                return i1 - i2;
            }
        });
        this.toolsPane.removeAll();
        for (JToolBar tb : sortme) {
            this.toolsPane.add(tb);
        }
        this.containerHandler = new ContainerListener(){

            @Override
            public void componentAdded(ContainerEvent e) {
                int i = 0;
                for (Component c : SVGDrawingPanel.this.toolsPane.getComponents()) {
                    if (!(c instanceof JToolBar)) continue;
                    JToolBar tb = (JToolBar)c;
                    SVGDrawingPanel.this.prefs.putInt("toolBarIndex." + tb.getName(), i);
                    ++i;
                }
            }

            @Override
            public void componentRemoved(ContainerEvent e) {
            }
        };
        this.toolsPane.addContainerListener(this.containerHandler);
        this.setEditor(new DefaultDrawingEditor());
    }

    @Override
    public void dispose() {
        this.toolsPane.removeContainerListener(this.containerHandler);
        this.containerHandler = null;
        this.setEditor(null);
        for (PropertyChangeListener pcl : (PropertyChangeListener[])this.view.getListeners(PropertyChangeListener.class)) {
            this.view.removePropertyChangeListener(pcl);
        }
        this.view.setDrawing(null);
        this.actionToolBar.dispose();
        this.alignToolBar.dispose();
        this.arrangeToolBar.dispose();
        this.canvasToolBar.dispose();
        this.creationToolBar.dispose();
        this.figureToolBar.dispose();
        this.fillToolBar.dispose();
        this.fontToolBar.dispose();
        this.linkToolBar.dispose();
        this.strokeToolBar.dispose();
        this.viewToolBar.dispose();
        this.removeAll();
    }

    public Drawing createDrawing() {
        QuadTreeDrawing drawing = new QuadTreeDrawing();
        LinkedList<InputFormat> inputFormats = new LinkedList<InputFormat>();
        inputFormats.add(new SVGZInputFormat());
        inputFormats.add(new ImageInputFormat((ImageHolderFigure)new SVGImageFigure(), "PNG", "Portable Network Graphics (PNG)", "png", "image/png"));
        inputFormats.add(new ImageInputFormat((ImageHolderFigure)new SVGImageFigure(), "JPG", "Joint Photographics Experts Group (JPEG)", "jpg", "image/jpg"));
        inputFormats.add(new ImageInputFormat((ImageHolderFigure)new SVGImageFigure(), "GIF", "Graphics Interchange Format (GIF)", "gif", "image/gif"));
        inputFormats.add(new TextInputFormat(new SVGTextFigure()));
        drawing.setInputFormats(inputFormats);
        LinkedList<OutputFormat> outputFormats = new LinkedList<OutputFormat>();
        outputFormats.add(new SVGOutputFormat());
        outputFormats.add(new SVGZOutputFormat());
        outputFormats.add(new ImageOutputFormat());
        outputFormats.add(new ImageOutputFormat("JPG", "Joint Photographics Experts Group (JPEG)", "jpg", 1));
        outputFormats.add(new ImageOutputFormat("BMP", "Windows Bitmap (BMP)", "bmp", 13));
        outputFormats.add(new ImageMapOutputFormat());
        drawing.setOutputFormats(outputFormats);
        return drawing;
    }

    public void setDrawing(Drawing d) {
        this.undoManager.discardAllEdits();
        if (this.view.getDrawing() != null) {
            this.view.getDrawing().removeUndoableEditListener(this.undoManager);
        }
        this.view.setDrawing(d);
        d.addUndoableEditListener(this.undoManager);
    }

    public Drawing getDrawing() {
        return this.view.getDrawing();
    }

    public DrawingView getView() {
        return this.view;
    }

    @Nullable
    public DrawingEditor getEditor() {
        return this.editor;
    }

    public void setEditor(@Nullable DrawingEditor newValue) {
        DrawingView temp;
        DrawingEditor oldValue = this.editor;
        if (oldValue != null) {
            oldValue.remove(this.view);
        }
        this.editor = newValue;
        if (newValue != null) {
            newValue.add(this.view);
        }
        this.creationToolBar.setEditor(this.editor);
        this.fillToolBar.setEditor(this.editor);
        this.strokeToolBar.setEditor(this.editor);
        this.actionToolBar.setUndoManager(this.undoManager);
        this.actionToolBar.setEditor(this.editor);
        this.alignToolBar.setEditor(this.editor);
        this.arrangeToolBar.setEditor(this.editor);
        this.fontToolBar.setEditor(this.editor);
        this.figureToolBar.setEditor(this.editor);
        this.linkToolBar.setEditor(this.editor);
        DrawingView drawingView = temp = this.editor == null ? null : this.editor.getActiveView();
        if (this.editor != null) {
            this.editor.setActiveView(this.view);
        }
        this.canvasToolBar.setEditor(this.editor);
        this.viewToolBar.setEditor(this.editor);
        if (this.editor != null) {
            this.editor.setActiveView(temp);
        }
    }

    public void read(URI f) throws IOException {
        Drawing newDrawing = this.createDrawing();
        if (newDrawing.getInputFormats().size() == 0) {
            throw new InternalError("Drawing object has no input formats.");
        }
        IOException firstIOException = null;
        for (InputFormat format : newDrawing.getInputFormats()) {
            try {
                format.read(f, newDrawing);
                final Drawing loadedDrawing = newDrawing;
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        SVGDrawingPanel.this.setDrawing(loadedDrawing);
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    r.run();
                } else {
                    try {
                        SwingUtilities.invokeAndWait(r);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (InvocationTargetException ex) {
                        InternalError ie = new InternalError("Error setting drawing.");
                        ie.initCause(ex);
                        throw ie;
                    }
                }
                return;
            }
            catch (IOException e) {
                if (firstIOException != null) continue;
                firstIOException = e;
            }
        }
        throw firstIOException;
    }

    public void read(URI f, InputFormat format) throws IOException {
        if (format == null) {
            this.read(f);
            return;
        }
        Drawing newDrawing = this.createDrawing();
        if (newDrawing.getInputFormats().size() == 0) {
            throw new InternalError("Drawing object has no input formats.");
        }
        format.read(f, newDrawing);
        final Drawing loadedDrawing = newDrawing;
        Runnable r = new Runnable(){

            @Override
            public void run() {
                SVGDrawingPanel.this.setDrawing(loadedDrawing);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(r);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException ex) {
                InternalError ie = new InternalError("Error setting drawing.");
                ie.initCause(ex);
                throw ie;
            }
        }
    }

    public void write(URI uri) throws IOException {
        final Drawing[] helper = new Drawing[1];
        Runnable r = new Runnable(){

            @Override
            public void run() {
                helper[0] = (Drawing)SVGDrawingPanel.this.getDrawing().clone();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(r);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException ex) {
                InternalError ie = new InternalError("Error getting drawing.");
                ie.initCause(ex);
                throw ie;
            }
        }
        Drawing saveDrawing = helper[0];
        if (saveDrawing.getOutputFormats().size() == 0) {
            throw new InternalError("Drawing object has no output formats.");
        }
        File f = new File(uri);
        for (OutputFormat format : saveDrawing.getOutputFormats()) {
            if (!format.getFileFilter().accept(f)) continue;
            format.write(uri, saveDrawing);
            return;
        }
        throw new IOException("No output format for " + f.getName());
    }

    public void write(URI f, OutputFormat format) throws IOException {
        if (format == null) {
            this.write(f);
            return;
        }
        final Drawing[] helper = new Drawing[1];
        Runnable r = new Runnable(){

            @Override
            public void run() {
                helper[0] = (Drawing)SVGDrawingPanel.this.getDrawing().clone();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(r);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException ex) {
                InternalError ie = new InternalError("Error getting drawing.");
                ie.initCause(ex);
                throw ie;
            }
        }
        Drawing saveDrawing = helper[0];
        format.write(f, saveDrawing);
    }

    public void setPopupActions(List<Action> actions) {
        this.actionToolBar.setPopupActions(actions);
    }

    public List<Action> getPopupActions() {
        return this.actionToolBar.getPopupActions();
    }

    public JComponent getComponent() {
        return this;
    }

    private void initComponents() {
        this.toolButtonGroup = new ButtonGroup();
        this.scrollPane = new JScrollPane();
        this.view = new DefaultDrawingView();
        this.toolsPanel = new JPanel();
        this.toolsScrollPane = new JScrollPane();
        this.toolsPane = new JPanel();
        this.creationToolBar = new ToolsToolBar();
        this.actionToolBar = new ActionsToolBar();
        this.fillToolBar = new FillToolBar();
        this.strokeToolBar = new StrokeToolBar();
        this.fontToolBar = new FontToolBar();
        this.arrangeToolBar = new ArrangeToolBar();
        this.alignToolBar = new AlignToolBar();
        this.figureToolBar = new FigureToolBar();
        this.linkToolBar = new LinkToolBar();
        this.canvasToolBar = new CanvasToolBar();
        this.viewToolBar = new ViewToolBar();
        this.setBackground(new Color(255, 255, 255));
        this.setLayout(new BorderLayout());
        this.scrollPane.setBorder(null);
        this.scrollPane.setViewportView(this.view);
        this.add((Component)this.scrollPane, "Center");
        this.toolsPanel.setBackground(new Color(255, 255, 255));
        this.toolsPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.toolsPanel.setOpaque(true);
        this.toolsPanel.setLayout(new GridBagLayout());
        this.toolsScrollPane.setBorder(PaletteLookAndFeel.getInstance().getBorder("Ribbon.border"));
        this.toolsScrollPane.setHorizontalScrollBarPolicy(32);
        this.toolsScrollPane.setVerticalScrollBarPolicy(21);
        this.toolsScrollPane.setMinimumSize(new Dimension(0, 0));
        this.toolsPane.setForeground(new Color(153, 153, 153));
        this.toolsPane.add(this.creationToolBar);
        this.toolsPane.add(this.actionToolBar);
        this.toolsPane.add(this.fillToolBar);
        this.strokeToolBar.setMargin(new Insets(0, 10, 0, 0));
        this.toolsPane.add(this.strokeToolBar);
        this.toolsPane.add(this.fontToolBar);
        this.toolsPane.add(this.arrangeToolBar);
        this.toolsPane.add(this.alignToolBar);
        this.toolsPane.add(this.figureToolBar);
        this.toolsPane.add(this.linkToolBar);
        this.toolsPane.add(this.canvasToolBar);
        this.toolsPane.add(this.viewToolBar);
        this.toolsScrollPane.setViewportView(this.toolsPane);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.toolsPanel.add((Component)this.toolsScrollPane, gridBagConstraints);
        this.add((Component)this.toolsPanel, "South");
    }

    private class ItemChangeHandler
    implements ItemListener {
        private JToolBar toolbar;
        private String prefkey;

        public ItemChangeHandler(JToolBar toolbar, String prefkey) {
            this.toolbar = toolbar;
            this.prefkey = prefkey;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            boolean b = e.getStateChange() == 1;
            this.toolbar.setVisible(b);
            SVGDrawingPanel.this.prefs.putBoolean(this.prefkey, b);
            SVGDrawingPanel.this.validate();
        }
    }
}

