/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.odg.io;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Stack;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import javax.swing.JComponent;
import javax.swing.filechooser.FileFilter;
import net.n3.nanoxml.IXMLElement;
import net.n3.nanoxml.IXMLParser;
import net.n3.nanoxml.StdXMLReader;
import net.n3.nanoxml.XMLException;
import net.n3.nanoxml.XMLParserFactory;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.CompositeFigure;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.io.InputFormat;
import org.jhotdraw.geom.BezierPath;
import org.jhotdraw.gui.filechooser.ExtensionFileFilter;
import org.jhotdraw.io.StreamPosTokenizer;
import org.jhotdraw.samples.odg.ODGAttributeKeys;
import org.jhotdraw.samples.odg.figures.ODGBezierFigure;
import org.jhotdraw.samples.odg.figures.ODGEllipseFigure;
import org.jhotdraw.samples.odg.figures.ODGFigure;
import org.jhotdraw.samples.odg.figures.ODGGroupFigure;
import org.jhotdraw.samples.odg.figures.ODGPathFigure;
import org.jhotdraw.samples.odg.figures.ODGRectFigure;
import org.jhotdraw.samples.odg.geom.EnhancedPath;
import org.jhotdraw.samples.odg.io.ODGStylesReader;

public class ODGInputFormat
implements InputFormat {
    private static final boolean DEBUG = true;
    private LinkedList<Figure> figures;
    private IXMLElement document;
    private ODGStylesReader styles;

    @Override
    public FileFilter getFileFilter() {
        return new ExtensionFileFilter("Open Document Drawing (ODG)", "odg");
    }

    @Override
    public JComponent getInputFormatAccessory() {
        return null;
    }

    @Override
    public void read(URI uri, Drawing drawing) throws IOException {
        this.read(new File(uri), drawing);
    }

    @Override
    public void read(URI uri, Drawing drawing, boolean replace) throws IOException {
        this.read(new File(uri), drawing, replace);
    }

    public void read(File file, Drawing drawing) throws IOException {
        this.read(file, drawing, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(File file, Drawing drawing, boolean replace) throws IOException {
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
            this.read(in, drawing, replace);
        }
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor.getPrimaryType().equals("application") && flavor.getSubType().equals("vnd.oasis.opendocument.graphics");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(Transferable t, Drawing drawing, boolean replace) throws UnsupportedFlavorException, IOException {
        try (InputStream in = (InputStream)t.getTransferData(new DataFlavor("application/vnd.oasis.opendocument.graphics", "Image SVG"));){
            this.read(in, drawing, replace);
        }
    }

    private byte[] readAllBytes(InputStream in) throws IOException {
        int len;
        ByteArrayOutputStream tmp = new ByteArrayOutputStream();
        byte[] buf = new byte[512];
        while (-1 != (len = in.read(buf))) {
            tmp.write(buf, 0, len);
        }
        tmp.close();
        return tmp.toByteArray();
    }

    @Override
    public void read(InputStream in, Drawing drawing, boolean replace) throws IOException {
        byte[] tmp = this.readAllBytes(in);
        ByteArrayInputStream contentIn = null;
        ByteArrayInputStream stylesIn = null;
        boolean isZipped = true;
        try {
            ZipEntry entry;
            ZipInputStream zin = new ZipInputStream(new ByteArrayInputStream(tmp));
            while (null != (entry = zin.getNextEntry())) {
                if (entry.getName().equals("content.xml")) {
                    contentIn = new ByteArrayInputStream(this.readAllBytes(zin));
                    continue;
                }
                if (!entry.getName().equals("styles.xml")) continue;
                stylesIn = new ByteArrayInputStream(this.readAllBytes(zin));
            }
        }
        catch (ZipException e) {
            isZipped = false;
        }
        if (contentIn == null) {
            contentIn = new ByteArrayInputStream(tmp);
        }
        if (stylesIn == null) {
            stylesIn = new ByteArrayInputStream(tmp);
        }
        this.styles = new ODGStylesReader();
        this.styles.read(stylesIn);
        this.readFiguresFromDocumentContent(contentIn, drawing, replace);
    }

    public void readFiguresFromDocumentContent(InputStream in, Drawing drawing, boolean replace) throws IOException {
        IXMLParser parser;
        this.figures = new LinkedList();
        try {
            parser = XMLParserFactory.createDefaultXMLParser();
        }
        catch (Exception ex) {
            InternalError e = new InternalError("Unable to instantiate NanoXML Parser");
            e.initCause(ex);
            throw e;
        }
        StdXMLReader reader = new StdXMLReader(in);
        parser.setReader(reader);
        try {
            this.document = (IXMLElement)parser.parse();
        }
        catch (XMLException ex) {
            IOException e = new IOException(ex.getMessage());
            e.initCause(ex);
            throw e;
        }
        if (this.styles == null) {
            this.styles = new ODGStylesReader();
        }
        this.styles.read(this.document);
        IXMLElement drawingElem = this.document;
        Stack stack = new Stack();
        LinkedList<IXMLElement> ll = new LinkedList<IXMLElement>();
        ll.add(this.document);
        stack.push(ll.iterator());
        while (!stack.empty() && ((Iterator)stack.peek()).hasNext()) {
            Iterator iter = (Iterator)stack.peek();
            IXMLElement node = (IXMLElement)iter.next();
            Iterator<IXMLElement> children = node.getChildren().iterator();
            if (!iter.hasNext()) {
                stack.pop();
            }
            if (children.hasNext()) {
                stack.push(children);
            }
            if (node.getName() == null || !node.getName().equals("drawing") || node.getNamespace() != null && !node.getNamespace().equals("urn:oasis:names:tc:opendocument:xmlns:office:1.0")) continue;
            drawingElem = node;
            break;
        }
        if (drawingElem.getName() == null || !drawingElem.getName().equals("drawing") || drawingElem.getNamespace() != null && !drawingElem.getNamespace().equals("urn:oasis:names:tc:opendocument:xmlns:office:1.0")) {
            throw new IOException("'office:drawing' element expected: " + drawingElem.getName());
        }
        this.readDrawingElement(drawingElem);
        if (replace) {
            drawing.removeAllChildren();
        }
        drawing.addAll(this.figures);
    }

    private void readDrawingElement(IXMLElement elem) throws IOException {
        for (IXMLElement child : elem.getChildren()) {
            String name;
            if (child.getNamespace() != null && !child.getNamespace().equals("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0") || !(name = child.getName()).equals("page")) continue;
            this.readPageElement(child);
        }
    }

    private void readPageElement(IXMLElement elem) throws IOException {
        for (IXMLElement child : elem.getChildren()) {
            ODGFigure figure = this.readElement(child);
            if (figure == null) continue;
            this.figures.add(figure);
        }
    }

    @Nullable
    private ODGFigure readElement(IXMLElement elem) throws IOException {
        ODGFigure f = null;
        if (elem.getNamespace() == null || elem.getNamespace().equals("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0")) {
            String name = elem.getName();
            if (name.equals("caption")) {
                f = this.readCaptionElement(elem);
            } else if (name.equals("circle")) {
                f = this.readCircleElement(elem);
            } else if (name.equals("connector")) {
                f = this.readCircleElement(elem);
            } else if (name.equals("custom-shape")) {
                f = this.readCustomShapeElement(elem);
            } else if (name.equals("ellipse")) {
                f = this.readEllipseElement(elem);
            } else if (name.equals("frame")) {
                f = this.readFrameElement(elem);
            } else if (name.equals("g")) {
                f = this.readGElement(elem);
            } else if (name.equals("line")) {
                f = this.readLineElement(elem);
            } else if (name.equals("measure")) {
                f = this.readMeasureElement(elem);
            } else if (name.equals("path")) {
                f = this.readPathElement(elem);
            } else if (name.equals("polygon")) {
                f = this.readPolygonElement(elem);
            } else if (name.equals("polyline")) {
                f = this.readPolylineElement(elem);
            } else if (name.equals("rect")) {
                f = this.readRectElement(elem);
            } else if (name.equals("regularPolygon")) {
                f = this.readRegularPolygonElement(elem);
            } else {
                System.out.println("ODGInputFormat.readElement(" + elem + ") not implemented.");
            }
        }
        if (f != null) {
            if (f.isEmpty()) {
                System.out.println("ODGInputFormat.readElement():null - discarded empty figure " + f);
                return null;
            }
            System.out.println("ODGInputFormat.readElement():" + f + ".");
        }
        return f;
    }

    private ODGFigure readEllipseElement(IXMLElement elem) throws IOException {
        throw new UnsupportedOperationException("not implemented");
    }

    private ODGFigure readCircleElement(IXMLElement elem) throws IOException {
        throw new UnsupportedOperationException("not implemented");
    }

    private ODGFigure readCustomShapeElement(IXMLElement elem) throws IOException {
        String styleName = elem.getAttribute("style-name", "urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", null);
        Map<AttributeKey, Object> a = this.styles.getAttributes(styleName, "graphic");
        Rectangle2D.Double figureBounds = new Rectangle2D.Double(this.toLength(elem.getAttribute("x", "urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0", "0"), 1.0), this.toLength(elem.getAttribute("y", "urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0", "0"), 1.0), this.toLength(elem.getAttribute("width", "urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0", "0"), 1.0), this.toLength(elem.getAttribute("height", "urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0", "0"), 1.0));
        ODGFigure figure = null;
        for (IXMLElement child : elem.getChildrenNamed("enhanced-geometry", "urn:oasis:names:tc:opendocument:xmlns:drawing:1.0")) {
            figure = this.readEnhancedGeometryElement(child, a, figureBounds);
        }
        return figure;
    }

    @Nullable
    private ODGFigure readEnhancedGeometryElement(IXMLElement elem, Map<AttributeKey, Object> a, Rectangle2D.Double figureBounds) throws IOException {
        ODGFigure figure;
        String type = elem.getAttribute("type", "urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "non-primitive");
        if (elem.hasAttribute("enhanced-path", "urn:oasis:names:tc:opendocument:xmlns:drawing:1.0")) {
            EnhancedPath path = this.toEnhancedPath(elem.getAttribute("enhanced-path", "urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", null));
        } else {
            Object path = null;
        }
        String[] viewBoxValues = ODGInputFormat.toWSOrCommaSeparatedArray(elem.getAttribute("viewBox", "urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "0 0 100 100"));
        Rectangle2D.Double viewBox = new Rectangle2D.Double(this.toNumber(viewBoxValues[0]), this.toNumber(viewBoxValues[1]), this.toNumber(viewBoxValues[2]), this.toNumber(viewBoxValues[3]));
        AffineTransform viewTx = new AffineTransform();
        if (!viewBox.isEmpty()) {
            viewTx.scale(figureBounds.width / viewBox.width, figureBounds.height / viewBox.height);
            viewTx.translate(figureBounds.x - viewBox.x, figureBounds.y - viewBox.y);
        }
        boolean mirrorVertical = elem.getAttribute("mirror-vertical", "urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "false").equals("true");
        boolean mirrorHorizontal = elem.getAttribute("mirror-horizontal", "urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "false").equals("true");
        if (type.equals("rectangle")) {
            figure = this.createEnhancedGeometryRectangleFigure(figureBounds, a);
        } else if (type.equals("ellipse")) {
            figure = this.createEnhancedGeometryEllipseFigure(figureBounds, a);
        } else {
            System.out.println("ODGInputFormat.readEnhancedGeometryElement not implemented for " + elem);
            figure = null;
        }
        return figure;
    }

    private ODGFigure createEnhancedGeometryEllipseFigure(Rectangle2D.Double bounds, Map<AttributeKey, Object> a) throws IOException {
        ODGEllipseFigure figure = new ODGEllipseFigure();
        figure.setBounds(bounds);
        figure.setAttributes(a);
        return figure;
    }

    private ODGFigure createEnhancedGeometryRectangleFigure(Rectangle2D.Double bounds, Map<AttributeKey, Object> a) throws IOException {
        ODGRectFigure figure = new ODGRectFigure();
        figure.setBounds(bounds);
        figure.setAttributes(a);
        return figure;
    }

    private ODGFigure createLineFigure(Point2D.Double p1, Point2D.Double p2, Map<AttributeKey, Object> a) throws IOException {
        ODGPathFigure figure = new ODGPathFigure();
        figure.setBounds(p1, p2);
        figure.setAttributes(a);
        return figure;
    }

    private ODGFigure createPolylineFigure(Point2D.Double[] points, Map<AttributeKey, Object> a) throws IOException {
        ODGPathFigure figure = new ODGPathFigure();
        ODGBezierFigure bezier = new ODGBezierFigure();
        for (Point2D.Double p : points) {
            bezier.addNode(new BezierPath.Node(p.x, p.y));
        }
        figure.removeAllChildren();
        figure.add(bezier);
        figure.setAttributes(a);
        return figure;
    }

    private ODGFigure createPolygonFigure(Point2D.Double[] points, Map<AttributeKey, Object> a) throws IOException {
        ODGPathFigure figure = new ODGPathFigure();
        ODGBezierFigure bezier = new ODGBezierFigure();
        for (Point2D.Double p : points) {
            bezier.addNode(new BezierPath.Node(p.x, p.y));
        }
        bezier.setClosed(true);
        figure.removeAllChildren();
        figure.add(bezier);
        figure.setAttributes(a);
        return figure;
    }

    private ODGFigure createPathFigure(BezierPath[] paths, Map<AttributeKey, Object> a) throws IOException {
        ODGPathFigure figure = new ODGPathFigure();
        figure.removeAllChildren();
        for (BezierPath p : paths) {
            ODGBezierFigure bezier = new ODGBezierFigure();
            bezier.setBezierPath(p);
            figure.add(bezier);
        }
        figure.setAttributes(a);
        return figure;
    }

    private ODGFigure readFrameElement(IXMLElement elem) throws IOException {
        throw new UnsupportedOperationException("not implemented.");
    }

    private CompositeFigure createGroupFigure() throws IOException {
        ODGGroupFigure figure = new ODGGroupFigure();
        return figure;
    }

    private ODGFigure readGElement(IXMLElement elem) throws IOException {
        CompositeFigure g = this.createGroupFigure();
        for (IXMLElement child : elem.getChildren()) {
            ODGFigure childFigure = this.readElement(child);
            if (childFigure == null) continue;
            g.basicAdd(childFigure);
        }
        return (ODGFigure)((Object)g);
    }

    private ODGFigure readLineElement(IXMLElement elem) throws IOException {
        Point2D.Double p1 = new Point2D.Double(this.toLength(elem.getAttribute("x1", "urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0", "0"), 1.0), this.toLength(elem.getAttribute("y1", "urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0", "0"), 1.0));
        Point2D.Double p2 = new Point2D.Double(this.toLength(elem.getAttribute("x2", "urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0", "0"), 1.0), this.toLength(elem.getAttribute("y2", "urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0", "0"), 1.0));
        String styleName = elem.getAttribute("style-name", "urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", null);
        Map<AttributeKey, Object> a = this.styles.getAttributes(styleName, "graphic");
        ODGFigure f = this.createLineFigure(p1, p2, a);
        return f;
    }

    private ODGFigure readPathElement(IXMLElement elem) throws IOException {
        BezierPath[] paths;
        AffineTransform viewBoxTransform = this.readViewBoxTransform(elem);
        for (BezierPath p : paths = this.toPath(elem.getAttribute("d", "urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0", null))) {
            p.transform(viewBoxTransform);
        }
        String styleName = elem.getAttribute("style-name", "urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", null);
        HashMap<AttributeKey, Object> a = new HashMap<AttributeKey, Object>();
        a.putAll(this.styles.getAttributes(styleName, "graphic"));
        this.readCommonDrawingShapeAttributes(elem, a);
        ODGFigure f = this.createPathFigure(paths, a);
        return f;
    }

    private ODGFigure readPolygonElement(IXMLElement elem) throws IOException {
        AffineTransform viewBoxTransform = this.readViewBoxTransform(elem);
        String[] coords = ODGInputFormat.toWSOrCommaSeparatedArray(elem.getAttribute("points", "urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", null));
        Point2D.Double[] points = new Point2D.Double[coords.length / 2];
        for (int i = 0; i < coords.length; i += 2) {
            Point2D.Double p = new Point2D.Double(this.toNumber(coords[i]), this.toNumber(coords[i + 1]));
            points[i / 2] = (Point2D.Double)viewBoxTransform.transform(p, p);
        }
        String styleName = elem.getAttribute("style-name", "urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", null);
        HashMap<AttributeKey, Object> a = new HashMap<AttributeKey, Object>();
        a.putAll(this.styles.getAttributes(styleName, "graphic"));
        this.readCommonDrawingShapeAttributes(elem, a);
        ODGFigure f = this.createPolygonFigure(points, a);
        return f;
    }

    private ODGFigure readPolylineElement(IXMLElement elem) throws IOException {
        AffineTransform viewBoxTransform = this.readViewBoxTransform(elem);
        String[] coords = ODGInputFormat.toWSOrCommaSeparatedArray(elem.getAttribute("points", "urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", null));
        Point2D.Double[] points = new Point2D.Double[coords.length / 2];
        for (int i = 0; i < coords.length; i += 2) {
            Point2D.Double p = new Point2D.Double(this.toNumber(coords[i]), this.toNumber(coords[i + 1]));
            points[i / 2] = (Point2D.Double)viewBoxTransform.transform(p, p);
        }
        String styleName = elem.getAttribute("style-name", "urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", null);
        HashMap<AttributeKey, Object> a = new HashMap<AttributeKey, Object>();
        a.putAll(this.styles.getAttributes(styleName, "graphic"));
        this.readCommonDrawingShapeAttributes(elem, a);
        ODGFigure f = this.createPolylineFigure(points, a);
        return f;
    }

    private ODGFigure readRectElement(IXMLElement elem) throws IOException {
        throw new UnsupportedOperationException("ODGInputFormat.readRectElement(" + elem + "):null - not implemented");
    }

    private ODGFigure readRegularPolygonElement(IXMLElement elem) throws IOException {
        throw new UnsupportedOperationException("ODGInputFormat.readRegularPolygonElement(" + elem + "):null - not implemented");
    }

    private ODGFigure readMeasureElement(IXMLElement elem) throws IOException {
        throw new UnsupportedOperationException("ODGInputFormat.readMeasureElement(" + elem + "):null - not implemented");
    }

    private ODGFigure readCaptionElement(IXMLElement elem) throws IOException {
        throw new UnsupportedOperationException("ODGInputFormat.readCaptureElement(" + elem + "):null - not implemented");
    }

    public static String[] toWSOrCommaSeparatedArray(String str) throws IOException {
        String[] result = str.split("(\\s*,\\s*|\\s+)");
        if (result.length == 1 && result[0].equals("")) {
            return new String[0];
        }
        return result;
    }

    private double toNumber(String str) throws IOException {
        return this.toLength(str, 100.0);
    }

    private double toLength(String str, double percentFactor) throws IOException {
        double scaleFactor = 1.0;
        if (str == null || str.length() == 0) {
            return 0.0;
        }
        if (str.endsWith("%")) {
            str = str.substring(0, str.length() - 1);
            scaleFactor = percentFactor;
        } else if (str.endsWith("px")) {
            str = str.substring(0, str.length() - 2);
        } else if (str.endsWith("pt")) {
            str = str.substring(0, str.length() - 2);
            scaleFactor = 1.25;
        } else if (str.endsWith("pc")) {
            str = str.substring(0, str.length() - 2);
            scaleFactor = 15.0;
        } else if (str.endsWith("mm")) {
            str = str.substring(0, str.length() - 2);
            scaleFactor = 3.543307;
        } else if (str.endsWith("cm")) {
            str = str.substring(0, str.length() - 2);
            scaleFactor = 35.43307;
        } else if (str.endsWith("in")) {
            str = str.substring(0, str.length() - 2);
            scaleFactor = 90.0;
        } else {
            scaleFactor = 1.0;
        }
        return Double.parseDouble(str) * scaleFactor;
    }

    private static double toUnitFactor(String str) throws IOException {
        double scaleFactor = str.equals("px") ? 1.0 : (str.endsWith("pt") ? 1.25 : (str.endsWith("pc") ? 15.0 : (str.endsWith("mm") ? 3.543307 : (str.endsWith("cm") ? 35.43307 : (str.endsWith("in") ? 90.0 : 1.0)))));
        return scaleFactor;
    }

    private EnhancedPath toEnhancedPath(String str) throws IOException {
        System.out.println("ODGInputFormat toEnhancedPath " + str);
        EnhancedPath path = null;
        StreamPosTokenizer tt = new StreamPosTokenizer(new StringReader(str));
        tt.resetSyntax();
        tt.parseNumbers();
        tt.parseExponents();
        tt.parsePlusAsNumber();
        tt.whitespaceChars(0, 32);
        tt.whitespaceChars(44, 44);
        int nextCommand = 77;
        int command = 77;
        block18: while (tt.nextToken() != -1) {
            if (tt.ttype > 0) {
                command = (char)tt.ttype;
            } else {
                command = nextCommand;
                tt.pushBack();
            }
            nextCommand = command;
            switch (command) {
                case 77: {
                    if (path == null) {
                        path = new EnhancedPath();
                    }
                    Object x = this.nextEnhancedCoordinate(tt, str);
                    Object y = this.nextEnhancedCoordinate(tt, str);
                    path.moveTo(x, y);
                    nextCommand = 76;
                    continue block18;
                }
                case 76: {
                    Object x = this.nextEnhancedCoordinate(tt, str);
                    Object y = this.nextEnhancedCoordinate(tt, str);
                    path.lineTo(x, y);
                    continue block18;
                }
                case 67: {
                    Object x1 = this.nextEnhancedCoordinate(tt, str);
                    Object y1 = this.nextEnhancedCoordinate(tt, str);
                    Object x2 = this.nextEnhancedCoordinate(tt, str);
                    Object y2 = this.nextEnhancedCoordinate(tt, str);
                    Object x = this.nextEnhancedCoordinate(tt, str);
                    Object y = this.nextEnhancedCoordinate(tt, str);
                    path.curveTo(x1, y1, x2, y2, x, y);
                    continue block18;
                }
                case 90: {
                    path.close();
                    continue block18;
                }
                case 78: {
                    continue block18;
                }
                case 70: {
                    continue block18;
                }
                case 83: {
                    continue block18;
                }
                case 84: {
                    Object x = this.nextEnhancedCoordinate(tt, str);
                    Object y = this.nextEnhancedCoordinate(tt, str);
                    Object x1 = this.nextEnhancedCoordinate(tt, str);
                    Object y1 = this.nextEnhancedCoordinate(tt, str);
                    Object x2 = this.nextEnhancedCoordinate(tt, str);
                    Object y2 = this.nextEnhancedCoordinate(tt, str);
                    path.ellipseTo(x, y, x1, y1, x2, y2);
                    continue block18;
                }
                case 85: {
                    Object x = this.nextEnhancedCoordinate(tt, str);
                    Object y = this.nextEnhancedCoordinate(tt, str);
                    Object x1 = this.nextEnhancedCoordinate(tt, str);
                    Object y1 = this.nextEnhancedCoordinate(tt, str);
                    Object x2 = this.nextEnhancedCoordinate(tt, str);
                    Object y2 = this.nextEnhancedCoordinate(tt, str);
                    path.moveTo(x1, y1);
                    path.ellipseTo(x, y, x1, y1, x2, y2);
                    continue block18;
                }
                case 65: {
                    Object x1 = this.nextEnhancedCoordinate(tt, str);
                    Object y1 = this.nextEnhancedCoordinate(tt, str);
                    Object x2 = this.nextEnhancedCoordinate(tt, str);
                    Object y2 = this.nextEnhancedCoordinate(tt, str);
                    Object x3 = this.nextEnhancedCoordinate(tt, str);
                    Object y3 = this.nextEnhancedCoordinate(tt, str);
                    Object x = this.nextEnhancedCoordinate(tt, str);
                    Object y = this.nextEnhancedCoordinate(tt, str);
                    path.arcTo(x1, y1, x2, y2, x3, y3, x, y);
                    continue block18;
                }
                case 66: {
                    Object x1 = this.nextEnhancedCoordinate(tt, str);
                    Object y1 = this.nextEnhancedCoordinate(tt, str);
                    Object x2 = this.nextEnhancedCoordinate(tt, str);
                    Object y2 = this.nextEnhancedCoordinate(tt, str);
                    Object x3 = this.nextEnhancedCoordinate(tt, str);
                    Object y3 = this.nextEnhancedCoordinate(tt, str);
                    Object x = this.nextEnhancedCoordinate(tt, str);
                    Object y = this.nextEnhancedCoordinate(tt, str);
                    path.moveTo(x1, y1);
                    path.arcTo(x1, y1, x2, y2, x3, y3, x, y);
                    continue block18;
                }
                case 87: {
                    Object x1 = this.nextEnhancedCoordinate(tt, str);
                    Object y1 = this.nextEnhancedCoordinate(tt, str);
                    Object x2 = this.nextEnhancedCoordinate(tt, str);
                    Object y2 = this.nextEnhancedCoordinate(tt, str);
                    Object x3 = this.nextEnhancedCoordinate(tt, str);
                    Object y3 = this.nextEnhancedCoordinate(tt, str);
                    Object x = this.nextEnhancedCoordinate(tt, str);
                    Object y = this.nextEnhancedCoordinate(tt, str);
                    path.clockwiseArcTo(x1, y1, x2, y2, x3, y3, x, y);
                    continue block18;
                }
                case 86: {
                    Object x1 = this.nextEnhancedCoordinate(tt, str);
                    Object y1 = this.nextEnhancedCoordinate(tt, str);
                    Object x2 = this.nextEnhancedCoordinate(tt, str);
                    Object y2 = this.nextEnhancedCoordinate(tt, str);
                    Object x3 = this.nextEnhancedCoordinate(tt, str);
                    Object y3 = this.nextEnhancedCoordinate(tt, str);
                    Object x = this.nextEnhancedCoordinate(tt, str);
                    Object y = this.nextEnhancedCoordinate(tt, str);
                    path.moveTo(x1, y1);
                    path.clockwiseArcTo(x1, y1, x2, y2, x3, y3, x, y);
                    continue block18;
                }
                case 88: {
                    Object x = this.nextEnhancedCoordinate(tt, str);
                    Object y = this.nextEnhancedCoordinate(tt, str);
                    path.quadrantXTo(x, y);
                    continue block18;
                }
                case 89: {
                    Object x = this.nextEnhancedCoordinate(tt, str);
                    Object y = this.nextEnhancedCoordinate(tt, str);
                    path.quadrantYTo(x, y);
                    continue block18;
                }
                case 81: {
                    Object x1 = this.nextEnhancedCoordinate(tt, str);
                    Object y1 = this.nextEnhancedCoordinate(tt, str);
                    Object x = this.nextEnhancedCoordinate(tt, str);
                    Object y = this.nextEnhancedCoordinate(tt, str);
                    path.quadTo(x1, y1, x, y);
                    continue block18;
                }
            }
            System.out.println("ODGInputFormat.toEnhancedPath aborting after illegal path command: " + (char)command + " found in path " + str);
            break;
        }
        return path;
    }

    private Object nextEnhancedCoordinate(StreamPosTokenizer tt, String str) throws IOException {
        switch (tt.nextToken()) {
            case 63: {
                StringBuilder buf = new StringBuilder();
                buf.append('?');
                int ch = tt.nextChar();
                while (ch >= 97 && ch <= 122 || ch >= 65 && ch <= 90 || ch >= 48 && ch <= 57) {
                    buf.append((char)ch);
                    ch = tt.nextChar();
                }
                tt.pushCharBack(ch);
                return buf.toString();
            }
            case 36: {
                StringBuilder buf = new StringBuilder();
                buf.append('$');
                int ch = tt.nextChar();
                while (ch >= 48 && ch <= 57) {
                    buf.append((char)ch);
                    ch = tt.nextChar();
                }
                tt.pushCharBack(ch);
                return buf.toString();
            }
            case -2: {
                return tt.nval;
            }
        }
        throw new IOException("coordinate missing at position" + tt.getStartPosition() + " in " + str);
    }

    private void readCommonDrawingShapeAttributes(IXMLElement elem, HashMap<AttributeKey, Object> a) throws IOException {
        ODGAttributeKeys.NAME.put(a, elem.getAttribute("name", "urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", null));
        ODGAttributeKeys.TRANSFORM.put(a, ODGInputFormat.toTransform(elem.getAttribute("transform", "urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", null)));
    }

    private AffineTransform readViewBoxTransform(IXMLElement elem) throws IOException {
        Rectangle2D.Double viewBox;
        AffineTransform tx = new AffineTransform();
        Rectangle2D.Double figureBounds = new Rectangle2D.Double(this.toLength(elem.getAttribute("x", "urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0", "0"), 1.0), this.toLength(elem.getAttribute("y", "urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0", "0"), 1.0), this.toLength(elem.getAttribute("width", "urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0", "0"), 1.0), this.toLength(elem.getAttribute("height", "urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0", "0"), 1.0));
        tx.translate(figureBounds.x, figureBounds.y);
        String[] viewBoxValues = ODGInputFormat.toWSOrCommaSeparatedArray(elem.getAttribute("viewBox", "urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0", null));
        if (viewBoxValues.length == 4 && !(viewBox = new Rectangle2D.Double(this.toNumber(viewBoxValues[0]), this.toNumber(viewBoxValues[1]), this.toNumber(viewBoxValues[2]), this.toNumber(viewBoxValues[3]))).isEmpty() && !figureBounds.isEmpty()) {
            tx.scale(figureBounds.width / viewBox.width, figureBounds.height / viewBox.height);
            tx.translate(-viewBox.x, -viewBox.y);
        }
        return tx;
    }

    public static AffineTransform toTransform(String str) throws IOException {
        AffineTransform t = new AffineTransform();
        AffineTransform t2 = new AffineTransform();
        if (str != null) {
            StreamPosTokenizer tt = new StreamPosTokenizer(new StringReader(str));
            tt.resetSyntax();
            tt.wordChars(97, 122);
            tt.wordChars(65, 90);
            tt.wordChars(160, 255);
            tt.whitespaceChars(0, 32);
            tt.whitespaceChars(44, 44);
            tt.parseNumbers();
            tt.parseExponents();
            while (tt.nextToken() != -1) {
                if (tt.ttype != -3) {
                    throw new IOException("Illegal transform " + str);
                }
                String type = tt.sval;
                if (tt.nextToken() != 40) {
                    throw new IOException("'(' not found in transform " + str);
                }
                if (type.equals("matrix")) {
                    double[] m = new double[6];
                    for (int i = 0; i < 6; ++i) {
                        if (tt.nextToken() != -2) {
                            throw new IOException("Matrix value " + i + " not found in transform " + str + " token:" + tt.ttype + " " + tt.sval);
                        }
                        m[i] = tt.nval;
                    }
                    t.preConcatenate(new AffineTransform(m));
                } else if (type.equals("translate")) {
                    double ty;
                    if (tt.nextToken() != -2) {
                        throw new IOException("X-translation value not found in transform " + str);
                    }
                    double tx = tt.nval;
                    if (tt.nextToken() == -3) {
                        tx *= ODGInputFormat.toUnitFactor(tt.sval);
                    } else {
                        tt.pushBack();
                    }
                    if (tt.nextToken() == -2) {
                        ty = tt.nval;
                        if (tt.nextToken() == -3) {
                            ty *= ODGInputFormat.toUnitFactor(tt.sval);
                        } else {
                            tt.pushBack();
                        }
                    } else {
                        tt.pushBack();
                        ty = 0.0;
                    }
                    t2.setToIdentity();
                    t2.translate(tx, ty);
                    t.preConcatenate(t2);
                } else if (type.equals("scale")) {
                    double sy;
                    if (tt.nextToken() != -2) {
                        throw new IOException("X-scale value not found in transform " + str);
                    }
                    double sx = tt.nval;
                    if (tt.nextToken() == -2) {
                        sy = tt.nval;
                    } else {
                        tt.pushBack();
                        sy = sx;
                    }
                    t2.setToIdentity();
                    t2.scale(sx, sy);
                    t.preConcatenate(t2);
                } else if (type.equals("rotate")) {
                    if (tt.nextToken() != -2) {
                        throw new IOException("Angle value not found in transform " + str);
                    }
                    double angle = tt.nval;
                    t2.setToIdentity();
                    t2.rotate(-angle);
                    t.preConcatenate(t2);
                } else if (type.equals("skewX")) {
                    if (tt.nextToken() != -2) {
                        throw new IOException("Skew angle not found in transform " + str);
                    }
                    double angle = tt.nval;
                    t.preConcatenate(new AffineTransform(1.0, 0.0, Math.tan(angle * Math.PI / 180.0), 1.0, 0.0, 0.0));
                } else if (type.equals("skewY")) {
                    if (tt.nextToken() != -2) {
                        throw new IOException("Skew angle not found in transform " + str);
                    }
                    double angle = tt.nval;
                    t.preConcatenate(new AffineTransform(1.0, Math.tan(angle * Math.PI / 180.0), 0.0, 1.0, 0.0, 0.0));
                } else {
                    throw new IOException("Unknown transform " + type + " in " + str);
                }
                if (tt.nextToken() == 41) continue;
                throw new IOException("')' not found in transform " + str);
            }
        }
        return t;
    }

    private BezierPath[] toPath(String str) throws IOException {
        LinkedList<ArrayList> paths = new LinkedList<ArrayList>();
        ArrayList path = null;
        Point2D.Double p = new Point2D.Double();
        Point2D.Double c1 = new Point2D.Double();
        Point2D.Double c2 = new Point2D.Double();
        StreamPosTokenizer tt = new StreamPosTokenizer(new StringReader(str));
        tt.resetSyntax();
        tt.parseNumbers();
        tt.parseExponents();
        tt.parsePlusAsNumber();
        tt.whitespaceChars(0, 32);
        tt.whitespaceChars(44, 44);
        int nextCommand = 77;
        int command = 77;
        block21: while (tt.nextToken() != -1) {
            if (tt.ttype > 0) {
                command = (char)tt.ttype;
            } else {
                command = nextCommand;
                tt.pushBack();
            }
            switch (command) {
                case 77: {
                    if (path != null) {
                        paths.add(path);
                    }
                    path = new BezierPath();
                    if (tt.nextToken() != -2) {
                        throw new IOException("x coordinate missing for 'M' at position " + tt.getStartPosition() + " in " + str);
                    }
                    p.x = tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("y coordinate missing for 'M' at position " + tt.getStartPosition() + " in " + str);
                    }
                    p.y = tt.nval;
                    ((BezierPath)path).moveTo(p.x, p.y);
                    nextCommand = 76;
                    continue block21;
                }
                case 109: {
                    if (path != null) {
                        paths.add(path);
                    }
                    path = new BezierPath();
                    if (tt.nextToken() != -2) {
                        throw new IOException("dx coordinate missing for 'm' at position " + tt.getStartPosition() + " in " + str);
                    }
                    p.x += tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("dy coordinate missing for 'm' at position " + tt.getStartPosition() + " in " + str);
                    }
                    p.y += tt.nval;
                    ((BezierPath)path).moveTo(p.x, p.y);
                    nextCommand = 108;
                    continue block21;
                }
                case 90: 
                case 122: {
                    p.x = ((BezierPath.Node)path.get((int)0)).x[0];
                    p.y = ((BezierPath.Node)path.get((int)0)).y[0];
                    if (path.size() > 1) {
                        BezierPath.Node first = (BezierPath.Node)path.get(0);
                        BezierPath.Node last = (BezierPath.Node)path.get(path.size() - 1);
                        if (first.x[0] == last.x[0] && first.y[0] == last.y[0]) {
                            if ((last.mask & 1) != 0) {
                                first.mask |= 1;
                                first.x[1] = last.x[1];
                                first.y[1] = last.y[1];
                            }
                            path.remove(path.size() - 1);
                        }
                    }
                    ((BezierPath)path).setClosed(true);
                    continue block21;
                }
                case 76: {
                    if (tt.nextToken() != -2) {
                        throw new IOException("x coordinate missing for 'L' at position " + tt.getStartPosition() + " in " + str);
                    }
                    p.x = tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("y coordinate missing for 'L' at position " + tt.getStartPosition() + " in " + str);
                    }
                    p.y = tt.nval;
                    ((BezierPath)path).lineTo(p.x, p.y);
                    nextCommand = 76;
                    continue block21;
                }
                case 108: {
                    if (tt.nextToken() != -2) {
                        throw new IOException("dx coordinate missing for 'l' at position " + tt.getStartPosition() + " in " + str);
                    }
                    p.x += tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("dy coordinate missing for 'l' at position " + tt.getStartPosition() + " in " + str);
                    }
                    p.y += tt.nval;
                    ((BezierPath)path).lineTo(p.x, p.y);
                    nextCommand = 108;
                    continue block21;
                }
                case 72: {
                    if (tt.nextToken() != -2) {
                        throw new IOException("x coordinate missing for 'H' at position " + tt.getStartPosition() + " in " + str);
                    }
                    p.x = tt.nval;
                    ((BezierPath)path).lineTo(p.x, p.y);
                    nextCommand = 72;
                    continue block21;
                }
                case 104: {
                    if (tt.nextToken() != -2) {
                        throw new IOException("dx coordinate missing for 'h' at position " + tt.getStartPosition() + " in " + str);
                    }
                    p.x += tt.nval;
                    ((BezierPath)path).lineTo(p.x, p.y);
                    nextCommand = 104;
                    continue block21;
                }
                case 86: {
                    if (tt.nextToken() != -2) {
                        throw new IOException("y coordinate missing for 'V' at position " + tt.getStartPosition() + " in " + str);
                    }
                    p.y = tt.nval;
                    ((BezierPath)path).lineTo(p.x, p.y);
                    nextCommand = 86;
                    continue block21;
                }
                case 118: {
                    if (tt.nextToken() != -2) {
                        throw new IOException("dy coordinate missing for 'v' at position " + tt.getStartPosition() + " in " + str);
                    }
                    p.y += tt.nval;
                    ((BezierPath)path).lineTo(p.x, p.y);
                    nextCommand = 118;
                    continue block21;
                }
                case 67: {
                    if (tt.nextToken() != -2) {
                        throw new IOException("x1 coordinate missing for 'C' at position " + tt.getStartPosition() + " in " + str);
                    }
                    c1.x = tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("y1 coordinate missing for 'C' at position " + tt.getStartPosition() + " in " + str);
                    }
                    c1.y = tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("x2 coordinate missing for 'C' at position " + tt.getStartPosition() + " in " + str);
                    }
                    c2.x = tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("y2 coordinate missing for 'C' at position " + tt.getStartPosition() + " in " + str);
                    }
                    c2.y = tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("x coordinate missing for 'C' at position " + tt.getStartPosition() + " in " + str);
                    }
                    p.x = tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("y coordinate missing for 'C' at position " + tt.getStartPosition() + " in " + str);
                    }
                    p.y = tt.nval;
                    ((BezierPath)path).curveTo(c1.x, c1.y, c2.x, c2.y, p.x, p.y);
                    nextCommand = 67;
                    continue block21;
                }
                case 99: {
                    if (tt.nextToken() != -2) {
                        throw new IOException("dx1 coordinate missing for 'c' at position " + tt.getStartPosition() + " in " + str);
                    }
                    c1.x = p.x + tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("dy1 coordinate missing for 'c' at position " + tt.getStartPosition() + " in " + str);
                    }
                    c1.y = p.y + tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("dx2 coordinate missing for 'c' at position " + tt.getStartPosition() + " in " + str);
                    }
                    c2.x = p.x + tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("dy2 coordinate missing for 'c' at position " + tt.getStartPosition() + " in " + str);
                    }
                    c2.y = p.y + tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("dx coordinate missing for 'c' at position " + tt.getStartPosition() + " in " + str);
                    }
                    p.x += tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("dy coordinate missing for 'c' at position " + tt.getStartPosition() + " in " + str);
                    }
                    p.y += tt.nval;
                    ((BezierPath)path).curveTo(c1.x, c1.y, c2.x, c2.y, p.x, p.y);
                    nextCommand = 99;
                    continue block21;
                }
                case 83: {
                    BezierPath.Node node = (BezierPath.Node)path.get(path.size() - 1);
                    c1.x = node.x[0] * 2.0 - node.x[1];
                    c1.y = node.y[0] * 2.0 - node.y[1];
                    if (tt.nextToken() != -2) {
                        throw new IOException("x2 coordinate missing for 'S' at position " + tt.getStartPosition() + " in " + str);
                    }
                    c2.x = tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("y2 coordinate missing for 'S' at position " + tt.getStartPosition() + " in " + str);
                    }
                    c2.y = tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("x coordinate missing for 'S' at position " + tt.getStartPosition() + " in " + str);
                    }
                    p.x = tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("y coordinate missing for 'S' at position " + tt.getStartPosition() + " in " + str);
                    }
                    p.y = tt.nval;
                    ((BezierPath)path).curveTo(c1.x, c1.y, c2.x, c2.y, p.x, p.y);
                    nextCommand = 83;
                    continue block21;
                }
                case 115: {
                    BezierPath.Node node = (BezierPath.Node)path.get(path.size() - 1);
                    c1.x = node.x[0] * 2.0 - node.x[1];
                    c1.y = node.y[0] * 2.0 - node.y[1];
                    if (tt.nextToken() != -2) {
                        throw new IOException("dx2 coordinate missing for 's' at position " + tt.getStartPosition() + " in " + str);
                    }
                    c2.x = p.x + tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("dy2 coordinate missing for 's' at position " + tt.getStartPosition() + " in " + str);
                    }
                    c2.y = p.y + tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("dx coordinate missing for 's' at position " + tt.getStartPosition() + " in " + str);
                    }
                    p.x += tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("dy coordinate missing for 's' at position " + tt.getStartPosition() + " in " + str);
                    }
                    p.y += tt.nval;
                    ((BezierPath)path).curveTo(c1.x, c1.y, c2.x, c2.y, p.x, p.y);
                    nextCommand = 115;
                    continue block21;
                }
                case 81: {
                    if (tt.nextToken() != -2) {
                        throw new IOException("x1 coordinate missing for 'Q' at position " + tt.getStartPosition() + " in " + str);
                    }
                    c1.x = tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("y1 coordinate missing for 'Q' at position " + tt.getStartPosition() + " in " + str);
                    }
                    c1.y = tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("x coordinate missing for 'Q' at position " + tt.getStartPosition() + " in " + str);
                    }
                    p.x = tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("y coordinate missing for 'Q' at position " + tt.getStartPosition() + " in " + str);
                    }
                    p.y = tt.nval;
                    ((BezierPath)path).quadTo(c1.x, c1.y, p.x, p.y);
                    nextCommand = 81;
                    continue block21;
                }
                case 113: {
                    if (tt.nextToken() != -2) {
                        throw new IOException("dx1 coordinate missing for 'q' at position " + tt.getStartPosition() + " in " + str);
                    }
                    c1.x = p.x + tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("dy1 coordinate missing for 'q' at position " + tt.getStartPosition() + " in " + str);
                    }
                    c1.y = p.y + tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("dx coordinate missing for 'q' at position " + tt.getStartPosition() + " in " + str);
                    }
                    p.x += tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("dy coordinate missing for 'q' at position " + tt.getStartPosition() + " in " + str);
                    }
                    p.y += tt.nval;
                    ((BezierPath)path).quadTo(c1.x, c1.y, p.x, p.y);
                    nextCommand = 113;
                    continue block21;
                }
                case 84: {
                    BezierPath.Node node = (BezierPath.Node)path.get(path.size() - 1);
                    c1.x = node.x[0] * 2.0 - node.x[1];
                    c1.y = node.y[0] * 2.0 - node.y[1];
                    if (tt.nextToken() != -2) {
                        throw new IOException("x coordinate missing for 'T' at position " + tt.getStartPosition() + " in " + str);
                    }
                    p.x = tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("y coordinate missing for 'T' at position " + tt.getStartPosition() + " in " + str);
                    }
                    p.y = tt.nval;
                    ((BezierPath)path).quadTo(c1.x, c1.y, p.x, p.y);
                    nextCommand = 84;
                    continue block21;
                }
                case 116: {
                    BezierPath.Node node = (BezierPath.Node)path.get(path.size() - 1);
                    c1.x = node.x[0] * 2.0 - node.x[1];
                    c1.y = node.y[0] * 2.0 - node.y[1];
                    if (tt.nextToken() != -2) {
                        throw new IOException("dx coordinate missing for 't' at position " + tt.getStartPosition() + " in " + str);
                    }
                    p.x += tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("dy coordinate missing for 't' at position " + tt.getStartPosition() + " in " + str);
                    }
                    p.y += tt.nval;
                    ((BezierPath)path).quadTo(c1.x, c1.y, p.x, p.y);
                    nextCommand = 115;
                    continue block21;
                }
                case 65: {
                    boolean sweepFlag;
                    boolean largeArcFlag;
                    if (tt.nextToken() != -2) {
                        throw new IOException("rx coordinate missing for 'A' at position " + tt.getStartPosition() + " in " + str);
                    }
                    double rx = tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("ry coordinate missing for 'A' at position " + tt.getStartPosition() + " in " + str);
                    }
                    double ry = tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("x-axis-rotation missing for 'A' at position " + tt.getStartPosition() + " in " + str);
                    }
                    double xAxisRotation = tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("large-arc-flag missing for 'A' at position " + tt.getStartPosition() + " in " + str);
                    }
                    boolean bl = largeArcFlag = tt.nval != 0.0;
                    if (tt.nextToken() != -2) {
                        throw new IOException("sweep-flag missing for 'A' at position " + tt.getStartPosition() + " in " + str);
                    }
                    boolean bl2 = sweepFlag = tt.nval != 0.0;
                    if (tt.nextToken() != -2) {
                        throw new IOException("x coordinate missing for 'A' at position " + tt.getStartPosition() + " in " + str);
                    }
                    p.x = tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("y coordinate missing for 'A' at position " + tt.getStartPosition() + " in " + str);
                    }
                    p.y = tt.nval;
                    ((BezierPath)path).arcTo(rx, ry, xAxisRotation, largeArcFlag, sweepFlag, p.x, p.y);
                    nextCommand = 65;
                    continue block21;
                }
                case 97: {
                    boolean sweepFlag;
                    boolean largeArcFlag;
                    if (tt.nextToken() != -2) {
                        throw new IOException("rx coordinate missing for 'A' at position " + tt.getStartPosition() + " in " + str);
                    }
                    double rx = tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("ry coordinate missing for 'A' at position " + tt.getStartPosition() + " in " + str);
                    }
                    double ry = tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("x-axis-rotation missing for 'A' at position " + tt.getStartPosition() + " in " + str);
                    }
                    double xAxisRotation = tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("large-arc-flag missing for 'A' at position " + tt.getStartPosition() + " in " + str);
                    }
                    boolean bl = largeArcFlag = tt.nval != 0.0;
                    if (tt.nextToken() != -2) {
                        throw new IOException("sweep-flag missing for 'A' at position " + tt.getStartPosition() + " in " + str);
                    }
                    boolean bl3 = sweepFlag = tt.nval != 0.0;
                    if (tt.nextToken() != -2) {
                        throw new IOException("x coordinate missing for 'A' at position " + tt.getStartPosition() + " in " + str);
                    }
                    p.x += tt.nval;
                    if (tt.nextToken() != -2) {
                        throw new IOException("y coordinate missing for 'A' at position " + tt.getStartPosition() + " in " + str);
                    }
                    p.y += tt.nval;
                    ((BezierPath)path).arcTo(rx, ry, xAxisRotation, largeArcFlag, sweepFlag, p.x, p.y);
                    nextCommand = 97;
                    continue block21;
                }
            }
            System.out.println("SVGInputFormat.toPath aborting after illegal path command: " + (char)command + " found in path " + str);
            break;
        }
        if (path != null) {
            paths.add(path);
        }
        return paths.toArray(new BezierPath[paths.size()]);
    }
}

