/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.odg.figures;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.jhotdraw.draw.BezierFigure;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.handle.BezierNodeHandle;
import org.jhotdraw.draw.handle.Handle;
import org.jhotdraw.draw.handle.TransformHandleKit;
import org.jhotdraw.geom.BezierPath;
import org.jhotdraw.samples.odg.ODGAttributeKeys;
import org.jhotdraw.samples.odg.figures.ODGPathFigure;

public class ODGBezierFigure
extends BezierFigure {
    @Nullable
    private transient Rectangle2D.Double cachedDrawingArea;

    public ODGBezierFigure() {
        this(false);
    }

    public ODGBezierFigure(boolean isClosed) {
        super(isClosed);
        this.set(ODGAttributeKeys.UNCLOSED_PATH_FILLED, true);
    }

    public Collection<Handle> createHandles(ODGPathFigure pathFigure, int detailLevel) {
        LinkedList<Handle> handles = new LinkedList<Handle>();
        switch (detailLevel % 2) {
            case 0: {
                int n = this.path.size();
                for (int i = 0; i < n; ++i) {
                    handles.add(new BezierNodeHandle(this, i, pathFigure));
                }
                break;
            }
            case 1: {
                TransformHandleKit.addTransformHandles(this, handles);
                break;
            }
        }
        return handles;
    }

    @Override
    public boolean handleMouseClick(Point2D.Double p, MouseEvent evt, DrawingView view) {
        if (evt.getClickCount() == 2) {
            this.willChange();
            final int index = this.splitSegment(p, (float)(5.0 / view.getScaleFactor()));
            if (index != -1) {
                final BezierPath.Node newNode = this.getNode(index);
                this.fireUndoableEditHappened(new AbstractUndoableEdit(){

                    @Override
                    public void redo() throws CannotRedoException {
                        super.redo();
                        ODGBezierFigure.this.willChange();
                        ODGBezierFigure.this.addNode(index, newNode);
                        ODGBezierFigure.this.changed();
                    }

                    @Override
                    public void undo() throws CannotUndoException {
                        super.undo();
                        ODGBezierFigure.this.willChange();
                        ODGBezierFigure.this.removeNode(index);
                        ODGBezierFigure.this.changed();
                    }
                });
                this.changed();
                evt.consume();
                return true;
            }
        }
        return false;
    }

    @Override
    public void transform(AffineTransform tx) {
        if (this.get(ODGAttributeKeys.TRANSFORM) != null || (tx.getType() & 1) != tx.getType()) {
            if (this.get(ODGAttributeKeys.TRANSFORM) == null) {
                ODGAttributeKeys.TRANSFORM.setClone(this, tx);
            } else {
                AffineTransform t = (AffineTransform)ODGAttributeKeys.TRANSFORM.getClone(this);
                t.preConcatenate(tx);
                this.set(ODGAttributeKeys.TRANSFORM, t);
            }
        } else {
            super.transform(tx);
        }
    }

    @Override
    public Rectangle2D.Double getDrawingArea() {
        if (this.cachedDrawingArea == null) {
            if (this.get(ODGAttributeKeys.TRANSFORM) == null) {
                this.cachedDrawingArea = this.path.getBounds2D();
            } else {
                BezierPath p2 = this.path.clone();
                p2.transform((AffineTransform)this.get(ODGAttributeKeys.TRANSFORM));
                this.cachedDrawingArea = p2.getBounds2D();
            }
        }
        return (Rectangle2D.Double)this.cachedDrawingArea.clone();
    }

    public void flattenTransform() {
        if (this.get(ODGAttributeKeys.TRANSFORM) != null) {
            this.path.transform((AffineTransform)this.get(ODGAttributeKeys.TRANSFORM));
            this.set(ODGAttributeKeys.TRANSFORM, null);
        }
        this.invalidate();
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.cachedDrawingArea = null;
    }
}

