/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.odg.figures;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.jhotdraw.draw.AbstractAttributedFigure;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.samples.odg.ODGAttributeKeys;
import org.jhotdraw.samples.odg.ODGConstants;
import org.jhotdraw.samples.odg.figures.ODGFigure;
import org.jhotdraw.util.ResourceBundleUtil;

public abstract class ODGAttributedFigure
extends AbstractAttributedFigure
implements ODGFigure {
    @Override
    public void draw(Graphics2D g) {
        double opacity = this.get(ODGAttributeKeys.OPACITY);
        if ((opacity = Math.min(Math.max(0.0, opacity), 1.0)) != 0.0) {
            if (opacity != 1.0) {
                Rectangle2D.Double drawingArea = this.getDrawingArea();
                Rectangle clipBounds = g.getClipBounds();
                if (clipBounds != null) {
                    Rectangle2D.intersect(drawingArea, clipBounds, drawingArea);
                }
                if (!drawingArea.isEmpty()) {
                    BufferedImage buf = new BufferedImage((int)((2.0 + drawingArea.width) * g.getTransform().getScaleX()), (int)((2.0 + drawingArea.height) * g.getTransform().getScaleY()), 2);
                    Graphics2D gr = buf.createGraphics();
                    gr.scale(g.getTransform().getScaleX(), g.getTransform().getScaleY());
                    gr.translate((int)(-drawingArea.x), (int)(-drawingArea.y));
                    gr.setRenderingHints(g.getRenderingHints());
                    this.drawFigure(gr);
                    gr.dispose();
                    Composite savedComposite = g.getComposite();
                    g.setComposite(AlphaComposite.getInstance(3, (float)opacity));
                    g.drawImage(buf, (int)drawingArea.x, (int)drawingArea.y, 2 + (int)drawingArea.width, 2 + (int)drawingArea.height, null);
                    g.setComposite(savedComposite);
                }
            } else {
                this.drawFigure(g);
            }
        }
    }

    public void drawFigure(Graphics2D g) {
        Paint paint;
        AffineTransform savedTransform = null;
        if (this.get(ODGAttributeKeys.TRANSFORM) != null) {
            savedTransform = g.getTransform();
            g.transform((AffineTransform)this.get(ODGAttributeKeys.TRANSFORM));
        }
        if (this.get(ODGAttributeKeys.FILL_STYLE) != ODGConstants.FillStyle.NONE && (paint = ODGAttributeKeys.getFillPaint(this)) != null) {
            g.setPaint(paint);
            this.drawFill(g);
        }
        if (this.get(ODGAttributeKeys.STROKE_STYLE) != ODGConstants.StrokeStyle.NONE && (paint = ODGAttributeKeys.getStrokePaint(this)) != null) {
            g.setPaint(paint);
            g.setStroke(ODGAttributeKeys.getStroke(this));
            this.drawStroke(g);
        }
        if (this.get(ODGAttributeKeys.TRANSFORM) != null) {
            g.setTransform(savedTransform);
        }
    }

    @Override
    public <T> void set(AttributeKey<T> key, T newValue) {
        if (key == ODGAttributeKeys.TRANSFORM) {
            this.invalidate();
        }
        super.set(key, newValue);
    }

    @Override
    public Collection<Action> getActions(Point2D.Double p) {
        LinkedList<Action> actions = new LinkedList<Action>();
        if (this.get(ODGAttributeKeys.TRANSFORM) != null) {
            ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.samples.odg.Labels");
            actions.add(new AbstractAction(labels.getString("edit.removeTransform.text")){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ODGAttributedFigure.this.willChange();
                    ODGAttributedFigure.this.fireUndoableEditHappened(ODGAttributeKeys.TRANSFORM.setUndoable(ODGAttributedFigure.this, null));
                    ODGAttributedFigure.this.changed();
                }
            });
        }
        return actions;
    }
}

