/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.net.figures;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.ConnectionFigure;
import org.jhotdraw.draw.LineConnectionFigure;
import org.jhotdraw.draw.RectangleFigure;
import org.jhotdraw.draw.TextFigure;
import org.jhotdraw.draw.connector.Connector;
import org.jhotdraw.draw.connector.LocatorConnector;
import org.jhotdraw.draw.handle.BoundsOutlineHandle;
import org.jhotdraw.draw.handle.ConnectorHandle;
import org.jhotdraw.draw.handle.Handle;
import org.jhotdraw.draw.handle.MoveHandle;
import org.jhotdraw.draw.locator.RelativeLocator;
import org.jhotdraw.geom.Geom;
import org.jhotdraw.geom.Insets2D;
import org.jhotdraw.util.ResourceBundleUtil;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;

public class NodeFigure
extends TextFigure {
    private LinkedList<Connector> connectors;
    private static LocatorConnector north;
    private static LocatorConnector south;
    private static LocatorConnector east;
    private static LocatorConnector west;

    public NodeFigure() {
        RectangleFigure rf = new RectangleFigure();
        this.setDecorator(rf);
        this.createConnectors();
        this.set(AttributeKeys.DECORATOR_INSETS, new Insets2D.Double(6.0, 10.0, 6.0, 10.0));
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.samples.net.Labels");
        this.setText(labels.getString("nodeDefaultName"));
        this.setAttributeEnabled(AttributeKeys.DECORATOR_INSETS, false);
    }

    private void createConnectors() {
        this.connectors = new LinkedList();
        this.connectors.add(new LocatorConnector(this, RelativeLocator.north()));
        this.connectors.add(new LocatorConnector(this, RelativeLocator.east()));
        this.connectors.add(new LocatorConnector(this, RelativeLocator.west()));
        this.connectors.add(new LocatorConnector(this, RelativeLocator.south()));
    }

    @Override
    public Collection<Connector> getConnectors(ConnectionFigure prototype) {
        return Collections.unmodifiableList(this.connectors);
    }

    @Override
    public Collection<Handle> createHandles(int detailLevel) {
        LinkedList<Handle> handles = new LinkedList<Handle>();
        switch (detailLevel) {
            case -1: {
                handles.add(new BoundsOutlineHandle(this.getDecorator(), false, true));
                break;
            }
            case 0: {
                handles.add(new MoveHandle(this, RelativeLocator.northWest()));
                handles.add(new MoveHandle(this, RelativeLocator.northEast()));
                handles.add(new MoveHandle(this, RelativeLocator.southWest()));
                handles.add(new MoveHandle(this, RelativeLocator.southEast()));
                for (Connector c : this.connectors) {
                    handles.add(new ConnectorHandle(c, new LineConnectionFigure()));
                }
                break;
            }
        }
        return handles;
    }

    @Override
    public Rectangle2D.Double getFigureDrawingArea() {
        Rectangle2D.Double b = super.getFigureDrawingArea();
        Geom.grow(b, 10.0, 10.0);
        return b;
    }

    @Override
    public Connector findConnector(Point2D.Double p, ConnectionFigure figure) {
        double min = Double.MAX_VALUE;
        Connector closest = null;
        for (Connector c : this.connectors) {
            Point2D.Double p2 = Geom.center(c.getBounds());
            double d = Geom.length2(p.x, p.y, p2.x, p2.y);
            if (!(d < min)) continue;
            min = d;
            closest = c;
        }
        return closest;
    }

    @Override
    public Connector findCompatibleConnector(Connector c, boolean isStart) {
        if (c instanceof LocatorConnector) {
            LocatorConnector lc = (LocatorConnector)c;
            for (Connector cc : this.connectors) {
                LocatorConnector lcc = (LocatorConnector)cc;
                if (!lcc.getLocator().equals(lc.getLocator())) continue;
                return lcc;
            }
        }
        return this.connectors.getFirst();
    }

    @Override
    public NodeFigure clone() {
        NodeFigure that = (NodeFigure)super.clone();
        that.createConnectors();
        return that;
    }

    @Override
    public int getLayer() {
        return -1;
    }

    @Override
    protected void writeDecorator(DOMOutput out) throws IOException {
    }

    @Override
    protected void readDecorator(DOMInput in) throws IOException {
    }

    @Override
    public <T> void set(AttributeKey<T> key, T newValue) {
        super.set(key, newValue);
        if (this.getDecorator() != null) {
            this.getDecorator().set(key, newValue);
        }
    }
}

