/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.color;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.color.ColorSpace;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.jhotdraw.color.ColorListCellRenderer;
import org.jhotdraw.color.ColorUtil;
import org.jhotdraw.color.DefaultColorSliderModel;
import org.jhotdraw.color.HSLColorSpace;
import org.jhotdraw.color.HSLPhysiologicColorSpace;
import org.jhotdraw.color.HarmonicColorModel;
import org.jhotdraw.color.JHarmonicColorWheel;
import org.jhotdraw.color.SimpleHarmonicRule;
import org.jhotdraw.gui.JLifeFormattedTextField;

public class JMixer
extends JPanel {
    private JList swatchesList;
    private DefaultColorSliderModel sliderModel;
    private int adjusting;
    private JCheckBox achromaticCheck;
    private JLifeFormattedTextField achromaticField;
    private JLabel achromaticLabel1;
    private JLabel achromaticLabel2;
    private JLifeFormattedTextField analogousField;
    private JLabel analogousLabel1;
    private JLabel analogousLabel2;
    private JRadioButton analogousRadio;
    private JLifeFormattedTextField clashField;
    private JLabel clashLabel1;
    private JLabel clashLabel2;
    private JRadioButton clashRadio;
    private JLifeFormattedTextField complementaryField;
    private JLabel complementaryLabel1;
    private JLabel complementaryLabel2;
    private JRadioButton complementaryRadio;
    private JLifeFormattedTextField customHueField;
    private JLabel customHueLabel;
    private JLabel customHueLabel2;
    private JRadioButton customHueRadio;
    private JToggleButton disclosureButton;
    private JHarmonicColorWheel harmonicWheel;
    private ButtonGroup hueGroup;
    private JPanel mixerPanel;
    private JCheckBox monochromaticCheck;
    private JLifeFormattedTextField monochromaticField;
    private JLabel monochromaticLabel1;
    private JLabel monochromaticLabel2;
    private JComboBox presetCombo;
    private JLifeFormattedTextField primaryField;
    private JLabel primaryLabel1;
    private JLabel primaryLabel2;
    private JRadioButton primaryRadio;
    private JSlider saturationSlider;
    private JScrollPane scrollPane;
    private JLabel splitComplementaryLabel1;
    private JLabel splitComplementaryLabel2;
    private JRadioButton splitComplementaryRadio;
    private JLifeFormattedTextField splitField;
    private JPanel springPanel;
    private ButtonGroup sysGroup;
    private JToggleButton sysRGBToggle;
    private JToggleButton sysRYBToggle;
    private JLifeFormattedTextField triadField;
    private JLabel triadLabel1;
    private JLabel triadLabel2;
    private JRadioButton triadRadio;

    public JMixer() {
        this.initComponents();
        DefaultComboBoxModel<Preset> presets = new DefaultComboBoxModel<Preset>();
        presets.addElement(new Preset("Powerful", 4));
        presets.addElement(new Preset("Rich", 1));
        presets.addElement(new Preset("Romantic", 7));
        presets.addElement(new Preset("Vital", 12));
        presets.addElement(new Preset("Earthy", 10));
        presets.addElement(new Preset("Friendly", 20));
        presets.addElement(new Preset("Soft", 22));
        presets.addElement(new Preset("Welcoming", 28));
        presets.addElement(new Preset("Moving", 36));
        presets.addElement(new Preset("Elegant", 39));
        presets.addElement(new Preset("Fresh", 52));
        presets.addElement(new Preset("Traditional", 49));
        presets.addElement(new Preset("Refreshing", 60));
        presets.addElement(new Preset("Tropical", 62));
        presets.addElement(new Preset("Classic", 68));
        presets.addElement(new Preset("Dependable", 65));
        presets.addElement(new Preset("Calm", 70));
        presets.addElement(new Preset("Regal", 76));
        presets.addElement(new Preset("Magical", 84));
        presets.addElement(new Preset("Energetic", 92));
        presets.addElement(new Preset("Subdued", 94));
        this.presetCombo.setModel(presets);
        Font smallFont = new Font("Lucida Grande", 0, 11);
        for (Component c : this.mixerPanel.getComponents()) {
            c.setFont(smallFont);
        }
        this.swatchesList = new JList(){

            @Override
            public String getToolTipText(MouseEvent evt) {
                int index = this.locationToIndex(evt.getPoint());
                Object item = this.getModel().getElementAt(index);
                JComponent c = (JComponent)this.getCellRenderer().getListCellRendererComponent(this, item, index, false, false);
                return c.getToolTipText();
            }
        };
        this.swatchesList.setLayoutOrientation(1);
        this.swatchesList.setVisibleRowCount(5);
        this.scrollPane.setViewportView(this.swatchesList);
        this.harmonicWheel.setColorSpace(HSLColorSpace.getInstance());
        this.scrollPane.setPreferredSize(new Dimension(100, 100));
        this.swatchesList.setModel(this.harmonicWheel.getHarmonicColorModel());
        this.swatchesList.setCellRenderer(new ColorListCellRenderer());
        this.sliderModel = new DefaultColorSliderModel(this.harmonicWheel.getHarmonicColorModel().getColorSpace());
        this.sliderModel.configureSlider(1, this.saturationSlider);
        this.harmonicWheel.getHarmonicColorModel().addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                JMixer.this.adjusting++;
                HarmonicColorModel hcm = JMixer.this.harmonicWheel.getHarmonicColorModel();
                Color cc = hcm.get(e.getIndex0());
                if (cc != null) {
                    JMixer.this.sliderModel.setColor(cc);
                }
                JMixer.this.adjusting--;
            }
        });
        this.harmonicWheel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String name = evt.getPropertyName();
                if (name == "selectedIndex") {
                    JMixer.this.adjusting++;
                    int index = JMixer.this.harmonicWheel.getSelectedIndex();
                    HarmonicColorModel hcm = JMixer.this.harmonicWheel.getHarmonicColorModel();
                    if (index != -1) {
                        JMixer.this.sliderModel.setColor(hcm.get(index));
                    }
                    JMixer.this.adjusting--;
                }
            }
        });
        this.sliderModel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int index;
                HarmonicColorModel hcm;
                if (JMixer.this.adjusting++ == 0 && !(hcm = JMixer.this.harmonicWheel.getHarmonicColorModel()).isAdjusting() && (index = JMixer.this.harmonicWheel.getSelectedIndex()) != -1) {
                    Color cc = JMixer.this.sliderModel.getColor();
                    Color oldValue = hcm.get(index);
                    Color newValue = new Color(oldValue.getColorSpace(), ColorUtil.fromColor(oldValue.getColorSpace(), cc), 1.0f);
                    hcm.set(index, newValue);
                }
                JMixer.this.adjusting--;
            }
        });
        this.harmonicWheel.setSelectedIndex(0);
        this.harmonicWheel.getHarmonicColorModel().setSize(25);
        HarmonicColorModel h = this.harmonicWheel.getHarmonicColorModel();
        ColorSpace sys = h.getColorSpace();
        h.set(0, new Color(sys, ColorUtil.fromRGB(sys, 0, 19, 148), 1.0f));
        h.set(1, new Color(sys, ColorUtil.fromRGB(sys, 218, 37, 26), 1.0f));
        h.set(2, new Color(sys, ColorUtil.fromRGB(sys, 70, 148, 27), 1.0f));
        h.set(3, new Color(sys, ColorUtil.fromRGB(sys, 174, 46, 248), 1.0f));
        h.set(4, new Color(sys, ColorUtil.fromRGB(sys, 255, 252, 76), 1.0f));
        h.set(5, new Color(sys, ColorUtil.fromRGB(sys, 234, 155, 65), 1.0f));
        h.set(6, new Color(sys, ColorUtil.fromRGB(sys, 51, 51, 51), 1.0f));
        h.set(7, new Color(sys, ColorUtil.fromRGB(sys, 153, 153, 153), 1.0f));
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame f = new JFrame("Mixer");
                f.add(new JMixer());
                f.setDefaultCloseOperation(3);
                f.pack();
                f.setVisible(true);
            }
        });
    }

    private void updateRules() {
        HarmonicColorModel m = this.harmonicWheel.getHarmonicColorModel();
        m.removeAllRules();
        int n = m.getSize();
        for (int i = 1; i < n; ++i) {
            m.set(i, null);
        }
        if (!this.customHueRadio.isSelected()) {
            if (this.analogousRadio.isSelected()) {
                m.addRule(new SimpleHarmonicRule(0, 0.083333336f, 0, 5));
                m.addRule(new SimpleHarmonicRule(0, -0.083333336f, 0, 10));
            } else if (this.primaryRadio.isSelected()) {
                m.addRule(new SimpleHarmonicRule(0, 0.33333334f, 0, 5));
                m.addRule(new SimpleHarmonicRule(0, -0.33333334f, 0, 10));
            } else if (this.clashRadio.isSelected()) {
                m.addRule(new SimpleHarmonicRule(0, 0.25f, 0, 5));
                m.addRule(new SimpleHarmonicRule(0, -0.25f, 0, 10));
            } else if (this.triadRadio.isSelected()) {
                m.addRule(new SimpleHarmonicRule(0, 0.33333334f, 0, 5));
                m.addRule(new SimpleHarmonicRule(0, -0.33333334f, 0, 10));
            } else if (this.splitComplementaryRadio.isSelected()) {
                m.addRule(new SimpleHarmonicRule(0, 0.41666666f, 0, 5));
                m.addRule(new SimpleHarmonicRule(0, -0.41666666f, 0, 10));
            } else if (this.complementaryRadio.isSelected()) {
                m.addRule(new SimpleHarmonicRule(0, 0.5f, 0, 5));
            }
        }
        if (this.monochromaticCheck.isSelected()) {
            m.addRule(new SimpleHarmonicRule(2, 0.083333336f, 0, 1, 2));
            m.addRule(new SimpleHarmonicRule(2, 0.083333336f, 5, 6, 7));
            m.addRule(new SimpleHarmonicRule(2, 0.083333336f, 10, 11, 12));
            m.addRule(new SimpleHarmonicRule(2, -0.083333336f, 0, 3, 4));
            m.addRule(new SimpleHarmonicRule(2, -0.083333336f, 5, 8, 9));
            m.addRule(new SimpleHarmonicRule(2, -0.083333336f, 10, 13, 14));
        }
        m.applyRules();
    }

    private void initComponents() {
        this.hueGroup = new ButtonGroup();
        this.sysGroup = new ButtonGroup();
        this.scrollPane = new JScrollPane();
        this.disclosureButton = new JToggleButton();
        this.sysRGBToggle = new JToggleButton();
        this.sysRYBToggle = new JToggleButton();
        this.presetCombo = new JComboBox();
        this.mixerPanel = new JPanel();
        this.harmonicWheel = new JHarmonicColorWheel();
        this.customHueRadio = new JRadioButton();
        this.customHueLabel = new JLabel();
        this.customHueField = new JLifeFormattedTextField();
        this.customHueLabel2 = new JLabel();
        this.analogousRadio = new JRadioButton();
        this.analogousLabel1 = new JLabel();
        this.analogousField = new JLifeFormattedTextField();
        this.analogousLabel2 = new JLabel();
        this.primaryRadio = new JRadioButton();
        this.primaryLabel1 = new JLabel();
        this.primaryField = new JLifeFormattedTextField();
        this.primaryLabel2 = new JLabel();
        this.clashRadio = new JRadioButton();
        this.clashLabel1 = new JLabel();
        this.clashField = new JLifeFormattedTextField();
        this.clashLabel2 = new JLabel();
        this.triadRadio = new JRadioButton();
        this.triadLabel1 = new JLabel();
        this.triadField = new JLifeFormattedTextField();
        this.triadLabel2 = new JLabel();
        this.splitComplementaryRadio = new JRadioButton();
        this.splitComplementaryLabel1 = new JLabel();
        this.splitField = new JLifeFormattedTextField();
        this.splitComplementaryLabel2 = new JLabel();
        this.complementaryRadio = new JRadioButton();
        this.complementaryLabel1 = new JLabel();
        this.complementaryField = new JLifeFormattedTextField();
        this.complementaryLabel2 = new JLabel();
        this.achromaticCheck = new JCheckBox();
        this.achromaticLabel1 = new JLabel();
        this.achromaticField = new JLifeFormattedTextField();
        this.achromaticLabel2 = new JLabel();
        this.monochromaticCheck = new JCheckBox();
        this.monochromaticLabel1 = new JLabel();
        this.monochromaticField = new JLifeFormattedTextField();
        this.monochromaticLabel2 = new JLabel();
        this.saturationSlider = new JSlider();
        this.springPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        this.add((Component)this.scrollPane, gridBagConstraints);
        this.disclosureButton.setSelected(true);
        this.disclosureButton.setText("Show Mixer");
        this.disclosureButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JMixer.this.mixerDisclosurePerformed(evt);
            }
        });
        this.add((Component)this.disclosureButton, new GridBagConstraints());
        this.sysGroup.add(this.sysRGBToggle);
        this.sysRGBToggle.setSelected(true);
        this.sysRGBToggle.setText("RGB");
        this.sysRGBToggle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JMixer.this.systemChangePerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        this.add((Component)this.sysRGBToggle, gridBagConstraints);
        this.sysGroup.add(this.sysRYBToggle);
        this.sysRYBToggle.setText("RYB");
        this.sysRYBToggle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JMixer.this.systemChangePerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        this.add((Component)this.sysRYBToggle, gridBagConstraints);
        this.presetCombo.setEditable(true);
        this.presetCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JMixer.this.presetPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 13;
        this.add((Component)this.presetCombo, gridBagConstraints);
        this.mixerPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.mixerPanel.add((Component)this.harmonicWheel, gridBagConstraints);
        this.hueGroup.add(this.customHueRadio);
        this.customHueRadio.setText("Custom");
        this.customHueRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JMixer.this.ruleChangePerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.anchor = 21;
        this.mixerPanel.add((Component)this.customHueRadio, gridBagConstraints);
        this.customHueLabel.setText("\u00b1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.anchor = 21;
        this.mixerPanel.add((Component)this.customHueLabel, gridBagConstraints);
        this.customHueField.setColumns(3);
        this.customHueField.setHorizontalAlignment(4);
        this.customHueField.setText("30");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.anchor = 21;
        this.mixerPanel.add((Component)this.customHueField, gridBagConstraints);
        this.customHueLabel2.setHorizontalAlignment(4);
        this.customHueLabel2.setText("\u00b0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        this.mixerPanel.add((Component)this.customHueLabel2, gridBagConstraints);
        this.hueGroup.add(this.analogousRadio);
        this.analogousRadio.setSelected(true);
        this.analogousRadio.setText("Analogous");
        this.analogousRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JMixer.this.ruleChangePerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.anchor = 21;
        this.mixerPanel.add((Component)this.analogousRadio, gridBagConstraints);
        this.analogousLabel1.setText("\u00b1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.anchor = 21;
        this.mixerPanel.add((Component)this.analogousLabel1, gridBagConstraints);
        this.analogousField.setColumns(3);
        this.analogousField.setEditable(false);
        this.analogousField.setHorizontalAlignment(4);
        this.analogousField.setText("30");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.anchor = 21;
        this.mixerPanel.add((Component)this.analogousField, gridBagConstraints);
        this.analogousLabel2.setHorizontalAlignment(4);
        this.analogousLabel2.setText("\u00b0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        this.mixerPanel.add((Component)this.analogousLabel2, gridBagConstraints);
        this.hueGroup.add(this.primaryRadio);
        this.primaryRadio.setText("Primary");
        this.primaryRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JMixer.this.ruleChangePerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.anchor = 21;
        this.mixerPanel.add((Component)this.primaryRadio, gridBagConstraints);
        this.primaryLabel1.setText("\u00b1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.anchor = 21;
        this.mixerPanel.add((Component)this.primaryLabel1, gridBagConstraints);
        this.primaryField.setColumns(3);
        this.primaryField.setEditable(false);
        this.primaryField.setHorizontalAlignment(4);
        this.primaryField.setText("120");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.anchor = 21;
        this.mixerPanel.add((Component)this.primaryField, gridBagConstraints);
        this.primaryLabel2.setHorizontalAlignment(4);
        this.primaryLabel2.setText("\u00b0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        this.mixerPanel.add((Component)this.primaryLabel2, gridBagConstraints);
        this.hueGroup.add(this.clashRadio);
        this.clashRadio.setText("Clash");
        this.clashRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JMixer.this.ruleChangePerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.anchor = 21;
        this.mixerPanel.add((Component)this.clashRadio, gridBagConstraints);
        this.clashLabel1.setText("\u00b1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.anchor = 21;
        this.mixerPanel.add((Component)this.clashLabel1, gridBagConstraints);
        this.clashField.setColumns(3);
        this.clashField.setEditable(false);
        this.clashField.setHorizontalAlignment(4);
        this.clashField.setText("90");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.anchor = 21;
        this.mixerPanel.add((Component)this.clashField, gridBagConstraints);
        this.clashLabel2.setHorizontalAlignment(4);
        this.clashLabel2.setText("\u00b0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        this.mixerPanel.add((Component)this.clashLabel2, gridBagConstraints);
        this.hueGroup.add(this.triadRadio);
        this.triadRadio.setText("Triad");
        this.triadRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JMixer.this.ruleChangePerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.anchor = 21;
        this.mixerPanel.add((Component)this.triadRadio, gridBagConstraints);
        this.triadLabel1.setText("\u00b1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.anchor = 21;
        this.mixerPanel.add((Component)this.triadLabel1, gridBagConstraints);
        this.triadField.setColumns(3);
        this.triadField.setEditable(false);
        this.triadField.setHorizontalAlignment(4);
        this.triadField.setText("120");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.anchor = 21;
        this.mixerPanel.add((Component)this.triadField, gridBagConstraints);
        this.triadLabel2.setHorizontalAlignment(4);
        this.triadLabel2.setText("\u00b0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        this.mixerPanel.add((Component)this.triadLabel2, gridBagConstraints);
        this.hueGroup.add(this.splitComplementaryRadio);
        this.splitComplementaryRadio.setText("Split Complementary");
        this.splitComplementaryRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JMixer.this.ruleChangePerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.anchor = 21;
        this.mixerPanel.add((Component)this.splitComplementaryRadio, gridBagConstraints);
        this.splitComplementaryLabel1.setText("\u00b1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.anchor = 21;
        this.mixerPanel.add((Component)this.splitComplementaryLabel1, gridBagConstraints);
        this.splitField.setColumns(3);
        this.splitField.setEditable(false);
        this.splitField.setHorizontalAlignment(4);
        this.splitField.setText("150");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.anchor = 21;
        this.mixerPanel.add((Component)this.splitField, gridBagConstraints);
        this.splitComplementaryLabel2.setHorizontalAlignment(4);
        this.splitComplementaryLabel2.setText("\u00b0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        this.mixerPanel.add((Component)this.splitComplementaryLabel2, gridBagConstraints);
        this.hueGroup.add(this.complementaryRadio);
        this.complementaryRadio.setText("Complementary");
        this.complementaryRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JMixer.this.ruleChangePerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.anchor = 21;
        this.mixerPanel.add((Component)this.complementaryRadio, gridBagConstraints);
        this.complementaryLabel1.setText("+");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.anchor = 21;
        this.mixerPanel.add((Component)this.complementaryLabel1, gridBagConstraints);
        this.complementaryField.setColumns(3);
        this.complementaryField.setEditable(false);
        this.complementaryField.setHorizontalAlignment(4);
        this.complementaryField.setText("180");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.anchor = 21;
        this.mixerPanel.add((Component)this.complementaryField, gridBagConstraints);
        this.complementaryLabel2.setHorizontalAlignment(4);
        this.complementaryLabel2.setText("\u00b0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        this.mixerPanel.add((Component)this.complementaryLabel2, gridBagConstraints);
        this.achromaticCheck.setText("Achromatic");
        this.achromaticCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JMixer.this.ruleChangePerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.anchor = 21;
        this.mixerPanel.add((Component)this.achromaticCheck, gridBagConstraints);
        this.achromaticLabel1.setText("\u00b1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.anchor = 21;
        this.mixerPanel.add((Component)this.achromaticLabel1, gridBagConstraints);
        this.achromaticField.setColumns(3);
        this.achromaticField.setHorizontalAlignment(4);
        this.achromaticField.setText("10");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.anchor = 21;
        this.mixerPanel.add((Component)this.achromaticField, gridBagConstraints);
        this.achromaticLabel2.setHorizontalAlignment(4);
        this.achromaticLabel2.setText("%");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        this.mixerPanel.add((Component)this.achromaticLabel2, gridBagConstraints);
        this.monochromaticCheck.setSelected(true);
        this.monochromaticCheck.setText("Monochromatic");
        this.monochromaticCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JMixer.this.ruleChangePerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.anchor = 21;
        this.mixerPanel.add((Component)this.monochromaticCheck, gridBagConstraints);
        this.monochromaticLabel1.setText("\u00b1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.anchor = 21;
        this.mixerPanel.add((Component)this.monochromaticLabel1, gridBagConstraints);
        this.monochromaticField.setColumns(3);
        this.monochromaticField.setHorizontalAlignment(4);
        this.monochromaticField.setText("10");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.anchor = 21;
        this.mixerPanel.add((Component)this.monochromaticField, gridBagConstraints);
        this.monochromaticLabel2.setHorizontalAlignment(4);
        this.monochromaticLabel2.setText("%");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        this.mixerPanel.add((Component)this.monochromaticLabel2, gridBagConstraints);
        this.saturationSlider.setOrientation(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 3;
        this.mixerPanel.add((Component)this.saturationSlider, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weighty = 1.0;
        this.mixerPanel.add((Component)this.springPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        this.add((Component)this.mixerPanel, gridBagConstraints);
    }

    private void ruleChangePerformed(ActionEvent evt) {
        this.updateRules();
    }

    private void mixerDisclosurePerformed(ActionEvent evt) {
        this.mixerPanel.setVisible(this.disclosureButton.isSelected());
        this.mixerPanel.getParent().validate();
    }

    private void systemChangePerformed(ActionEvent evt) {
        HarmonicColorModel m = this.harmonicWheel.getHarmonicColorModel();
        ColorSpace sys = this.sysRGBToggle.isSelected() ? HSLColorSpace.getInstance() : HSLPhysiologicColorSpace.getInstance();
        m.setColorSpace(sys);
        this.sliderModel.setColorSpace(sys);
        this.sliderModel.configureSlider(1, this.saturationSlider);
        if (this.harmonicWheel.getSelectedIndex() != -1) {
            this.sliderModel.setColor(m.get(this.harmonicWheel.getSelectedIndex()));
        }
    }

    private void presetPerformed(ActionEvent evt) {
        Object obj = this.presetCombo.getSelectedItem();
        if (obj instanceof Preset) {
            Preset preset = (Preset)obj;
            HarmonicColorModel m = this.harmonicWheel.getHarmonicColorModel();
            m.set(m.getBase(), preset.getColor());
        }
    }

    private class Preset {
        private String name;
        private int index;

        public Preset(String name, int index) {
            this.name = name;
            this.index = index;
        }

        public Color getColor() {
            return new Color(JMixer.this.sliderModel.getColorSpace(), new float[]{(float)(this.index / 8) / 12.0f, 1.0f, (float)(this.index % 8 + 2) / 12.0f}, 1.0f);
        }

        public String toString() {
            return this.name;
        }
    }
}

