/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.event;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import org.jhotdraw.app.Disposable;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.event.FigureAdapter;
import org.jhotdraw.draw.event.FigureEvent;
import org.jhotdraw.draw.event.FigureSelectionEvent;
import org.jhotdraw.draw.event.FigureSelectionListener;

public class SelectionComponentRepainter
extends FigureAdapter
implements PropertyChangeListener,
FigureSelectionListener,
Disposable {
    @Nullable
    private DrawingEditor editor;
    @Nullable
    private JComponent component;

    public SelectionComponentRepainter(DrawingEditor editor, JComponent component) {
        this.editor = editor;
        this.component = component;
        if (editor != null) {
            if (editor.getActiveView() != null) {
                DrawingView view = editor.getActiveView();
                view.addPropertyChangeListener(this);
                view.addFigureSelectionListener(this);
                if (view.getDrawing() != null) {
                    view.getDrawing().addFigureListener(this);
                }
            }
            editor.addPropertyChangeListener(this);
        }
    }

    @Override
    public void attributeChanged(FigureEvent evt) {
        this.component.repaint();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if (name == "activeView") {
            DrawingView view = (DrawingView)evt.getOldValue();
            if (view != null) {
                view.removePropertyChangeListener(this);
                view.removeFigureSelectionListener(this);
                if (view.getDrawing() != null) {
                    view.getDrawing().removeFigureListener(this);
                }
            }
            if ((view = (DrawingView)evt.getNewValue()) != null) {
                view.addPropertyChangeListener(this);
                view.addFigureSelectionListener(this);
                if (view.getDrawing() != null) {
                    view.getDrawing().addFigureListener(this);
                }
            }
            this.component.repaint();
        } else if (name == "drawing") {
            Drawing drawing = (Drawing)evt.getOldValue();
            if (drawing != null) {
                drawing.removeFigureListener(this);
            }
            if ((drawing = (Drawing)evt.getNewValue()) != null) {
                drawing.addFigureListener(this);
            }
            this.component.repaint();
        } else {
            this.component.repaint();
        }
    }

    @Override
    public void selectionChanged(FigureSelectionEvent evt) {
        this.component.repaint();
    }

    @Override
    public void dispose() {
        if (this.editor != null) {
            if (this.editor.getActiveView() != null) {
                DrawingView view = this.editor.getActiveView();
                view.removePropertyChangeListener(this);
                view.removeFigureSelectionListener(this);
                if (view.getDrawing() != null) {
                    view.getDrawing().removeFigureListener(this);
                }
            }
            this.editor.removePropertyChangeListener(this);
            this.editor = null;
        }
        this.component = null;
    }
}

