/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.event;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.UndoableEdit;
import org.jhotdraw.app.Disposable;
import org.jhotdraw.beans.WeakPropertyChangeListener;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.event.FigureAdapter;
import org.jhotdraw.draw.event.FigureEvent;
import org.jhotdraw.draw.event.FigureSelectionEvent;
import org.jhotdraw.draw.event.FigureSelectionListener;
import org.jhotdraw.gui.AttributeEditor;

public abstract class AbstractAttributeEditorHandler<T>
implements Disposable {
    @Nullable
    protected DrawingEditor editor;
    @Nullable
    protected DrawingView view;
    @Nullable
    protected DrawingView activeView;
    protected AttributeEditor<T> attributeEditor;
    protected AttributeKey<T> attributeKey;
    protected int updateDepth;
    @Nullable
    protected LinkedList<Object> attributeRestoreData = new LinkedList();
    protected Map<AttributeKey, Object> defaultAttributes;
    private boolean isUpdateDrawingEditorDefaults;
    private Set<Figure> figuresOfInterest;
    private EventHandler eventHandler = new EventHandler();

    public AbstractAttributeEditorHandler(AttributeKey<T> key, AttributeEditor<T> attributeEditor, @Nullable DrawingEditor drawingEditor) {
        this(key, attributeEditor, drawingEditor, true);
    }

    public AbstractAttributeEditorHandler(AttributeKey<T> key, AttributeEditor<T> attributeEditor, @Nullable DrawingEditor drawingEditor, boolean updateDrawingEditorDefaults) {
        this(key, null, attributeEditor, drawingEditor, updateDrawingEditorDefaults);
    }

    public AbstractAttributeEditorHandler(AttributeKey<T> key, @Nullable Map<AttributeKey, Object> defaultAttributes, AttributeEditor<T> attributeEditor, @Nullable DrawingEditor drawingEditor, boolean updateDrawingEditorDefaults) {
        this.defaultAttributes = defaultAttributes == null ? Collections.emptyMap() : defaultAttributes;
        attributeEditor.setAttributeValue(key.getDefaultValue());
        this.setAttributeKey(key);
        this.setAttributeEditor(attributeEditor);
        this.setEditor(drawingEditor);
        this.isUpdateDrawingEditorDefaults = updateDrawingEditorDefaults;
    }

    public void setEditor(@Nullable DrawingEditor newValue) {
        DrawingEditor oldValue = this.editor;
        if (this.editor != null) {
            this.editor.removePropertyChangeListener(this.eventHandler);
        }
        this.editor = newValue;
        if (this.editor != null) {
            this.editor.addPropertyChangeListener(new WeakPropertyChangeListener(this.eventHandler));
        }
        this.updateActiveView();
    }

    @Nullable
    public DrawingEditor getEditor() {
        return this.editor;
    }

    public void setView(@Nullable DrawingView newValue) {
        this.view = newValue;
        this.updateActiveView();
    }

    @Nullable
    public DrawingView getView() {
        return this.view;
    }

    public void setUpdateDrawingEditorDefaults(boolean newValue) {
        this.isUpdateDrawingEditorDefaults = newValue;
    }

    public boolean isUpdateDrawingEditorDefaults() {
        return this.isUpdateDrawingEditorDefaults;
    }

    @Nullable
    protected DrawingView getActiveView() {
        if (this.getView() != null) {
            return this.getView();
        }
        return this.editor.getActiveView();
    }

    public void setAttributeEditor(AttributeEditor<T> newValue) {
        if (this.attributeEditor != null) {
            this.attributeEditor.removePropertyChangeListener(this.eventHandler);
        }
        this.attributeEditor = newValue;
        if (this.attributeEditor != null) {
            this.attributeEditor.addPropertyChangeListener(this.eventHandler);
        }
    }

    public AttributeEditor<T> getAttributeEditor() {
        return this.attributeEditor;
    }

    public AttributeKey<T> getAttributeKey() {
        return this.attributeKey;
    }

    public void setAttributeKey(AttributeKey<T> newValue) {
        this.attributeKey = newValue;
    }

    protected void updateActiveView() {
        DrawingView newValue = this.view != null ? this.view : (this.editor != null && this.editor.getActiveView() != null ? this.editor.getActiveView() : null);
        DrawingView oldValue = this.activeView;
        if (this.activeView != null) {
            this.activeView.removePropertyChangeListener(this.eventHandler);
            this.activeView.removeFigureSelectionListener(this.eventHandler);
            if (this.figuresOfInterest != null) {
                for (Figure f : this.figuresOfInterest) {
                    f.removeFigureListener(this.eventHandler);
                }
            }
        }
        this.activeView = newValue;
        if (this.activeView != null) {
            this.activeView.addPropertyChangeListener(this.eventHandler);
            this.activeView.addFigureSelectionListener(this.eventHandler);
            this.figuresOfInterest = this.getEditedFigures();
            for (Figure f : this.figuresOfInterest) {
                f.addFigureListener(this.eventHandler);
            }
        }
        this.attributeRestoreData = null;
        this.updateAttributeEditor();
    }

    protected abstract Set<Figure> getEditedFigures();

    protected void updateAttributeEditor() {
        if (this.updateDepth++ == 0) {
            Set<Figure> figures = this.getEditedFigures();
            if (this.editor == null) {
                this.attributeEditor.getComponent().setEnabled(false);
            } else if (this.activeView == null || figures.isEmpty()) {
                this.attributeEditor.getComponent().setEnabled(true);
                T value = this.editor.getDefaultAttribute(this.attributeKey);
                this.attributeEditor.setAttributeValue(value);
                this.attributeEditor.setMultipleValues(false);
            } else {
                this.attributeEditor.getComponent().setEnabled(true);
                T value = figures.iterator().next().get(this.attributeKey);
                boolean isMultiple = false;
                for (Figure f : figures) {
                    T v = f.get(this.attributeKey);
                    if ((v != null && value != null || v == value) && (v == null || value == null || v.equals(value))) continue;
                    isMultiple = true;
                    break;
                }
                this.attributeEditor.setAttributeValue(value);
                this.attributeEditor.setMultipleValues(isMultiple);
            }
        }
        --this.updateDepth;
    }

    protected void updateFigures() {
        if (this.updateDepth++ == 0) {
            Set<Figure> figures = this.getEditedFigures();
            if (this.activeView != null && !figures.isEmpty()) {
                T value = this.attributeEditor.getAttributeValue();
                if (this.attributeRestoreData == null) {
                    this.attributeRestoreData = new LinkedList();
                    for (Figure f : figures) {
                        this.attributeRestoreData.add(f.getAttributesRestoreData());
                    }
                }
                for (Figure f : figures) {
                    f.willChange();
                    f.set(this.attributeKey, value);
                    for (Map.Entry<AttributeKey, Object> entry : this.defaultAttributes.entrySet()) {
                        f.set(entry.getKey(), entry.getValue());
                    }
                    f.changed();
                }
                if (this.editor != null && this.isUpdateDrawingEditorDefaults) {
                    this.editor.setDefaultAttribute(this.attributeKey, value);
                }
                this.getActiveView().getDrawing().fireUndoableEditHappened(new UndoableAttributeEdit<T>(new HashSet<Figure>(figures), this.attributeKey, value, this.attributeRestoreData));
                if (!this.attributeEditor.getValueIsAdjusting()) {
                    this.attributeRestoreData = null;
                }
            }
        }
        --this.updateDepth;
    }

    @Override
    public void dispose() {
        this.setEditor(null);
    }

    private static class UndoableAttributeEdit<T>
    extends AbstractUndoableEdit {
        private Set<Figure> editedFigures;
        private AttributeKey<T> attributeKey;
        private T editRedoValue;
        protected LinkedList<Object> editUndoData;

        public UndoableAttributeEdit(Set<Figure> editedFigures, AttributeKey<T> attributeKey, T editRedoValue, LinkedList<Object> editUndoData) {
            this.editedFigures = editedFigures;
            this.attributeKey = attributeKey;
            this.editRedoValue = editRedoValue;
            this.editUndoData = editUndoData;
        }

        @Override
        public String getPresentationName() {
            return this.attributeKey.getPresentationName();
        }

        @Override
        public void undo() throws CannotRedoException {
            super.undo();
            Iterator di = this.editUndoData.iterator();
            for (Figure f : this.editedFigures) {
                f.willChange();
                f.restoreAttributesTo(di.next());
                f.changed();
            }
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            for (Figure f : this.editedFigures) {
                f.set(this.attributeKey, this.editRedoValue);
            }
        }

        @Override
        public boolean replaceEdit(UndoableEdit anEdit) {
            if (anEdit instanceof UndoableAttributeEdit) {
                return ((UndoableAttributeEdit)anEdit).editUndoData == this.editUndoData;
            }
            return false;
        }
    }

    protected class EventHandler
    extends FigureAdapter
    implements FigureSelectionListener,
    PropertyChangeListener {
        protected EventHandler() {
        }

        @Override
        public void selectionChanged(FigureSelectionEvent evt) {
            AbstractAttributeEditorHandler.this.attributeRestoreData = null;
            if (AbstractAttributeEditorHandler.this.figuresOfInterest != null) {
                for (Figure f : AbstractAttributeEditorHandler.this.figuresOfInterest) {
                    f.removeFigureListener(this);
                }
            }
            AbstractAttributeEditorHandler.this.figuresOfInterest = AbstractAttributeEditorHandler.this.getEditedFigures();
            for (Figure f : AbstractAttributeEditorHandler.this.figuresOfInterest) {
                f.addFigureListener(this);
            }
            AbstractAttributeEditorHandler.this.updateAttributeEditor();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Object src = evt.getSource();
            String name = evt.getPropertyName();
            if (src == AbstractAttributeEditorHandler.this.editor && name == "activeView") {
                AbstractAttributeEditorHandler.this.updateActiveView();
            } else if (src == AbstractAttributeEditorHandler.this.editor && name.equals("defaultAttribute." + AbstractAttributeEditorHandler.this.attributeKey.getKey())) {
                AbstractAttributeEditorHandler.this.updateAttributeEditor();
            } else if (src == AbstractAttributeEditorHandler.this.attributeEditor && name == "attributeValue") {
                AbstractAttributeEditorHandler.this.updateFigures();
            } else if (src == AbstractAttributeEditorHandler.this.activeView && name == "drawing") {
                AbstractAttributeEditorHandler.this.updateActiveView();
            } else if (AbstractAttributeEditorHandler.this.figuresOfInterest != null && AbstractAttributeEditorHandler.this.figuresOfInterest.contains(src)) {
                AbstractAttributeEditorHandler.this.updateFigures();
            }
        }

        @Override
        public void attributeChanged(FigureEvent e) {
            if (e.getAttribute() == AbstractAttributeEditorHandler.this.attributeKey) {
                AbstractAttributeEditorHandler.this.updateAttributeEditor();
            }
        }
    }
}

