/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.action.AttributeAction;
import org.jhotdraw.draw.event.FigureSelectionEvent;
import org.jhotdraw.util.ResourceBundleUtil;

public class EditorColorChooserAction
extends AttributeAction {
    protected AttributeKey<Color> key;
    protected static JColorChooser colorChooser;

    public EditorColorChooserAction(DrawingEditor editor, AttributeKey<Color> key) {
        this(editor, key, null, null);
        this.updateEnabledState();
    }

    public EditorColorChooserAction(DrawingEditor editor, AttributeKey<Color> key, @Nullable Icon icon) {
        this(editor, key, null, icon);
    }

    public EditorColorChooserAction(DrawingEditor editor, AttributeKey<Color> key, @Nullable String name) {
        this(editor, key, name, null);
    }

    public EditorColorChooserAction(DrawingEditor editor, AttributeKey<Color> key, @Nullable String name, @Nullable Icon icon) {
        this(editor, key, name, icon, new HashMap<AttributeKey, Object>());
    }

    public EditorColorChooserAction(DrawingEditor editor, AttributeKey<Color> key, @Nullable String name, @Nullable Icon icon, @Nullable Map<AttributeKey, Object> fixedAttributes) {
        super(editor, fixedAttributes, name, icon);
        this.key = key;
        this.putValue("Name", name);
        this.putValue("SmallIcon", icon);
        this.updateEnabledState();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (colorChooser == null) {
            colorChooser = new JColorChooser();
        }
        Color initialColor = this.getInitialColor();
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
        Color chosenColor = JColorChooser.showDialog((Component)e.getSource(), labels.getString("attribute.color.text"), initialColor);
        if (chosenColor != null) {
            HashMap<AttributeKey, Object> attr = new HashMap<AttributeKey, Object>(this.attributes);
            attr.put(this.key, chosenColor);
            this.applyAttributesTo(attr, this.getView().getSelectedFigures());
        }
    }

    public void selectionChanged(FigureSelectionEvent evt) {
    }

    protected Color getInitialColor() {
        Color initialColor = this.getEditor().getDefaultAttribute(this.key);
        if (initialColor == null) {
            initialColor = Color.red;
        }
        return initialColor;
    }
}

