/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import javax.swing.Action;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.ConnectionFigure;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.connector.Connector;
import org.jhotdraw.draw.event.FigureListener;
import org.jhotdraw.draw.handle.Handle;
import org.jhotdraw.draw.tool.Tool;
import org.jhotdraw.geom.Dimension2DDouble;

public interface Figure
extends Cloneable,
Serializable {
    public static final String CONNECTABLE_PROPERTY = "connectable";
    public static final String REMOVABLE_PROPERTY = "removable";
    public static final String SELECTABLE_PROPERTY = "selectable";
    public static final String TRANSFORMABLE_PROPERTY = "transformable";

    public void draw(Graphics2D var1);

    public int getLayer();

    public boolean isVisible();

    public void setBounds(Point2D.Double var1, Point2D.Double var2);

    public Point2D.Double getStartPoint();

    public Point2D.Double getEndPoint();

    public Rectangle2D.Double getBounds();

    public Rectangle2D.Double getDrawingArea();

    public Dimension2DDouble getPreferredSize();

    public boolean contains(Point2D.Double var1);

    public Object getTransformRestoreData();

    public void restoreTransformTo(Object var1);

    public void transform(AffineTransform var1);

    public <T> void set(AttributeKey<T> var1, @Nullable T var2);

    @Nullable
    public <T> T get(AttributeKey<T> var1);

    public Map<AttributeKey, Object> getAttributes();

    public Object getAttributesRestoreData();

    public void restoreAttributesTo(Object var1);

    public boolean isSelectable();

    public boolean isRemovable();

    public boolean isTransformable();

    public Collection<Handle> createHandles(int var1);

    public Cursor getCursor(Point2D.Double var1);

    public Collection<Action> getActions(Point2D.Double var1);

    @Nullable
    public Tool getTool(Point2D.Double var1);

    @Nullable
    public String getToolTipText(Point2D.Double var1);

    public boolean isConnectable();

    @Nullable
    public Connector findConnector(Point2D.Double var1, @Nullable ConnectionFigure var2);

    @Nullable
    public Connector findCompatibleConnector(Connector var1, boolean var2);

    public Collection<Connector> getConnectors(@Nullable ConnectionFigure var1);

    public boolean includes(Figure var1);

    @Nullable
    public Figure findFigureInside(Point2D.Double var1);

    public Collection<Figure> getDecomposition();

    public Figure clone();

    public void remap(Map<Figure, Figure> var1, boolean var2);

    public void addNotify(Drawing var1);

    public void removeNotify(Drawing var1);

    public void willChange();

    public void changed();

    public void requestRemove();

    public boolean handleDrop(Point2D.Double var1, Collection<Figure> var2, DrawingView var3);

    public boolean handleMouseClick(Point2D.Double var1, MouseEvent var2, DrawingView var3);

    public void addFigureListener(FigureListener var1);

    public void removeFigureListener(FigureListener var1);

    public void addPropertyChangeListener(PropertyChangeListener var1);

    public void removePropertyChangeListener(PropertyChangeListener var1);
}

