/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import org.jhotdraw.draw.AbstractAttributedFigure;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.DecoratedFigure;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.geom.Insets2D;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;
import org.jhotdraw.xml.DOMStorable;

public abstract class AbstractAttributedDecoratedFigure
extends AbstractAttributedFigure
implements DecoratedFigure,
DOMStorable {
    @Nullable
    private Figure decorator;

    @Override
    public final void draw(Graphics2D g) {
        if (this.decorator != null) {
            this.drawDecorator(g);
        }
        this.drawFigure(g);
    }

    protected void drawFigure(Graphics2D g) {
        super.draw(g);
    }

    protected void drawDecorator(Graphics2D g) {
        this.updateDecoratorBounds();
        this.decorator.draw(g);
    }

    @Override
    public final Rectangle2D.Double getDrawingArea() {
        Rectangle2D.Double r = this.getFigureDrawingArea();
        if (this.decorator != null) {
            this.updateDecoratorBounds();
            r.add(this.decorator.getDrawingArea());
        }
        return r;
    }

    protected Rectangle2D.Double getFigureDrawingArea() {
        return super.getDrawingArea();
    }

    @Override
    public void setDecorator(Figure newValue) {
        this.willChange();
        this.decorator = newValue;
        if (this.decorator != null) {
            this.decorator.setBounds(this.getStartPoint(), this.getEndPoint());
        }
        this.changed();
    }

    @Override
    public Figure getDecorator() {
        return this.decorator;
    }

    protected void updateDecoratorBounds() {
        if (this.decorator != null) {
            Point2D.Double sp = this.getStartPoint();
            Point2D.Double ep = this.getEndPoint();
            Insets2D.Double decoratorInsets = this.get(AttributeKeys.DECORATOR_INSETS);
            sp.x -= decoratorInsets.left;
            sp.y -= decoratorInsets.top;
            ep.x += decoratorInsets.right;
            ep.y += decoratorInsets.bottom;
            this.decorator.setBounds(sp, ep);
        }
    }

    @Override
    public final boolean contains(Point2D.Double p) {
        if (this.decorator != null) {
            this.updateDecoratorBounds();
            if (this.decorator.contains(p)) {
                return true;
            }
        }
        return this.figureContains(p);
    }

    protected abstract boolean figureContains(Point2D.Double var1);

    @Override
    public void read(DOMInput in) throws IOException {
        super.read(in);
        this.readDecorator(in);
    }

    @Override
    public void write(DOMOutput out) throws IOException {
        super.write(out);
        this.writeDecorator(out);
    }

    protected void writeDecorator(DOMOutput out) throws IOException {
        if (this.decorator != null) {
            out.openElement("decorator");
            out.writeObject(this.decorator);
            out.closeElement();
        }
    }

    protected void readDecorator(DOMInput in) throws IOException {
        if (in.getElementCount("decorator") > 0) {
            in.openElement("decorator");
            this.decorator = (Figure)in.readObject();
            in.closeElement();
        } else {
            this.decorator = null;
        }
    }

    @Override
    public AbstractAttributedDecoratedFigure clone() {
        AbstractAttributedDecoratedFigure that = (AbstractAttributedDecoratedFigure)super.clone();
        if (this.decorator != null) {
            that.decorator = this.decorator.clone();
        }
        return that;
    }
}

