/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.color;

import java.awt.Color;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.util.LinkedList;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jhotdraw.color.AbstractColorSlidersModel;
import org.jhotdraw.color.ColorSliderUI;
import org.jhotdraw.color.ColorUtil;

public class DefaultColorSliderModel
extends AbstractColorSlidersModel {
    protected ColorSpace colorSpace;
    protected LinkedList<JSlider> sliders = new LinkedList();
    protected DefaultBoundedRangeModel[] componentModels;

    public DefaultColorSliderModel() {
        this.setColorSpace(ICC_ColorSpace.getInstance(1000));
    }

    public DefaultColorSliderModel(ColorSpace sys) {
        this.setColorSpace(sys);
    }

    @Override
    public void setColorSpace(ColorSpace newValue) {
        ColorSpace oldValue = this.colorSpace;
        this.colorSpace = newValue;
        this.componentModels = new DefaultBoundedRangeModel[this.colorSpace.getNumComponents()];
        for (int i = 0; i < this.componentModels.length; ++i) {
            this.componentModels[i] = new DefaultBoundedRangeModel();
            if (this.colorSpace.getMaxValue(i) - this.colorSpace.getMinValue(i) >= 10.0f) {
                this.componentModels[i].setMinimum((int)this.colorSpace.getMinValue(i));
                this.componentModels[i].setMaximum((int)this.colorSpace.getMaxValue(i));
            } else {
                this.componentModels[i].setMinimum((int)(this.colorSpace.getMinValue(i) * 100.0f));
                this.componentModels[i].setMaximum((int)(this.colorSpace.getMaxValue(i) * 100.0f));
            }
            final int componentIndex = i;
            this.componentModels[i].addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    DefaultColorSliderModel.this.fireColorChanged(componentIndex);
                    DefaultColorSliderModel.this.fireStateChanged();
                }
            });
        }
    }

    @Override
    public void configureSlider(int componentIndex, JSlider slider) {
        if (slider.getClientProperty("colorSliderModel") != null) {
            ((DefaultColorSliderModel)slider.getClientProperty("colorSliderModel")).unconfigureSlider(slider);
        }
        if (!(slider.getUI() instanceof ColorSliderUI)) {
            slider.setUI((ColorSliderUI)ColorSliderUI.createUI(slider));
        }
        slider.setModel(this.getBoundedRangeModel(componentIndex));
        slider.putClientProperty("colorSliderModel", this);
        slider.putClientProperty("colorComponentIndex", componentIndex);
        this.addColorSlider(slider);
    }

    @Override
    public void unconfigureSlider(JSlider slider) {
        if (slider.getClientProperty("colorSliderModel") == this) {
            slider.setModel(new DefaultBoundedRangeModel());
            slider.putClientProperty("colorSliderModel", null);
            slider.putClientProperty("colorComponentIndex", null);
            this.removeColorSlider(slider);
        }
    }

    @Override
    public DefaultBoundedRangeModel getBoundedRangeModel(int componentIndex) {
        return this.componentModels[componentIndex];
    }

    public int getSliderValue(int componentIndex) {
        return this.componentModels[componentIndex].getValue();
    }

    public void setSliderValue(int componentIndex, int value) {
        this.componentModels[componentIndex].setValue(value);
    }

    public void addColorSlider(JSlider slider) {
        this.sliders.add(slider);
    }

    public void removeColorSlider(JSlider slider) {
        this.sliders.remove(slider);
    }

    protected void fireColorChanged(int componentIndex) {
        Integer index = componentIndex;
        Color value = this.getColor();
        for (JSlider slider : this.sliders) {
            slider.putClientProperty("colorComponentChange", index);
            slider.putClientProperty("colorComponentValue", value);
        }
    }

    @Override
    public ColorSpace getColorSpace() {
        return this.colorSpace;
    }

    @Override
    public int getComponentCount() {
        return this.colorSpace.getNumComponents();
    }

    @Override
    public Color getColor() {
        float[] c = new float[this.getComponentCount()];
        int i = 0;
        for (DefaultBoundedRangeModel brm : this.componentModels) {
            c[i] = (float)(brm.getValue() - brm.getMinimum()) / (float)(brm.getMaximum() - brm.getMinimum()) * (this.colorSpace.getMaxValue(i) - this.colorSpace.getMinValue(i)) + this.colorSpace.getMinValue(i);
            ++i;
        }
        try {
            return ColorUtil.toColor(this.colorSpace, c);
        }
        catch (IllegalArgumentException e) {
            for (i = 0; i < c.length; ++i) {
                System.err.println(i + "=" + c[i] + " " + this.colorSpace.getMinValue(i) + ".." + this.colorSpace.getMaxValue(i));
            }
            throw e;
        }
    }

    @Override
    public int getInterpolatedRGB(int i, float componentValue) {
        float[] c = new float[this.getComponentCount()];
        int j = 0;
        for (DefaultBoundedRangeModel brm : this.componentModels) {
            c[j] = (float)(brm.getValue() - brm.getMinimum()) / (float)(brm.getMaximum() - brm.getMinimum()) * (this.colorSpace.getMaxValue(j) - this.colorSpace.getMinValue(j)) + this.colorSpace.getMinValue(j);
            ++j;
        }
        c[i] = componentValue;
        return ColorUtil.toRGB(this.colorSpace, c);
    }

    @Override
    public void setComponent(int i, float newValue) {
        DefaultBoundedRangeModel brm = this.componentModels[i];
        brm.setValue((int)((newValue - this.colorSpace.getMinValue(i)) / (this.colorSpace.getMaxValue(i) - this.colorSpace.getMinValue(i)) * (float)(brm.getMaximum() - brm.getMinimum())) + brm.getMinimum());
    }

    @Override
    public float getComponent(int i) {
        DefaultBoundedRangeModel brm = this.componentModels[i];
        return (float)(brm.getValue() - brm.getMinimum()) / (float)(brm.getMaximum() - brm.getMinimum()) * (this.colorSpace.getMaxValue(i) - this.colorSpace.getMinValue(i)) + this.colorSpace.getMinValue(i);
    }

    @Override
    public void setColor(Color newValue) {
        float[] c = ColorUtil.fromColor(this.colorSpace, newValue);
        int i = 0;
        for (DefaultBoundedRangeModel brm : this.componentModels) {
            brm.setValue((int)((c[i] - this.colorSpace.getMinValue(i)) / (this.colorSpace.getMaxValue(i) - this.colorSpace.getMinValue(i)) * (float)(brm.getMaximum() - brm.getMinimum()) + (float)brm.getMinimum()));
            ++i;
        }
    }

    @Override
    public float[] getComponents() {
        float[] c = new float[this.getComponentCount()];
        for (int i = 0; i < c.length; ++i) {
            DefaultBoundedRangeModel brm = this.componentModels[i];
            c[i] = (float)(brm.getValue() - brm.getMinimum()) / (float)(brm.getMaximum() - brm.getMinimum()) * (this.colorSpace.getMaxValue(i) - this.colorSpace.getMinValue(i)) + this.colorSpace.getMinValue(i);
        }
        return c;
    }
}

