/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.color;

import java.awt.Color;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.text.ParseException;
import org.jhotdraw.color.CompositeColor;
import org.jhotdraw.color.NamedColorSpace;
import org.jhotdraw.text.ColorToolTipTextFormatter;

public class ColorUtil {
    private static ColorToolTipTextFormatter formatter;

    private ColorUtil() {
    }

    public static float[] fromColor(ColorSpace colorSpace, Color c) {
        if (ColorUtil.isEqual(c.getColorSpace(), colorSpace)) {
            float[] components = c.getComponents(null);
            return components;
        }
        return c.getComponents(colorSpace, null);
    }

    public static Color toColor(ColorSpace colorSpace, float ... components) {
        return new CompositeColor(colorSpace, components, 1.0f);
    }

    public static float[] fromRGB(ColorSpace colorSpace, int rgb) {
        return ColorUtil.fromRGB(colorSpace, rgb >>> 16 & 0xFF, rgb >>> 8 & 0xFF, rgb & 0xFF);
    }

    public static float[] fromRGB(ColorSpace colorSpace, int r, int g, int b) {
        return colorSpace.fromRGB(new float[]{(float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f});
    }

    public static int toRGB(ColorSpace colorSpace, float ... components) {
        float[] rgb = colorSpace.toRGB(components);
        if (rgb[0] < 0.0f || rgb[1] < 0.0f || rgb[2] < 0.0f || rgb[0] > 1.0f || rgb[1] > 1.0f || rgb[2] > 1.0f) {
            return 0;
        }
        return 0xFF000000 | (int)(rgb[0] * 255.0f) << 16 | (int)(rgb[1] * 255.0f) << 8 | (int)(rgb[2] * 255.0f);
    }

    public static String toToolTipText(Color c) {
        if (formatter == null) {
            formatter = new ColorToolTipTextFormatter();
        }
        try {
            return formatter.valueToString(c);
        }
        catch (ParseException ex) {
            InternalError error = new InternalError("Unable to generate tool tip text from color " + c);
            error.initCause(ex);
            throw error;
        }
    }

    public static boolean isEqual(ColorSpace a, ColorSpace b) {
        if (a instanceof ICC_ColorSpace && b instanceof ICC_ColorSpace) {
            ICC_ColorSpace aicc = (ICC_ColorSpace)a;
            ICC_ColorSpace bicc = (ICC_ColorSpace)b;
            ICC_Profile ap = aicc.getProfile();
            ICC_Profile bp = bicc.getProfile();
            return ap.equals(bp);
        }
        return a.equals(b);
    }

    public static String getName(ColorSpace a) {
        ICC_ColorSpace icc;
        ICC_Profile p;
        byte[] desc;
        if (a instanceof NamedColorSpace) {
            return ((NamedColorSpace)((Object)a)).getName();
        }
        if (a instanceof ICC_ColorSpace && (desc = (p = (icc = (ICC_ColorSpace)a).getProfile()).getData(1684370275)) != null) {
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(desc));
            try {
                int magic = in.readInt();
                int reserved = in.readInt();
                if (magic != 1684370275) {
                    throw new IOException("Illegal magic:" + Integer.toHexString(magic));
                }
                if (reserved != 0) {
                    throw new IOException("Illegal reserved:" + Integer.toHexString(reserved));
                }
                long nameLength = (long)in.readInt() & 0xFFFFFFFFL;
                StringBuilder buf = new StringBuilder();
                int i = 0;
                while ((long)i < nameLength - 1L) {
                    buf.append((char)in.readUnsignedByte());
                    ++i;
                }
                return buf.toString();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (a instanceof ICC_ColorSpace) {
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < a.getNumComponents(); ++i) {
                if (buf.length() > 0) {
                    buf.append("-");
                }
                buf.append(a.getName(i));
            }
            return buf.toString();
        }
        return a.getClass().getSimpleName();
    }

    public static Color shadow(Color c, int amount) {
        return new Color(Math.max(0, c.getRed() - amount), Math.max(0, c.getGreen() - amount), Math.max(0, c.getBlue() - amount), c.getAlpha());
    }
}

