/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.util.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.neuroph.util.VectorParser;
import org.neuroph.util.io.InputAdapter;
import org.neuroph.util.io.NeurophInputException;

public class InputStreamAdapter
implements InputAdapter {
    protected BufferedReader bufferedReader;

    public InputStreamAdapter(InputStream inputStream) {
        this.bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
    }

    public InputStreamAdapter(BufferedReader bufferedReader) {
        this.bufferedReader = bufferedReader;
    }

    @Override
    public double[] readInput() {
        try {
            String inputLine = this.bufferedReader.readLine();
            if (inputLine != null) {
                double[] inputBuffer = VectorParser.parseDoubleArray(inputLine);
                return inputBuffer;
            }
            return null;
        }
        catch (IOException ex) {
            throw new NeurophInputException("Error reading input from stream!", ex);
        }
    }

    @Override
    public void close() {
        try {
            if (this.bufferedReader != null) {
                this.bufferedReader.close();
            }
        }
        catch (IOException ex) {
            throw new NeurophInputException("Error closing stream!", ex);
        }
    }
}

