/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.samples.evaluation.optimization;

import org.neuroph.contrib.model.modelselection.MultilayerPerceptronOptimazer;
import org.neuroph.core.NeuralNetwork;
import org.neuroph.core.data.DataSet;
import org.neuroph.eval.Evaluation;
import org.neuroph.nnet.learning.BackPropagation;

public class IrisOptimization {
    public static void main(String[] args) {
        String inputFileName = "/iris_data.txt";
        DataSet irisDataSet = DataSet.createFromFile(inputFileName, 4, 3, ",", false);
        BackPropagation learningRule = IrisOptimization.createLearningRule();
        NeuralNetwork neuralNet = new MultilayerPerceptronOptimazer().withLearningRule(learningRule).createOptimalModel(irisDataSet);
        neuralNet.learn(irisDataSet);
        Evaluation.runFullEvaluation(neuralNet, irisDataSet);
    }

    private static BackPropagation createLearningRule() {
        BackPropagation learningRule = new BackPropagation();
        learningRule.setMaxIterations(50);
        learningRule.setMaxError(1.0E-4);
        return learningRule;
    }
}

