/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.samples.evaluation;

import org.neuroph.core.data.DataSet;
import org.neuroph.core.learning.error.MeanSquaredError;
import org.neuroph.eval.Evaluation;
import org.neuroph.nnet.MultiLayerPerceptron;
import org.neuroph.nnet.learning.BackPropagation;

public class TestMultiClass {
    private static final String inputFileName = "/iris_data.txt";

    public static void main(String[] args) {
        DataSet irisDataSet = TestMultiClass.loadDataSet();
        MultiLayerPerceptron neuralNet = new MultiLayerPerceptron(4, 15, 3);
        TestMultiClass.configureLearningRule(neuralNet);
        neuralNet.learn(irisDataSet);
        Evaluation.runFullEvaluation(neuralNet, irisDataSet);
    }

    private static DataSet loadDataSet() {
        DataSet irisDataSet = DataSet.createFromFile(inputFileName, 4, 3, ",", false);
        irisDataSet.shuffle();
        return irisDataSet;
    }

    private static void configureLearningRule(MultiLayerPerceptron neuralNet) {
        ((BackPropagation)neuralNet.getLearningRule()).setLearningRate(0.02);
        ((BackPropagation)neuralNet.getLearningRule()).setMaxError(0.01);
        ((BackPropagation)neuralNet.getLearningRule()).setErrorFunction(new MeanSquaredError());
    }
}

