/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.samples.convolution.mnist;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MNISTImage {
    private int label;
    private byte[] imageData;
    private static final int MAGIC_OFFSET = 0;
    private static final int OFFSET_SIZE = 4;
    private static final int LABEL_MAGIC = 2049;
    private static final int IMAGE_MAGIC = 2051;
    private static final int NUMBER_ITEMS_OFFSET = 4;
    private static final int ITEMS_SIZE = 4;
    public static final int ROWS = 28;
    private static final int NUMBER_OF_ROWS_OFFSET = 8;
    private static final int ROWS_SIZE = 4;
    public static final int COLUMNS = 28;
    private static final int NUMBER_OF_COLUMNS_OFFSET = 12;
    private static final int COLUMNS_SIZE = 4;
    private static final int IMAGE_OFFSET = 16;
    private static final int IMAGE_SIZE = 784;

    public MNISTImage(int label, byte[] imageData) {
        this.imageData = imageData;
        this.label = label;
    }

    public int getLabel() {
        return this.label;
    }

    public byte[] getData() {
        return this.imageData;
    }

    public int getSize() {
        return this.imageData.length;
    }

    public static List<MNISTImage> loadDigitImages(String labelFileName, String imageFileName) throws IOException {
        int read;
        ArrayList<MNISTImage> images = new ArrayList<MNISTImage>();
        ByteArrayOutputStream labelBuffer = new ByteArrayOutputStream();
        ByteArrayOutputStream imageBuffer = new ByteArrayOutputStream();
        FileInputStream labelInputStream = new FileInputStream(labelFileName);
        FileInputStream imageInputStream = new FileInputStream(imageFileName);
        byte[] buffer = new byte[16384];
        while ((read = ((InputStream)labelInputStream).read(buffer, 0, buffer.length)) != -1) {
            labelBuffer.write(buffer, 0, read);
        }
        labelBuffer.flush();
        while ((read = ((InputStream)imageInputStream).read(buffer, 0, buffer.length)) != -1) {
            imageBuffer.write(buffer, 0, read);
        }
        imageBuffer.flush();
        byte[] labelBytes = labelBuffer.toByteArray();
        byte[] imageBytes = imageBuffer.toByteArray();
        byte[] labelMagic = Arrays.copyOfRange(labelBytes, 0, 4);
        byte[] imageMagic = Arrays.copyOfRange(imageBytes, 0, 4);
        if (ByteBuffer.wrap(labelMagic).getInt() != 2049) {
            throw new IOException("Bad magic number in label file!");
        }
        if (ByteBuffer.wrap(imageMagic).getInt() != 2051) {
            throw new IOException("Bad magic number in image file!");
        }
        int numberOfLabels = ByteBuffer.wrap(Arrays.copyOfRange(labelBytes, 4, 8)).getInt();
        int numberOfImages = ByteBuffer.wrap(Arrays.copyOfRange(imageBytes, 4, 8)).getInt();
        if (numberOfImages != numberOfLabels) {
            throw new IOException("The number of labels and images do not match!");
        }
        int numRows = ByteBuffer.wrap(Arrays.copyOfRange(imageBytes, 8, 12)).getInt();
        int numCols = ByteBuffer.wrap(Arrays.copyOfRange(imageBytes, 12, 16)).getInt();
        if (numRows != 28 && numCols != 28) {
            throw new IOException("Bad image. Rows and columns do not equal 28x28");
        }
        for (int i = 0; i < numberOfLabels; ++i) {
            byte label = labelBytes[8 + i];
            byte[] imageData = Arrays.copyOfRange(imageBytes, i * 784 + 16, i * 784 + 16 + 784);
            images.add(new MNISTImage(label, imageData));
        }
        return images;
    }
}

