/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.samples;

import java.util.Arrays;
import org.neuroph.core.NeuralNetwork;
import org.neuroph.core.data.DataSet;
import org.neuroph.core.data.DataSetRow;
import org.neuroph.nnet.Perceptron;

public class PerceptronSample {
    public static void main(String[] args) {
        DataSet trainingSet = new DataSet(2, 1);
        trainingSet.addRow(new DataSetRow(new double[]{0.0, 0.0}, new double[]{0.0}));
        trainingSet.addRow(new DataSetRow(new double[]{0.0, 1.0}, new double[]{0.0}));
        trainingSet.addRow(new DataSetRow(new double[]{1.0, 0.0}, new double[]{0.0}));
        trainingSet.addRow(new DataSetRow(new double[]{1.0, 1.0}, new double[]{1.0}));
        Perceptron myPerceptron = new Perceptron(2, 1);
        myPerceptron.learn(trainingSet);
        System.out.println("Testing trained perceptron");
        PerceptronSample.testNeuralNetwork(myPerceptron, trainingSet);
        myPerceptron.save("mySamplePerceptron.nnet");
        NeuralNetwork loadedPerceptron = NeuralNetwork.load("mySamplePerceptron.nnet");
        System.out.println("Testing loaded perceptron");
        PerceptronSample.testNeuralNetwork(loadedPerceptron, trainingSet);
    }

    public static void testNeuralNetwork(NeuralNetwork neuralNet, DataSet testSet) {
        for (DataSetRow trainingElement : testSet.getRows()) {
            neuralNet.setInput(trainingElement.getInput());
            neuralNet.calculate();
            double[] networkOutput = neuralNet.getOutput();
            System.out.print("Input: " + Arrays.toString(trainingElement.getInput()));
            System.out.println(" Output: " + Arrays.toString(networkOutput));
        }
    }
}

