/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.samples;

import java.util.Arrays;
import org.neuroph.core.NeuralNetwork;
import org.neuroph.core.data.DataSet;
import org.neuroph.core.data.DataSetRow;
import org.neuroph.core.events.LearningEvent;
import org.neuroph.core.events.LearningEventListener;
import org.neuroph.nnet.MultiLayerPerceptron;
import org.neuroph.nnet.learning.BackPropagation;

public class IrisClassificationSample {
    public static void main(String[] args) {
        String inputFileName = "data_sets/iris_data_normalised.txt";
        MultiLayerPerceptron neuralNet = new MultiLayerPerceptron(4, 16, 3);
        DataSet irisDataSet = DataSet.createFromFile(inputFileName, 4, 3, ",");
        ((BackPropagation)neuralNet.getLearningRule()).addListener(new LearningListener());
        ((BackPropagation)neuralNet.getLearningRule()).setLearningRate(0.5);
        ((BackPropagation)neuralNet.getLearningRule()).setMaxError(0.01);
        ((BackPropagation)neuralNet.getLearningRule()).setMaxIterations(30000);
        neuralNet.learn(irisDataSet);
        neuralNet.save("irisNet.nnet");
        System.out.println("Done training.");
        System.out.println("Testing network...");
    }

    public static void testNeuralNetwork(NeuralNetwork neuralNet, DataSet testSet) {
        for (DataSetRow testSetRow : testSet.getRows()) {
            neuralNet.setInput(testSetRow.getInput());
            neuralNet.calculate();
            double[] networkOutput = neuralNet.getOutput();
            System.out.print("Input: " + Arrays.toString(testSetRow.getInput()));
            System.out.println(" Output: " + Arrays.toString(networkOutput));
        }
    }

    static class LearningListener
    implements LearningEventListener {
        LearningListener() {
        }

        @Override
        public void handleLearningEvent(LearningEvent event) {
            BackPropagation bp = (BackPropagation)event.getSource();
            System.out.println("Current iteration: " + bp.getCurrentIteration());
            System.out.println("Error: " + bp.getTotalNetworkError());
        }
    }
}

