/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.nnet.learning;

import org.neuroph.core.Connection;
import org.neuroph.core.Neuron;
import org.neuroph.core.data.DataSet;
import org.neuroph.core.learning.UnsupervisedLearning;

public class UnsupervisedHebbianLearning
extends UnsupervisedLearning {
    private static final long serialVersionUID = 1L;

    public UnsupervisedHebbianLearning() {
        this.setLearningRate(0.1);
    }

    @Override
    public void doLearningEpoch(DataSet trainingSet) {
        super.doLearningEpoch(trainingSet);
        this.stopLearning();
    }

    @Override
    protected void updateNetworkWeights() {
        for (Neuron neuron : this.neuralNetwork.getOutputNeurons()) {
            this.updateNeuronWeights(neuron);
        }
    }

    protected void updateNeuronWeights(Neuron neuron) {
        double output = neuron.getOutput();
        for (Connection connection : neuron.getInputConnections()) {
            double input = connection.getInput();
            double deltaWeight = input * output * this.learningRate;
            connection.getWeight().inc(deltaWeight);
        }
    }
}

