/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.nnet.learning;

import java.util.List;
import org.neuroph.core.Connection;
import org.neuroph.core.data.DataSet;
import org.neuroph.core.learning.UnsupervisedLearning;
import org.neuroph.nnet.comp.layer.CompetitiveLayer;
import org.neuroph.nnet.comp.neuron.CompetitiveNeuron;

public class CompetitiveLearning
extends UnsupervisedLearning {
    private static final long serialVersionUID = 1L;

    @Override
    public void doLearningEpoch(DataSet trainingSet) {
        super.doLearningEpoch(trainingSet);
        this.stopLearning();
    }

    @Override
    protected void updateNetworkWeights() {
        CompetitiveNeuron winningNeuron = ((CompetitiveLayer)this.neuralNetwork.getLayerAt(1)).getWinner();
        List<Connection> inputConnections = winningNeuron.getConnectionsFromOtherLayers();
        for (Connection connection : inputConnections) {
            double weight = connection.getWeight().getValue();
            double input = connection.getInput();
            double deltaWeight = this.learningRate * (input - weight);
            connection.getWeight().inc(deltaWeight);
        }
    }
}

