/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.nnet.comp.neuron;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;
import org.neuroph.core.Neuron;
import org.neuroph.core.input.InputFunction;
import org.neuroph.core.transfer.TransferFunction;

public class DelayedNeuron
extends Neuron {
    private static final long serialVersionUID = 1L;
    protected transient List<Double> outputHistory = new ArrayList<Double>(5);

    public DelayedNeuron(InputFunction inputFunction, TransferFunction transferFunction) {
        super(inputFunction, transferFunction);
        this.outputHistory.add(new Double(0.0));
    }

    @Override
    public void calculate() {
        super.calculate();
        this.outputHistory.add(0, new Double(this.output));
        if (this.outputHistory.size() > 5) {
            this.outputHistory.remove(5);
        }
    }

    public double getOutput(int delay) {
        return this.outputHistory.get(delay);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.outputHistory = new ArrayList<Double>(5);
    }
}

