/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.nnet.comp.neuron;

import java.util.ArrayList;
import java.util.List;
import org.neuroph.core.Connection;
import org.neuroph.core.input.InputFunction;
import org.neuroph.core.transfer.TransferFunction;
import org.neuroph.nnet.comp.neuron.DelayedNeuron;

public class CompetitiveNeuron
extends DelayedNeuron {
    private static final long serialVersionUID = 1L;
    private boolean isCompeting = false;
    private List<Connection> connectionsFromOtherLayers = new ArrayList<Connection>();
    private List<Connection> connectionsFromThisLayer = new ArrayList<Connection>();

    public CompetitiveNeuron(InputFunction inputFunction, TransferFunction transferFunction) {
        super(inputFunction, transferFunction);
        this.addInputConnection(this, 1.0);
    }

    @Override
    public void calculate() {
        if (this.isCompeting) {
            this.totalInput = this.inputFunction.getOutput(this.connectionsFromThisLayer);
        } else {
            this.totalInput = this.inputFunction.getOutput(this.connectionsFromOtherLayers);
            this.isCompeting = true;
        }
        this.output = this.transferFunction.getOutput(this.totalInput);
        this.outputHistory.add(0, new Double(this.output));
    }

    @Override
    public void addInputConnection(Connection connection) {
        super.addInputConnection(connection);
        if (connection.getFromNeuron().getParentLayer() == this.getParentLayer()) {
            this.connectionsFromThisLayer.add(connection);
        } else {
            this.connectionsFromOtherLayers.add(connection);
        }
    }

    public List<Connection> getConnectionsFromOtherLayers() {
        return this.connectionsFromOtherLayers;
    }

    @Override
    public void reset() {
        super.reset();
        this.isCompeting = false;
    }

    public boolean isCompeting() {
        return this.isCompeting;
    }

    public void setIsCompeting(boolean isCompeting) {
        this.isCompeting = isCompeting;
    }
}

