/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.nnet.comp.layer;

import org.neuroph.core.Layer;
import org.neuroph.core.Neuron;
import org.neuroph.nnet.comp.neuron.CompetitiveNeuron;
import org.neuroph.util.NeuronProperties;

public class CompetitiveLayer
extends Layer {
    private static final long serialVersionUID = 1L;
    private int maxIterations = 100;
    private CompetitiveNeuron winner;

    public CompetitiveLayer(int neuronNum, NeuronProperties neuronProperties) {
        super(neuronNum, neuronProperties);
    }

    @Override
    public void calculate() {
        boolean hasWinner = false;
        int iterationsCount = 0;
        while (!hasWinner) {
            int fireingNeurons = 0;
            for (Neuron neuron : this.getNeurons()) {
                neuron.calculate();
                if (!(neuron.getOutput() > 0.0)) continue;
                ++fireingNeurons;
            }
            if (iterationsCount > this.maxIterations) break;
            if (fireingNeurons == 1) {
                hasWinner = true;
            }
            ++iterationsCount;
        }
        if (hasWinner) {
            double maxOutput = Double.MIN_VALUE;
            for (Neuron neuron : this.getNeurons()) {
                CompetitiveNeuron cNeuron = (CompetitiveNeuron)neuron;
                cNeuron.setIsCompeting(false);
                if (!(cNeuron.getOutput() > maxOutput)) continue;
                maxOutput = cNeuron.getOutput();
                this.winner = cNeuron;
            }
        }
    }

    public CompetitiveNeuron getWinner() {
        return this.winner;
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public void setMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
    }
}

