/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.nnet.comp;

import org.neuroph.nnet.comp.layer.ConvolutionalLayer;
import org.neuroph.nnet.comp.layer.FeatureMapLayer;
import org.neuroph.nnet.comp.layer.FeatureMapsLayer;
import org.neuroph.nnet.comp.layer.PoolingLayer;

public class ConvolutionalUtils {
    public static void fullConnectMapLayers(FeatureMapsLayer fromLayer, FeatureMapsLayer toLayer) {
        block4: {
            block3: {
                if (!(toLayer instanceof ConvolutionalLayer)) break block3;
                for (int i = 0; i < fromLayer.getNumberOfMaps(); ++i) {
                    for (int j = 0; j < toLayer.getNumberOfMaps(); ++j) {
                        FeatureMapLayer fromMap = fromLayer.getFeatureMap(i);
                        FeatureMapLayer toMap = toLayer.getFeatureMap(j);
                        toLayer.connectMaps(fromMap, toMap);
                    }
                }
                break block4;
            }
            if (!(toLayer instanceof PoolingLayer)) break block4;
            for (int i = 0; i < toLayer.getNumberOfMaps(); ++i) {
                FeatureMapLayer fromMap = fromLayer.getFeatureMap(i);
                FeatureMapLayer toMap = toLayer.getFeatureMap(i);
                toLayer.connectMaps(fromMap, toMap);
            }
        }
    }

    public static void connectFeatureMaps(FeatureMapsLayer fromLayer, FeatureMapsLayer toLayer, int fromFeatureMapIndex, int toFeatureMapIndex) {
        FeatureMapLayer fromMap = fromLayer.getFeatureMap(fromFeatureMapIndex);
        FeatureMapLayer toMap = toLayer.getFeatureMap(toFeatureMapIndex);
        toLayer.connectMaps(fromMap, toMap);
    }
}

