/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.nnet;

import org.neuroph.core.Layer;
import org.neuroph.core.NeuralNetwork;
import org.neuroph.nnet.learning.OutstarLearning;
import org.neuroph.util.ConnectionFactory;
import org.neuroph.util.LayerFactory;
import org.neuroph.util.NeuralNetworkFactory;
import org.neuroph.util.NeuralNetworkType;
import org.neuroph.util.NeuronProperties;
import org.neuroph.util.TransferFunctionType;

public class Outstar
extends NeuralNetwork {
    private static final long serialVersionUID = 1L;

    public Outstar(int outputNeuronsCount) {
        this.createNetwork(outputNeuronsCount);
    }

    private void createNetwork(int outputNeuronsCount) {
        this.setNetworkType(NeuralNetworkType.OUTSTAR);
        NeuronProperties neuronProperties = new NeuronProperties();
        neuronProperties.setProperty("transferFunction", (Object)TransferFunctionType.STEP);
        Layer inputLayer = LayerFactory.createLayer(1, neuronProperties);
        this.addLayer(inputLayer);
        neuronProperties.setProperty("transferFunction", (Object)TransferFunctionType.RAMP);
        Layer outputLayer = LayerFactory.createLayer(outputNeuronsCount, neuronProperties);
        this.addLayer(outputLayer);
        ConnectionFactory.fullConnect(inputLayer, outputLayer);
        NeuralNetworkFactory.setDefaultIO(this);
        this.setLearningRule(new OutstarLearning());
    }
}

