/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.imgrec.filter.impl;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import org.neuroph.imgrec.ImageUtilities;
import org.neuroph.imgrec.filter.ImageFilter;

public class SobelEdgeDetection
implements ImageFilter,
Serializable {
    private transient BufferedImage originalImage;
    private transient BufferedImage filteredImage;
    private double[][] sobelX;
    private double[][] sobelY;
    private double treshold;

    @Override
    public BufferedImage processImage(BufferedImage image) {
        int j;
        int i;
        this.originalImage = image;
        int width = image.getWidth();
        int height = image.getHeight();
        this.filteredImage = new BufferedImage(width, height, image.getType());
        this.treshold = 0.1;
        this.generateSobelOperators();
        double[][] Gx = new double[width][height];
        double[][] Gy = new double[width][height];
        double[][] G = new double[width][height];
        double max = 0.0;
        for (i = 1; i < width - 1; ++i) {
            for (j = 1; j < height - 1; ++j) {
                Gx[i][j] = this.calculateGradient(i, j, this.sobelX);
                Gy[i][j] = this.calculateGradient(i, j, this.sobelY);
                G[i][j] = Math.abs(Gx[i][j]) + Math.abs(Gy[i][j]);
                if (!(G[i][j] > max)) continue;
                max = G[i][j];
            }
        }
        this.treshold *= max;
        for (i = 0; i < width; ++i) {
            for (j = 0; j < height; ++j) {
                int alpha = new Color(this.originalImage.getRGB(i, j)).getAlpha();
                int newColor = G[i][j] > this.treshold ? 0 : 255;
                int rgb = ImageUtilities.colorToRGB(alpha, newColor, newColor, newColor);
                this.filteredImage.setRGB(i, j, rgb);
            }
        }
        return this.filteredImage;
    }

    protected void generateSobelOperators() {
        this.sobelX = new double[3][3];
        this.sobelX[0][0] = -0.25;
        this.sobelX[0][1] = -0.5;
        this.sobelX[0][2] = -0.25;
        this.sobelX[1][0] = 0.0;
        this.sobelX[1][1] = 0.0;
        this.sobelX[1][2] = 0.0;
        this.sobelX[2][0] = 0.25;
        this.sobelX[2][1] = 0.5;
        this.sobelX[2][2] = 0.25;
        this.sobelY = new double[3][3];
        this.sobelY[0][0] = -0.25;
        this.sobelY[0][1] = 0.0;
        this.sobelY[0][2] = 0.25;
        this.sobelY[1][0] = -0.5;
        this.sobelY[1][1] = 0.0;
        this.sobelY[1][2] = 0.5;
        this.sobelY[2][0] = -0.25;
        this.sobelY[2][1] = 0.0;
        this.sobelY[2][2] = 0.25;
        double one = 1.0;
        double oneThird = one / 3.0;
        this.sobelX[0][0] = -oneThird;
        this.sobelX[0][1] = -oneThird;
        this.sobelX[0][2] = -oneThird;
        this.sobelX[1][0] = 0.0;
        this.sobelX[1][1] = 0.0;
        this.sobelX[1][2] = 0.0;
        this.sobelX[2][0] = oneThird;
        this.sobelX[2][1] = oneThird;
        this.sobelX[2][2] = oneThird;
        this.sobelY[0][0] = -oneThird;
        this.sobelY[0][1] = 0.0;
        this.sobelY[0][2] = oneThird;
        this.sobelY[1][0] = -oneThird;
        this.sobelY[1][1] = 0.0;
        this.sobelY[1][2] = oneThird;
        this.sobelY[2][0] = -oneThird;
        this.sobelY[2][1] = 0.0;
        this.sobelY[2][2] = oneThird;
    }

    protected double calculateGradient(int i, int j, double[][] sobelOperator) {
        double sum = 0.0;
        int posX = 0;
        for (int x = i - 1; x <= i + 1; ++x) {
            int posY = 0;
            for (int y = j - 1; y <= j + 1; ++y) {
                double gray = new Color(this.originalImage.getRGB(x, y)).getRed();
                sum += gray * sobelOperator[posX][posY];
                ++posY;
            }
            ++posX;
        }
        return sum;
    }

    public void setTreshold(double treshold) {
        this.treshold = treshold;
    }

    public String toString() {
        return "Sobel method";
    }
}

