/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.imgrec;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.neuroph.imgrec.FractionRgbData;
import org.neuroph.imgrec.image.Image;

public class ImageUtilities {
    public static BufferedImage blackAndWhiteCleaning(BufferedImage image) {
        for (int j = 0; j < image.getHeight(); ++j) {
            for (int i = 0; i < image.getWidth(); ++i) {
                if (image.getRGB(i, j) == -16777216) continue;
                image.setRGB(i, j, -1);
            }
        }
        return image;
    }

    public static BufferedImage blackAndGrayCleaning(BufferedImage image) {
        for (int j = 0; j < image.getHeight(); ++j) {
            for (int i = 0; i < image.getWidth(); ++i) {
                if (image.getRGB(i, j) > -4473925) {
                    image.setRGB(i, j, -1);
                    continue;
                }
                image.setRGB(i, j, -16777216);
            }
        }
        return image;
    }

    public static BufferedImage blackAndLightGrayCleaning(BufferedImage image) {
        for (int j = 0; j < image.getHeight(); ++j) {
            for (int i = 0; i < image.getWidth(); ++i) {
                if (image.getRGB(i, j) > -4473925) {
                    image.setRGB(i, j, -1);
                    continue;
                }
                image.setRGB(i, j, -16777216);
            }
        }
        return image;
    }

    public static BufferedImage colorCleaning(BufferedImage image, int RGBcolor) {
        for (int j = 0; j < image.getHeight(); ++j) {
            for (int i = 0; i < image.getWidth(); ++i) {
                if (image.getRGB(i, j) == RGBcolor) {
                    image.setRGB(i, j, -16777216);
                    continue;
                }
                image.setRGB(i, j, -1);
            }
        }
        return image;
    }

    public static BufferedImage loadAndCleanImage(File file) {
        try {
            BufferedImage image = ImageIO.read(file);
            return ImageUtilities.blackAndLightGrayCleaning(image);
        }
        catch (IOException ex) {
            Logger.getLogger(ImageUtilities.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public static BufferedImage loadImage(File file) {
        try {
            return ImageIO.read(file);
        }
        catch (IOException ex) {
            throw new RuntimeException("IOException whle trying to load image file" + file.getName(), ex);
        }
    }

    public static void save(BufferedImage image, String filename, String type) {
        try {
            ImageIO.write((RenderedImage)image, type, new File(filename));
        }
        catch (IOException ex) {
            throw new RuntimeException("IOException whle trying to save image file" + filename, ex);
        }
    }

    private static int trimLockup(BufferedImage img) {
        for (int j = 0; j < img.getHeight(); ++j) {
            for (int i = 0; i < img.getWidth(); ++i) {
                if (img.getRGB(i, j) != -16777216) continue;
                return j;
            }
        }
        return 0;
    }

    private static int trimLockdown(BufferedImage img, int y1) {
        for (int j = y1 + 1; j < img.getHeight(); ++j) {
            int counterWhite = 0;
            for (int i = 0; i < img.getWidth(); ++i) {
                if (img.getRGB(i, j) != -1) continue;
                ++counterWhite;
            }
            if (counterWhite == img.getWidth() && j > img.getHeight() / 2) {
                return j;
            }
            if (j != img.getHeight() - 1) continue;
            return j + 1;
        }
        return 0;
    }

    public static BufferedImage trimImage(BufferedImage imageToTrim) {
        int y1 = ImageUtilities.trimLockup(imageToTrim);
        int y2 = ImageUtilities.trimLockdown(imageToTrim, y1);
        int x1 = 0;
        int x2 = imageToTrim.getWidth();
        return ImageUtilities.cropImage(imageToTrim, x1, y1, x2, y2);
    }

    public static BufferedImage resizeImage(BufferedImage image, int width, int height) {
        BufferedImage resizedImage = new BufferedImage(width, height, 1);
        Graphics2D g = resizedImage.createGraphics();
        g.drawImage(image, 0, 0, width, height, null);
        g.dispose();
        return resizedImage;
    }

    public static Image resizeImage(Image image, int width, int height) {
        return image.resize(width, height);
    }

    public static BufferedImage cropImage(BufferedImage image, int x1, int y1, int x2, int y2) {
        return image.getSubimage(x1, y1, x2 - x1, y2 - y1);
    }

    public static Map<String, FractionRgbData> getFractionRgbDataForImages(HashMap<String, BufferedImage> imagesData) {
        HashMap<String, FractionRgbData> rgbDataMap = new HashMap<String, FractionRgbData>();
        for (String imageName : imagesData.keySet()) {
            StringTokenizer st = new StringTokenizer(imageName, ".");
            BufferedImage image = imagesData.get(imageName);
            rgbDataMap.put(st.nextToken(), new FractionRgbData(image));
        }
        return rgbDataMap;
    }

    public static int colorToRGB(int alpha, int red, int green, int blue) {
        int newPixel = 0;
        newPixel += alpha;
        newPixel <<= 8;
        newPixel += red;
        newPixel <<= 8;
        newPixel += green;
        newPixel <<= 8;
        return newPixel += blue;
    }
}

