/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.imgrec;

import java.awt.image.BufferedImage;
import java.util.Arrays;
import org.neuroph.imgrec.image.Color;
import org.neuroph.imgrec.image.Image;
import org.neuroph.imgrec.image.ImageJ2SE;

public class FractionRgbData {
    private int width;
    private int height;
    protected double[][] redValues;
    protected double[][] greenValues;
    protected double[][] blueValues;
    protected double[] flattenedRgbValues;

    public FractionRgbData(Image img) {
        this.width = img.getWidth();
        this.height = img.getHeight();
        this.redValues = new double[this.height][this.width];
        this.greenValues = new double[this.height][this.width];
        this.blueValues = new double[this.height][this.width];
        this.flattenedRgbValues = new double[this.width * this.height * 3];
        this.populateRGBArrays(img);
    }

    public FractionRgbData(BufferedImage img) {
        this(new ImageJ2SE(img));
    }

    protected final void populateRGBArrays(Image image) {
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                double blue;
                double green;
                double red;
                int color = image.getPixel(x, y);
                this.redValues[y][x] = red = (double)Color.getRed(color) / 256.0;
                this.flattenedRgbValues[y * this.width + x] = red;
                this.greenValues[y][x] = green = (double)Color.getGreen(color) / 256.0;
                this.flattenedRgbValues[this.width * this.height + y * this.width + x] = green;
                this.blueValues[y][x] = blue = (double)Color.getBlue(color) / 256.0;
                this.flattenedRgbValues[2 * this.width * this.height + y * this.width + x] = blue;
            }
        }
    }

    public static double[] convertRgbInputToBinaryBlackAndWhite(double[] inputRGB) {
        int length = inputRGB.length / 3;
        double[] inputBinary = new double[length];
        for (int i = 0; i < length; ++i) {
            double rgbColorAvg = (inputRGB[i] + inputRGB[length + i] + inputRGB[2 * length + i]) / 3.0;
            inputBinary[i] = rgbColorAvg < 0.19 ? 1.0 : 0.0;
        }
        return inputBinary;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public double[][] getRedValues() {
        return this.redValues;
    }

    public double[][] getGreenValues() {
        return this.greenValues;
    }

    public double[][] getBlueValues() {
        return this.blueValues;
    }

    public double[] getFlattenedRgbValues() {
        return this.flattenedRgbValues;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof FractionRgbData)) {
            return false;
        }
        FractionRgbData other = (FractionRgbData)obj;
        return Arrays.equals(this.flattenedRgbValues, other.getFlattenedRgbValues());
    }

    public int hashCode() {
        return Arrays.hashCode(this.flattenedRgbValues);
    }

    public String toString() {
        return Arrays.toString(this.flattenedRgbValues);
    }
}

