/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.imgrec;

import java.awt.Color;
import java.awt.image.BufferedImage;
import org.neuroph.imgrec.image.Image;
import org.neuroph.imgrec.image.ImageJ2SE;

public class FractionHSLData {
    private int width;
    private int height;
    protected double[][] hueValues;
    protected double[][] saturationValues;
    protected double[][] lightnessValues;
    protected double[] flattenedHSLValues;
    protected double[] flattenedHueValues;

    public FractionHSLData(BufferedImage img) {
        if (img != null) {
            this.width = img.getWidth();
            this.height = img.getHeight();
            this.hueValues = new double[this.height][this.width];
            this.saturationValues = new double[this.height][this.width];
            this.lightnessValues = new double[this.height][this.width];
            this.flattenedHSLValues = new double[this.width * this.height * 3];
            this.flattenedHueValues = new double[this.width * this.height];
            this.populateHSLArrays(new ImageJ2SE(img));
        } else {
            this.width = 0;
            this.height = 0;
            this.hueValues = null;
            this.saturationValues = null;
            this.lightnessValues = null;
            this.flattenedHSLValues = null;
            this.flattenedHueValues = null;
        }
    }

    public FractionHSLData(Image img) {
        this.width = img.getWidth();
        this.height = img.getHeight();
        this.hueValues = new double[this.height][this.width];
        this.saturationValues = new double[this.height][this.width];
        this.lightnessValues = new double[this.height][this.width];
        this.flattenedHSLValues = new double[this.width * this.height * 3];
        this.flattenedHueValues = new double[this.width * this.height];
        this.populateHSLArrays(img);
    }

    protected void populateHSLArrays(Image image) {
        for (int j = 0; j < this.width; ++j) {
            for (int i = 0; i < this.height; ++i) {
                double lightness;
                Color color = new Color(image.getPixel(j, i));
                double red = color.getRed();
                double green = color.getGreen();
                double blue = color.getBlue();
                double Cmax = Math.max(red /= 255.0, Math.max(green /= 255.0, blue /= 255.0));
                double Cmin = Math.min(red, Math.min(green, blue));
                double delta = Cmax - Cmin;
                double hue = 0.0;
                if (delta != 0.0) {
                    if (Cmax == red) {
                        hue = 60.0 * ((green - blue) / delta % 6.0);
                    }
                    if (Cmax == green) {
                        hue = 60.0 * ((blue - red) / delta + 2.0);
                    }
                    if (Cmax == blue) {
                        hue = 60.0 * ((red - green) / delta + 4.0);
                    }
                } else {
                    double a = (2.0 * red - green - blue) / 2.0;
                    double b = (green - blue) * Math.sqrt(3.0) / 2.0;
                    hue = Math.atan2(b, a);
                }
                this.hueValues[i][j] = hue / 360.0;
                this.lightnessValues[i][j] = lightness = (Cmax + Cmin) / 2.0;
                double saturation = 0.0;
                saturation = delta == 0.0 ? 0.0 : delta / (1.0 - Math.abs(2.0 * lightness - 1.0));
                this.saturationValues[i][j] = saturation;
            }
        }
    }

    public void fillFlattenedHueValues() {
        int position = 0;
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.height; ++j) {
                this.flattenedHueValues[position++] = this.hueValues[i][j];
            }
        }
    }

    public void fillFlattenedHSLValues() {
        int positionHue = 0;
        int positionSaturation = 1;
        int positionLighteness = 2;
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                this.flattenedHSLValues[positionHue] = this.hueValues[i][j];
                this.flattenedHSLValues[positionSaturation] = this.saturationValues[i][j];
                this.flattenedHSLValues[positionLighteness] = this.lightnessValues[i][j];
                positionHue += 3;
                positionSaturation += 3;
                positionLighteness += 3;
            }
        }
    }

    public double[][] getHueValues() {
        return this.hueValues;
    }

    public double[][] getSaturationValues() {
        return this.saturationValues;
    }

    public double[][] getLightnessValues() {
        return this.lightnessValues;
    }

    public double[] getFlattenedHSLValues() {
        return this.flattenedHSLValues;
    }
}

