/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.eval;

import org.neuroph.eval.Evaluator;
import org.neuroph.eval.classification.ConfusionMatrix;
import org.neuroph.eval.classification.Utils;

public abstract class ClassifierEvaluator
implements Evaluator<ConfusionMatrix> {
    private final String[] classLabels;
    private double threshold;
    ConfusionMatrix confusionMatrix;

    private ClassifierEvaluator(String[] labels) {
        this.classLabels = labels;
        this.confusionMatrix = new ConfusionMatrix(labels);
    }

    @Override
    public ConfusionMatrix getResult() {
        return this.confusionMatrix;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public final void setThreshold(double threshold) {
        this.threshold = threshold;
    }

    @Override
    public void reset() {
        this.confusionMatrix = new ConfusionMatrix(this.classLabels);
    }

    public static class MultiClass
    extends ClassifierEvaluator {
        public MultiClass(String[] classLabels) {
            super(classLabels);
        }

        @Override
        public void processNetworkResult(double[] predictedOutput, double[] actualOutput) {
            int actualClassIdx = Utils.maxIdx(actualOutput);
            int predictedClassIdx = Utils.maxIdx(predictedOutput);
            this.confusionMatrix.incrementElement(actualClassIdx, predictedClassIdx);
        }
    }

    public static final class Binary
    extends ClassifierEvaluator {
        public static final String[] CLASS_LABELS = new String[]{"True", "False"};

        public Binary(double threshold) {
            super(CLASS_LABELS);
            this.setThreshold(threshold);
        }

        @Override
        public void processNetworkResult(double[] networkOutput, double[] desiredOutput) {
            boolean predictedClass;
            boolean actualClass = desiredOutput[0] > 0.0;
            boolean bl = predictedClass = networkOutput[0] > this.getThreshold();
            if (actualClass && predictedClass) {
                this.confusionMatrix.incrementElement(0, 0);
            } else if (actualClass && !predictedClass) {
                this.confusionMatrix.incrementElement(0, 1);
            } else if (!actualClass && predictedClass) {
                this.confusionMatrix.incrementElement(1, 0);
            } else if (!actualClass && !predictedClass) {
                this.confusionMatrix.incrementElement(1, 1);
            }
        }
    }
}

