/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.core.input;

import java.util.List;
import org.neuroph.core.Connection;
import org.neuroph.core.Neuron;
import org.neuroph.core.Weight;
import org.neuroph.core.input.InputFunction;

public class EuclideanRBF
extends InputFunction {
    @Override
    public double getOutput(List<Connection> inputConnections) {
        double sqrSum = 0.0;
        for (Connection connection : inputConnections) {
            Neuron neuron = connection.getFromNeuron();
            Weight weight = connection.getWeight();
            double diff = neuron.getOutput() - weight.getValue();
            sqrSum += diff * diff;
        }
        return 0.5 * Math.sqrt(sqrSum) / (double)inputConnections.size();
    }
}

