/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.core.data;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.neuroph.core.data.DataSetRow;
import org.neuroph.core.exceptions.NeurophException;
import org.neuroph.core.exceptions.VectorSizeMismatchException;
import org.neuroph.util.DataSetColumnType;
import org.neuroph.util.data.sample.Sampling;
import org.neuroph.util.data.sample.SubSampling;

public class DataSet
implements List<DataSetRow>,
Serializable {
    private static final long serialVersionUID = 2L;
    private List<DataSetRow> rows = new ArrayList<DataSetRow>();
    private int inputSize = 0;
    private int outputSize = 0;
    private String[] columnNames;
    private boolean isSupervised = false;
    private String label;
    private transient String filePath;
    private DataSetColumnType[] columnTypes;

    public DataSet(int inputSize) {
        this.inputSize = inputSize;
        this.isSupervised = false;
        this.setDefaultColumnNames();
        this.setDefaultColumnTypes();
    }

    public DataSet(int inputSize, int outputSize) {
        this.inputSize = inputSize;
        this.outputSize = outputSize;
        this.isSupervised = true;
        this.setDefaultColumnNames();
        this.setDefaultColumnTypes();
    }

    public boolean addRow(DataSetRow row) throws VectorSizeMismatchException {
        if (row == null) {
            throw new IllegalArgumentException("Data set row cannot be null!");
        }
        if (this.inputSize != 0 && row.getInput().length != this.inputSize) {
            throw new VectorSizeMismatchException("Input vector size does not match data set input size!");
        }
        if (this.outputSize != 0 && row.getDesiredOutput().length != this.outputSize) {
            throw new VectorSizeMismatchException("Output vector size does not match data set output size!");
        }
        return this.rows.add(row);
    }

    public void addRow(double[] input) {
        if (input == null) {
            throw new IllegalArgumentException("Input for dataset row cannot be null!");
        }
        if (input.length != this.inputSize) {
            throw new NeurophException("Input size for given row is different from the data set size!");
        }
        if (this.isSupervised) {
            throw new NeurophException("Cannot add unsupervised row to supervised data set!");
        }
        this.addRow(new DataSetRow(input));
    }

    public void addRow(double[] input, double[] output) {
        this.addRow(new DataSetRow(input, output));
    }

    public void removeRowAt(int idx) {
        this.rows.remove(idx);
    }

    @Override
    public Iterator<DataSetRow> iterator() {
        return this.rows.iterator();
    }

    public List<DataSetRow> getRows() {
        return this.rows;
    }

    public DataSetRow getRowAt(int idx) {
        return this.rows.get(idx);
    }

    @Override
    public void clear() {
        this.rows.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.rows.isEmpty();
    }

    public boolean isSupervised() {
        return this.isSupervised;
    }

    @Override
    public int size() {
        return this.rows.size();
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public void setColumnNames(String[] columnNames) {
        this.columnNames = columnNames;
    }

    public String getColumnName(int idx) {
        return this.columnNames[idx];
    }

    public void setColumnName(int idx, String columnName) {
        this.columnNames[idx] = columnName;
    }

    public DataSetColumnType[] getColumnTypes() {
        return this.columnTypes;
    }

    public DataSetColumnType getColumnType(int index) {
        return this.columnTypes[index];
    }

    public void setColumnType(int index, DataSetColumnType columnType) {
        this.columnTypes[index] = columnType;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Dataset Label: ").append(this.label).append(System.lineSeparator());
        if (this.columnNames != null) {
            sb.append("Columns: ");
            for (String columnName : this.columnNames) {
                sb.append(columnName).append(", ");
            }
            sb.delete(sb.length() - 2, sb.length() - 1);
            sb.append(System.lineSeparator());
        }
        for (DataSetRow row : this.rows) {
            sb.append(row).append(System.lineSeparator());
        }
        return sb.toString();
    }

    public String toCSV() {
        StringBuilder sb = new StringBuilder();
        if (this.columnNames != null && this.columnNames.length > 0) {
            for (String columnName : this.columnNames) {
                sb.append(columnName).append(", ");
            }
            sb.delete(sb.length() - 2, sb.length() - 1);
            sb.append(System.lineSeparator());
        }
        for (DataSetRow row : this.rows) {
            sb.append(row.toCSV());
            sb.append(System.lineSeparator());
        }
        return sb.toString();
    }

    public void save(String filePath) {
        this.filePath = filePath;
        this.save();
    }

    public void save() {
        if (this.filePath == null) {
            throw new NeurophException("filePath is null! It must be specified in order to save file!");
        }
        try (ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(this.filePath)));){
            out.writeObject(this);
            out.flush();
            out.close();
        }
        catch (IOException ioe) {
            throw new NeurophException(ioe);
        }
    }

    public void saveAsTxt(String filePath, String delimiter) {
        if (filePath == null) {
            throw new IllegalArgumentException("File path is null!");
        }
        if (delimiter == null || delimiter.equals("")) {
            delimiter = " ";
        }
        try (PrintWriter out = new PrintWriter(new FileWriter(new File(filePath)));){
            int columnCount = this.inputSize + this.outputSize;
            if (this.columnNames != null && this.columnNames.length > 0) {
                for (int i = 0; i < this.columnNames.length; ++i) {
                    out.print(this.columnNames[i]);
                    if (i >= columnCount - 1) continue;
                    out.print(delimiter);
                }
                out.println();
            }
            for (DataSetRow row : this.rows) {
                double[] input = row.getInput();
                for (int i = 0; i < input.length; ++i) {
                    out.print(input[i]);
                    if (i >= columnCount - 1) continue;
                    out.print(delimiter);
                }
                if (row.isSupervised()) {
                    double[] output = row.getDesiredOutput();
                    for (int j = 0; j < output.length; ++j) {
                        out.print(output[j]);
                        if (this.inputSize + j >= columnCount - 1) continue;
                        out.print(delimiter);
                    }
                }
                out.println();
            }
            out.flush();
        }
        catch (IOException ex) {
            throw new NeurophException("Error saving data set file!", ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DataSet load(String filePath) {
        try (ObjectInputStream oistream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(filePath)));){
            DataSet dataSet = (DataSet)oistream.readObject();
            dataSet.setFilePath(filePath);
            DataSet dataSet2 = dataSet;
            return dataSet2;
        }
        catch (FileNotFoundException fnfe) {
            throw new NeurophException("Could not find file: '" + filePath + "'!", fnfe);
        }
        catch (IOException ioe) {
            throw new NeurophException("Error reading file: '" + filePath + "'!", ioe);
        }
        catch (ClassNotFoundException ex) {
            throw new NeurophException("Class not found while trying to read DataSet object from the stream!", ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DataSet createFromFile(String filePath, int inputsCount, int outputsCount, String delimiter, boolean loadColumnNames) {
        if (filePath == null) {
            throw new IllegalArgumentException("File name cannot be null!");
        }
        if (inputsCount <= 0) {
            throw new IllegalArgumentException("Number of inputs cannot be <= 0 : " + inputsCount);
        }
        if (outputsCount < 0) {
            throw new IllegalArgumentException("Number of outputs cannot be < 0 : " + outputsCount);
        }
        if (delimiter == null) throw new IllegalArgumentException("Delimiter cannot be null or empty!");
        if (delimiter.isEmpty()) {
            throw new IllegalArgumentException("Delimiter cannot be null or empty!");
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(filePath));){
            DataSet dataSet = new DataSet(inputsCount, outputsCount);
            dataSet.setFilePath(filePath);
            String line = null;
            if (loadColumnNames) {
                line = reader.readLine();
                String[] colNames = line.split(delimiter);
                dataSet.setColumnNames(colNames);
            } else {
                dataSet.setDefaultColumnNames();
            }
            while ((line = reader.readLine()) != null) {
                int i;
                String[] values = line.split(delimiter);
                double[] inputs = new double[inputsCount];
                double[] outputs = new double[outputsCount];
                if (values[0].equals("")) continue;
                for (i = 0; i < inputsCount; ++i) {
                    inputs[i] = Double.parseDouble(values[i]);
                }
                for (i = 0; i < outputsCount; ++i) {
                    outputs[i] = Double.parseDouble(values[inputsCount + i]);
                }
                if (outputsCount > 0) {
                    dataSet.addRow(new DataSetRow(inputs, outputs));
                    continue;
                }
                dataSet.addRow(new DataSetRow(inputs));
            }
            reader.close();
            DataSet dataSet2 = dataSet;
            return dataSet2;
        }
        catch (FileNotFoundException ex) {
            throw new NeurophException("Could not find data set file!", ex);
        }
        catch (IOException ex) {
            throw new NeurophException("Error reading data set file!", ex);
        }
        catch (NumberFormatException ex) {
            ex.printStackTrace();
            throw new NeurophException("Bad number format in data set file!", ex);
        }
    }

    public static DataSet createFromFile(String filePath, int inputsCount, int outputsCount, String delimiter) {
        return DataSet.createFromFile(filePath, inputsCount, outputsCount, delimiter, false);
    }

    public DataSet[] createTrainingAndTestSubsets(int trainSetPercent, int testSetPercent) {
        SubSampling sampling = new SubSampling(trainSetPercent, testSetPercent);
        DataSet[] trainAndTestSet = new DataSet[2];
        sampling.sample(this).toArray(trainAndTestSet);
        return trainAndTestSet;
    }

    public List<DataSet> split(int ... sizePercents) {
        SubSampling sampling = new SubSampling(sizePercents);
        return sampling.sample(this);
    }

    public List<DataSet> sample(Sampling sampling) {
        return sampling.sample(this);
    }

    public int getOutputSize() {
        return this.outputSize;
    }

    public int getInputSize() {
        return this.inputSize;
    }

    public void shuffle() {
        Collections.shuffle(this.rows);
    }

    @Override
    public boolean contains(Object o) {
        return this.rows.contains(o);
    }

    @Override
    public Object[] toArray() {
        return this.rows.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.rows.toArray(a);
    }

    @Override
    public boolean add(DataSetRow row) {
        return this.rows.add(row);
    }

    @Override
    public boolean remove(Object row) {
        return this.rows.remove(row);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.rows.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends DataSetRow> c) {
        return this.rows.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends DataSetRow> c) {
        return this.rows.addAll(index, c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.rows.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.rows.retainAll(c);
    }

    @Override
    public DataSetRow get(int index) {
        return this.rows.get(index);
    }

    @Override
    public DataSetRow set(int index, DataSetRow row) {
        return this.rows.set(index, row);
    }

    @Override
    public void add(int index, DataSetRow row) {
        this.rows.add(index, row);
    }

    @Override
    public DataSetRow remove(int index) {
        return this.rows.remove(index);
    }

    @Override
    public int indexOf(Object row) {
        return this.rows.indexOf(row);
    }

    @Override
    public int lastIndexOf(Object row) {
        return this.rows.lastIndexOf(row);
    }

    @Override
    public ListIterator<DataSetRow> listIterator() {
        return this.rows.listIterator();
    }

    @Override
    public ListIterator<DataSetRow> listIterator(int index) {
        return this.rows.listIterator(index);
    }

    @Override
    public List<DataSetRow> subList(int fromIndex, int toIndex) {
        return this.rows.subList(fromIndex, toIndex);
    }

    private void setDefaultColumnNames() {
        int i;
        this.columnNames = new String[this.inputSize + this.outputSize];
        for (i = 0; i < this.inputSize; ++i) {
            this.columnNames[i] = "Input" + (i + 1);
        }
        for (i = 0; i < this.outputSize; ++i) {
            this.columnNames[this.inputSize + i] = "Output" + (i + 1);
        }
    }

    private void setDefaultColumnTypes() {
        int i;
        this.columnTypes = new DataSetColumnType[this.inputSize + this.outputSize];
        for (i = 0; i < this.inputSize; ++i) {
            this.columnTypes[i] = DataSetColumnType.NUMERIC;
        }
        for (i = 0; i < this.outputSize; ++i) {
            this.columnTypes[this.inputSize + i] = DataSetColumnType.NUMERIC;
        }
    }
}

