/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.neuroph.core.Connection;
import org.neuroph.core.Layer;
import org.neuroph.core.Weight;
import org.neuroph.core.input.InputFunction;
import org.neuroph.core.input.WeightedSum;
import org.neuroph.core.transfer.Step;
import org.neuroph.core.transfer.TransferFunction;

public class Neuron
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 4L;
    protected Layer parentLayer;
    protected List<Connection> inputConnections;
    protected List<Connection> outConnections;
    protected transient double totalInput = 0.0;
    protected transient double output = 0.0;
    protected transient double delta = 0.0;
    protected InputFunction inputFunction;
    protected TransferFunction transferFunction;
    private String label;

    public Neuron() {
        this.inputFunction = new WeightedSum();
        this.transferFunction = new Step();
        this.inputConnections = new ArrayList<Connection>();
        this.outConnections = new ArrayList<Connection>();
    }

    public Neuron(InputFunction inputFunction, TransferFunction transferFunction) {
        if (inputFunction == null) {
            throw new IllegalArgumentException("Input function cannot be null!");
        }
        if (transferFunction == null) {
            throw new IllegalArgumentException("Transfer function cannot be null!");
        }
        this.inputFunction = inputFunction;
        this.transferFunction = transferFunction;
        this.inputConnections = new ArrayList<Connection>();
        this.outConnections = new ArrayList<Connection>();
    }

    public void calculate() {
        this.totalInput = this.inputFunction.getOutput(this.inputConnections);
        this.output = this.transferFunction.getOutput(this.totalInput);
    }

    public void reset() {
        this.setInput(0.0);
        this.setOutput(0.0);
    }

    public void setInput(double input) {
        this.totalInput = input;
    }

    public double getNetInput() {
        return this.totalInput;
    }

    public double getOutput() {
        return this.output;
    }

    public boolean hasInputConnections() {
        return this.inputConnections.size() > 0;
    }

    public boolean hasOutputConnectionTo(Neuron toNeuron) {
        for (Connection connection : this.outConnections) {
            if (connection.getToNeuron() != toNeuron) continue;
            return true;
        }
        return false;
    }

    public boolean hasInputConnectionFrom(Neuron neuron) {
        for (Connection connection : this.inputConnections) {
            if (connection.getFromNeuron() != neuron) continue;
            return true;
        }
        return false;
    }

    public void addInputConnection(Connection connection) {
        if (connection == null) {
            throw new IllegalArgumentException("Attempt to add null connection to neuron!");
        }
        if (connection.getToNeuron() != this) {
            throw new IllegalArgumentException("Cannot add input connection - bad toNeuron specified!");
        }
        if (this.hasInputConnectionFrom(connection.getFromNeuron())) {
            return;
        }
        this.inputConnections.add(connection);
        Neuron fromNeuron = connection.getFromNeuron();
        fromNeuron.addOutputConnection(connection);
    }

    public void addInputConnection(Neuron fromNeuron) {
        Connection connection = new Connection(fromNeuron, this);
        this.addInputConnection(connection);
    }

    public void addInputConnection(Neuron fromNeuron, double weightVal) {
        Connection connection = new Connection(fromNeuron, this, weightVal);
        this.addInputConnection(connection);
    }

    protected void addOutputConnection(Connection connection) {
        if (connection == null) {
            throw new IllegalArgumentException("Attempt to add null connection to neuron!");
        }
        if (connection.getFromNeuron() != this) {
            throw new IllegalArgumentException("Cannot add output connection - bad fromNeuron specified!");
        }
        if (this.hasOutputConnectionTo(connection.getToNeuron())) {
            return;
        }
        this.outConnections.add(connection);
    }

    public final List<Connection> getInputConnections() {
        return Collections.unmodifiableList(this.inputConnections);
    }

    public final List<Connection> getOutConnections() {
        return Collections.unmodifiableList(this.outConnections);
    }

    protected void removeInputConnection(Connection conn) {
        this.inputConnections.remove(conn);
    }

    protected void removeOutputConnection(Connection conn) {
        this.outConnections.remove(conn);
    }

    public void removeInputConnectionFrom(Neuron fromNeuron) {
        for (Connection c : this.inputConnections) {
            if (c.getFromNeuron() != fromNeuron) continue;
            fromNeuron.removeOutputConnection(c);
            this.removeInputConnection(c);
            break;
        }
    }

    public void removeOutputConnectionTo(Neuron toNeuron) {
        for (Connection c : this.outConnections) {
            if (c.getToNeuron() != toNeuron) continue;
            toNeuron.removeInputConnection(c);
            this.removeOutputConnection(c);
            break;
        }
    }

    public void removeAllInputConnections() {
        this.inputConnections.clear();
    }

    public void removeAllOutputConnections() {
        this.outConnections.clear();
    }

    public void removeAllConnections() {
        this.removeAllInputConnections();
        this.removeAllOutputConnections();
    }

    public Connection getConnectionFrom(Neuron fromNeuron) {
        for (Connection connection : this.inputConnections) {
            if (connection.getFromNeuron() != fromNeuron) continue;
            return connection;
        }
        return null;
    }

    public void setInputFunction(InputFunction inputFunction) {
        this.inputFunction = inputFunction;
    }

    public void setTransferFunction(TransferFunction transferFunction) {
        this.transferFunction = transferFunction;
    }

    public InputFunction getInputFunction() {
        return this.inputFunction;
    }

    public TransferFunction getTransferFunction() {
        return this.transferFunction;
    }

    public void setParentLayer(Layer parent) {
        this.parentLayer = parent;
    }

    public Layer getParentLayer() {
        return this.parentLayer;
    }

    public Weight[] getWeights() {
        Weight[] weights = new Weight[this.inputConnections.size()];
        for (int i = 0; i < this.inputConnections.size(); ++i) {
            weights[i] = this.inputConnections.get(i).getWeight();
        }
        return weights;
    }

    public double getDelta() {
        return this.delta;
    }

    public void setDelta(double delta) {
        this.delta = delta;
    }

    public double getError() {
        return this.delta;
    }

    public void setError(double error) {
        this.delta = this.delta;
    }

    public void setOutput(double output) {
        this.output = output;
    }

    public void initializeWeights(double value) {
        for (Connection connection : this.inputConnections) {
            connection.getWeight().setValue(value);
        }
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new UnsupportedOperationException("Not yer implemented");
    }
}

