/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.contrib.samples.timeseries;

import java.util.Arrays;
import org.neuroph.core.NeuralNetwork;
import org.neuroph.core.data.DataSet;
import org.neuroph.core.data.DataSetRow;
import org.neuroph.core.events.LearningEvent;
import org.neuroph.core.events.LearningEventListener;
import org.neuroph.core.learning.SupervisedLearning;
import org.neuroph.nnet.MultiLayerPerceptron;
import org.neuroph.nnet.learning.MomentumBackpropagation;
import org.neuroph.util.TransferFunctionType;

public class TestTimeSeries
implements LearningEventListener {
    NeuralNetwork<?> neuralNet;
    DataSet trainingSet;

    public static void main(String[] args) {
        TestTimeSeries tts = new TestTimeSeries();
        tts.train();
        tts.testNeuralNetwork();
    }

    public void train() {
        String inputFileName = "C:\\timeseries\\BSW15";
        this.neuralNet = new MultiLayerPerceptron(TransferFunctionType.TANH, 5, 10, 1);
        MomentumBackpropagation learningRule = (MomentumBackpropagation)this.neuralNet.getLearningRule();
        learningRule.setLearningRate(0.2);
        learningRule.setMomentum(0.5);
        learningRule.addListener(this);
        this.trainingSet = DataSet.createFromFile(inputFileName, 5, 1, "\t", false);
        this.neuralNet.learn(this.trainingSet);
        System.out.println("Done training.");
    }

    public void testNeuralNetwork() {
        System.out.println("Testing network...");
        for (DataSetRow trainingElement : this.trainingSet.getRows()) {
            this.neuralNet.setInput(trainingElement.getInput());
            this.neuralNet.calculate();
            double[] networkOutput = this.neuralNet.getOutput();
            System.out.print("Input: " + Arrays.toString(trainingElement.getInput()));
            System.out.println(" Output: " + Arrays.toString(networkOutput));
        }
    }

    @Override
    public void handleLearningEvent(LearningEvent event) {
        SupervisedLearning rule = (SupervisedLearning)event.getSource();
        System.out.println("Training, Network Epoch " + rule.getCurrentIteration() + ", Error:" + rule.getTotalNetworkError());
    }
}

