/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.contrib.samples.timeseries;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import org.neuroph.contrib.samples.timeseries.GenerateSineWave;

public class GenerateSet {
    private String filename;
    private boolean simple;
    private int sampleEvery;
    private int memorySize;

    public GenerateSet(String filename, boolean simple, int sampleEvery, int memory) {
        this.filename = filename;
        this.simple = simple;
        this.sampleEvery = sampleEvery;
        this.memorySize = memory;
    }

    public void doIt() throws IOException {
        if (this.simple) {
            this.doItSimple();
        } else {
            this.doItSupposition();
        }
    }

    private void doItSimple() throws IOException {
        double[] buffer = new double[this.memorySize + 1];
        int bufferSize = buffer.length;
        int bufferFull = buffer.length;
        GenerateSineWave gsw = new GenerateSineWave(1.0, 1.0);
        BufferedWriter out = new BufferedWriter(new FileWriter(this.filename));
        for (int samples = 0; samples < 1000; ++samples) {
            int i;
            for (int j = 0; j < this.sampleEvery; ++j) {
                gsw.getNextSample();
            }
            for (i = 1; i < bufferSize; ++i) {
                buffer[i - 1] = buffer[i];
            }
            buffer[bufferSize - 1] = gsw.getNextSample();
            if (--bufferFull > 0) continue;
            for (i = 0; i < bufferSize; ++i) {
                out.write(buffer[i] + "\t");
            }
            out.write("\n");
        }
        out.flush();
        out.close();
    }

    private void doItSupposition() throws IOException {
        BufferedWriter out = new BufferedWriter(new FileWriter(this.filename));
        double[] buffer = new double[this.memorySize + 1];
        int bufferSize = buffer.length;
        int bufferFull = buffer.length;
        GenerateSineWave gsw1 = new GenerateSineWave(1.0, 0.5);
        GenerateSineWave gsw2 = new GenerateSineWave(4.0, 0.5);
        for (int samples = 0; samples < 1000; ++samples) {
            int i;
            for (int j = 0; j < this.sampleEvery; ++j) {
                gsw1.getNextSample();
                gsw2.getNextSample();
            }
            for (i = 1; i < bufferSize; ++i) {
                buffer[i - 1] = buffer[i];
            }
            buffer[bufferSize - 1] = gsw1.getNextSample() + gsw2.getNextSample();
            if (--bufferFull > 0) continue;
            for (i = 0; i < bufferSize; ++i) {
                out.write(buffer[i] + "\t");
            }
            out.write("\n");
        }
        out.flush();
        out.close();
    }
}

