/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.contrib.samples.stockmarket;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class StockFileReader {
    private int maxCounter;
    private String[] valuesRow;

    public StockFileReader() {
        this.setMaxCounter(100);
    }

    public StockFileReader(int maxCounter) {
        this.setMaxCounter(maxCounter);
    }

    public String[] getValuesRow() {
        return this.valuesRow;
    }

    public void setValuesRow(String[] valuesRow) {
        this.valuesRow = valuesRow;
    }

    public int getMaxCounter() {
        return this.maxCounter;
    }

    public void setMaxCounter(int maxCounter) {
        this.maxCounter = maxCounter;
    }

    public void read(String fileName) {
        HashMap<String, String> hm = new HashMap<String, String>();
        File file = new File(fileName);
        System.out.println("file = " + fileName + ". It will be filtered the values for the moment of the market opened");
        int counter = 0;
        try {
            String s;
            FileInputStream fis = new FileInputStream(file);
            BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
            while ((s = dis.readLine()) != null) {
                String[] s1 = s.split(",");
                String s00 = s1[0].replace('\"', ' ').trim();
                String s01 = s1[1].replace('\"', ' ').trim();
                hm.put(s00, s.replace('\"', ' ').trim());
                ++counter;
            }
            fis.close();
        }
        catch (IOException ioe) {
            System.out.println("Oops- an IOException happened.");
            ioe.printStackTrace();
            System.exit(1);
        }
        System.out.println("full number of values = " + counter);
        Set s = hm.keySet();
        Iterator i = s.iterator();
        this.valuesRow = new String[this.getMaxCounter()];
        int n = 0;
        while (i.hasNext()) {
            String key = (String)i.next();
            String value = (String)hm.get(key);
            if (counter - ++n >= this.getMaxCounter()) continue;
            this.valuesRow[counter - n] = value;
            System.out.println(counter + " " + n + " " + this.valuesRow[counter - n] + " " + (counter - n));
        }
        System.out.println("valuesRow.length=" + this.valuesRow.length);
    }
}

