/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.contrib.bpbench;

import org.neuroph.contrib.bpbench.AbstractTraining;
import org.neuroph.contrib.bpbench.TrainingResult;
import org.neuroph.contrib.bpbench.TrainingSettings;
import org.neuroph.core.NeuralNetwork;
import org.neuroph.core.data.DataSet;
import org.neuroph.core.learning.LearningRule;
import org.neuroph.nnet.learning.MomentumBackpropagation;

public class MomentumTraining
extends AbstractTraining {
    public MomentumTraining(NeuralNetwork neuralNet, DataSet dataset, TrainingSettings settings) {
        super(neuralNet, dataset, settings);
    }

    public MomentumTraining(DataSet dataset, TrainingSettings settings) {
        super(dataset, settings);
    }

    @Override
    public void testNeuralNet() {
        MomentumBackpropagation mbp = (MomentumBackpropagation)this.setParameters();
        this.getNeuralNet().setLearningRule(mbp);
        this.getNeuralNet().learn(this.getDataset());
        this.getStats().addData(new TrainingResult(mbp.getCurrentIteration(), mbp.getTotalNetworkError(), this.createMatrix()));
        this.getStats().calculateParameters();
    }

    @Override
    public LearningRule setParameters() {
        MomentumBackpropagation mbp = new MomentumBackpropagation();
        mbp.setBatchMode(this.getSettings().isBatchMode());
        mbp.setLearningRate(this.getSettings().getLearningRate());
        mbp.setMaxError(this.getSettings().getMaxError());
        mbp.setMaxIterations(this.getSettings().getMaxIterations());
        mbp.setMomentum(this.getSettings().getMomentum());
        return mbp;
    }
}

