/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.contrib.bpbench;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.neuroph.contrib.bpbench.AbstractTraining;
import org.neuroph.contrib.bpbench.BackpropagationTraining;
import org.neuroph.contrib.bpbench.ExportUtil;
import org.neuroph.contrib.bpbench.MomentumTraining;
import org.neuroph.contrib.bpbench.QuickpropagationTraining;
import org.neuroph.contrib.bpbench.ResilientTraining;
import org.neuroph.contrib.bpbench.TrainingSettings;
import org.neuroph.core.data.DataSet;
import org.neuroph.nnet.MultiLayerPerceptron;

public class BackPropBenchmarks {
    private List<AbstractTraining> listOfTrainings;
    private int noOfRepetitions = 1;

    public BackPropBenchmarks() {
        this.listOfTrainings = new ArrayList<AbstractTraining>();
    }

    public BackPropBenchmarks(List<AbstractTraining> listOfTasks) {
        this.listOfTrainings = listOfTasks;
    }

    public void addTraining(AbstractTraining training) {
        this.listOfTrainings.add(training);
    }

    public void run() {
        for (AbstractTraining training : this.listOfTrainings) {
            for (int i = 0; i < this.noOfRepetitions; ++i) {
                training.testNeuralNet();
                training.getNeuralNet().randomizeWeights();
            }
            System.out.println(training.getStats());
        }
    }

    public int getNoOfRepetitions() {
        return this.noOfRepetitions;
    }

    public void setNoOfRepetitions(int noOfRepetitions) {
        this.noOfRepetitions = noOfRepetitions;
    }

    public void startBenchmark(List<Class<? extends AbstractTraining>> trainingTypeCollection, List<TrainingSettings> settingsCollection, DataSet trainingSet, MultiLayerPerceptron mlp) {
        for (TrainingSettings trainingSettings : settingsCollection) {
            for (Class<? extends AbstractTraining> trainingType : trainingTypeCollection) {
                AbstractTraining training = null;
                if (trainingType.equals(BackpropagationTraining.class)) {
                    training = new BackpropagationTraining(mlp, trainingSet, trainingSettings);
                } else if (trainingType.equals(MomentumTraining.class)) {
                    training = new MomentumTraining(mlp, trainingSet, trainingSettings);
                } else if (trainingType.equals(QuickpropagationTraining.class)) {
                    training = new QuickpropagationTraining(mlp, trainingSet, trainingSettings);
                } else if (trainingType.equals(ResilientTraining.class)) {
                    training = new ResilientTraining(mlp, trainingSet, trainingSettings);
                }
                this.addTraining(training);
            }
        }
        this.run();
    }

    public void startBenchmark(List<Class<? extends AbstractTraining>> trainingTypeCollection, List<TrainingSettings> settingsCollection, DataSet trainingSet) {
        for (TrainingSettings trainingSettings : settingsCollection) {
            for (Class<? extends AbstractTraining> trainingType : trainingTypeCollection) {
                AbstractTraining training = null;
                if (trainingType.equals(BackpropagationTraining.class)) {
                    training = new BackpropagationTraining(trainingSet, trainingSettings);
                } else if (trainingType.equals(MomentumTraining.class)) {
                    training = new MomentumTraining(trainingSet, trainingSettings);
                } else if (trainingType.equals(QuickpropagationTraining.class)) {
                    training = new QuickpropagationTraining(trainingSet, trainingSettings);
                } else if (trainingType.equals(ResilientTraining.class)) {
                    training = new ResilientTraining(trainingSet, trainingSettings);
                }
                this.addTraining(training);
            }
        }
        this.run();
    }

    public void saveResults(String filePath) {
        try {
            ExportUtil.exportToCSV(filePath, this.listOfTrainings);
        }
        catch (IOException ex) {
            System.out.println(ex.getMessage());
        }
    }
}

