/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.contrib.autotrain;

import java.util.List;
import org.neuroph.contrib.autotrain.TrainingResult;

public class TrainingStatistics {
    double min;
    double max;
    double mean;
    double std;

    public TrainingStatistics(double min, double max, double mean, double std) {
        this.min = min;
        this.max = max;
        this.mean = mean;
        this.std = std;
    }

    public TrainingStatistics() {
    }

    public double getMin() {
        return this.min;
    }

    public void setMin(double min) {
        this.min = min;
    }

    public double getMax() {
        return this.max;
    }

    public void setMax(double max) {
        this.max = max;
    }

    public double getMean() {
        return this.mean;
    }

    public void setMean(double mean) {
        this.mean = mean;
    }

    public double getStd() {
        return this.std;
    }

    public void setStd(double std) {
        this.std = std;
    }

    public static TrainingStatistics calculateIterations(List<TrainingResult> list) {
        int minIt = list.get(0).getIterations();
        int maxIt = list.get(0).getIterations();
        int sumIt = 0;
        double[] v = new double[list.size()];
        int i = 0;
        for (TrainingResult tr : list) {
            if (tr.getIterations() < minIt) {
                minIt = tr.getIterations();
            }
            if (tr.getIterations() > maxIt) {
                maxIt = tr.getIterations();
            }
            sumIt += tr.getIterations();
            v[i++] = tr.getIterations();
        }
        double meanIt = sumIt / list.size();
        double stdIt = TrainingStatistics.std(meanIt, v);
        return new TrainingStatistics(minIt, maxIt, meanIt, stdIt);
    }

    public static TrainingStatistics calculateMSE(List<TrainingResult> list) {
        double minIt = list.get(0).getTotalError();
        double maxIt = list.get(0).getTotalError();
        double pom = 0.0;
        double[] vrednosti = new double[list.size()];
        int i = 0;
        for (TrainingResult tr : list) {
            if (tr.getTotalError() < minIt) {
                minIt = tr.getTotalError();
            }
            if (tr.getTotalError() > maxIt) {
                maxIt = tr.getTotalError();
            }
            pom += tr.getTotalError();
            vrednosti[i++] = tr.getTotalError();
        }
        double meanIt = pom / (double)list.size();
        double stdIt = TrainingStatistics.std(meanIt, vrednosti);
        return new TrainingStatistics(minIt, maxIt, meanIt, stdIt);
    }

    public static TrainingStatistics calculateStatistic(double[] array) {
        double min = array[0];
        double max = array[0];
        double mean = 0.0;
        double std = 0.0;
        double sum = 0.0;
        for (int i = 0; i < array.length; ++i) {
            if (array[i] < min) {
                min = array[i];
            }
            if (array[i] > max) {
                max = array[i];
            }
            sum += array[i];
        }
        mean = sum / (double)array.length;
        std = TrainingStatistics.std(mean, array);
        return new TrainingStatistics(min, max, mean, std);
    }

    private static TrainingStatistics calculateStatistic(int[] array) {
        int min = array[0];
        int max = array[0];
        double mean = 0.0;
        double std = 0.0;
        int sum = 0;
        for (int i = 0; i < array.length; ++i) {
            if (array[i] < min) {
                min = array[i];
            }
            if (array[i] > max) {
                max = array[i];
            }
            sum += array[i];
        }
        mean = sum / array.length;
        std = TrainingStatistics.std(mean, array);
        return new TrainingStatistics(min, max, mean, std);
    }

    public String toString() {
        return "Statistic{min=" + this.min + ", max=" + this.max + ", mean=" + this.mean + ", std=" + this.std + '}';
    }

    private static double std(double mean, int[] sum) {
        double std = 0.0;
        int[] nArray = sum;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            double temp = nArray[i];
            std += Math.pow(temp - mean, 2.0);
        }
        return Math.sqrt(std / (double)sum.length);
    }

    private static double std(double mean, double[] sum) {
        double std = 0.0;
        for (double temp : sum) {
            std += Math.pow(temp - mean, 2.0);
        }
        return Math.sqrt(std / (double)sum.length);
    }
}

