/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.adapters.weka;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.neuroph.adapters.weka.WekaDataSetConverter;
import org.neuroph.adapters.weka.WekaNeurophClassifier;
import org.neuroph.core.data.DataSet;
import org.neuroph.core.data.DataSetRow;
import org.neuroph.nnet.MultiLayerPerceptron;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.converters.ConverterUtils;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Normalize;

public class WekaNeurophSample {
    public static void main(String[] args) throws Exception {
        ConverterUtils.DataSource dataSource = new ConverterUtils.DataSource("datasets/iris.arff");
        Instances wekaDataset = dataSource.getDataSet();
        wekaDataset.setClassIndex(4);
        Normalize filter = new Normalize();
        filter.setInputFormat(wekaDataset);
        wekaDataset = Filter.useFilter((Instances)wekaDataset, (Filter)filter);
        DataSet neurophDataset = WekaDataSetConverter.convertWekaToNeurophDataset(wekaDataset, 4, 3);
        Instances testWekaDataset = WekaDataSetConverter.convertNeurophToWekaDataset(neurophDataset);
        System.out.println("Weka data set from file");
        WekaNeurophSample.printDataSet(wekaDataset);
        System.out.println("Neuroph data set converted from Weka data set");
        WekaNeurophSample.printDataSet(neurophDataset);
        System.out.println("Weka data set reconverted from Neuroph data set");
        WekaNeurophSample.printDataSet(testWekaDataset);
        System.out.println("Testing WekaNeurophClassifier");
        WekaNeurophSample.testNeurophWekaClassifier(wekaDataset);
    }

    public static void printDataSet(DataSet neurophDataset) {
        System.out.println("Neuroph dataset");
        for (DataSetRow row : neurophDataset) {
            System.out.println("inputs");
            System.out.println(Arrays.toString(row.getInput()));
            if (row.getDesiredOutput().length <= 0) continue;
            System.out.println("outputs");
            System.out.println(Arrays.toString(row.getDesiredOutput()));
            System.out.println(row.getLabel());
        }
    }

    private static void printDataSet(Instances wekaDataset) {
        System.out.println("Weka dataset");
        Enumeration en = wekaDataset.enumerateInstances();
        while (en.hasMoreElements()) {
            Instance instance = (Instance)en.nextElement();
            double[] values = instance.toDoubleArray();
            System.out.println(Arrays.toString(values));
            System.out.println(instance.stringValue(instance.classIndex()));
        }
    }

    private static void testNeurophWekaClassifier(Instances wekaDataset) {
        try {
            MultiLayerPerceptron neuralNet = new MultiLayerPerceptron(4, 16, 3);
            neuralNet.getOutputNeurons().get(0).setLabel("Setosa");
            neuralNet.getOutputNeurons().get(1).setLabel("Versicolor");
            neuralNet.getOutputNeurons().get(2).setLabel("Virginica");
            WekaNeurophClassifier neurophWekaClassifier = new WekaNeurophClassifier(neuralNet);
            wekaDataset.setClassIndex(4);
            neurophWekaClassifier.buildClassifier(wekaDataset);
            double[] item = new double[]{0.22222222222222213, 0.6249999999999999, 0.06779661016949151, 0.04166666666666667, 0.0};
            DenseInstance instance = new DenseInstance(1.0, item);
            System.out.println("NeurophWekaClassifier - classifyInstance for {5.1, 3.5, 1.4, 0.2}");
            System.out.println("Class idx: " + neurophWekaClassifier.classifyInstance((Instance)instance));
            System.out.println("NeurophWekaClassifier - distributionForInstance for {5.1, 3.5, 1.4, 0.2}");
            double[] dist = neurophWekaClassifier.distributionForInstance((Instance)instance);
            for (int i = 0; i < dist.length; ++i) {
                System.out.println("Class " + i + ": " + dist[i]);
            }
        }
        catch (Exception ex) {
            Logger.getLogger(WekaNeurophSample.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

