/*
 * Decompiled with CFR 0.152.
 */
package functionplotter.xml;

import functionplotter.exception.AppException;
import functionplotter.xml.XmlParseException;
import functionplotter.xml.XmlUtilities;
import functionplotter.xml.XmlWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Comment {
    private String text;

    public Comment() {
        this.text = new String();
    }

    public Comment(String string) {
        this.setText(string);
    }

    public Comment(Element element) throws XmlParseException {
        String string = XmlUtilities.getElementPath(element);
        String string2 = "indent";
        String string3 = string + "." + string2;
        String string4 = XmlUtilities.getAttribute(element, string2);
        int n = 0;
        if (string4 != null) {
            try {
                n = Integer.parseInt(string4);
                if (n < 0) {
                    throw new XmlParseException((AppException.Id)ErrorId.ATTRIBUTE_OUT_OF_BOUNDS, string3, string4);
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new XmlParseException((AppException.Id)ErrorId.INVALID_ATTRIBUTE, string3, string4);
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() != 3) continue;
            stringBuilder.append(nodeList.item(i).getNodeValue());
        }
        String string5 = stringBuilder.toString();
        stringBuilder.setLength(0);
        for (int i = 0; i < string5.length(); ++i) {
            int n2 = i;
            if ((i = string5.indexOf(10, i)) < 0) {
                i = string5.length();
            }
            int n3 = Math.min(n2 + n, i);
            while (n2 < n3 && string5.charAt(n2) == ' ') {
                ++n2;
            }
            if (i > n2) {
                stringBuilder.append(string5.substring(n2, i));
            }
            stringBuilder.append('\n');
        }
        this.text = stringBuilder.toString().trim();
    }

    public static String getElementName() {
        return "comment";
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string.trim();
    }

    public boolean isEmpty() {
        return this.text.isEmpty();
    }

    public void write(XmlWriter xmlWriter, int n, int n2) throws IOException {
        ArrayList<XmlWriter.Attribute> arrayList = new ArrayList<XmlWriter.Attribute>();
        arrayList.add(new XmlWriter.Attribute("indent", n2));
        xmlWriter.writeElementStart("comment", arrayList, n, true, true);
        for (int i = 0; i < this.text.length(); ++i) {
            int n3 = i;
            if ((i = this.text.indexOf(10, n3)) < 0) {
                i = this.text.length();
            }
            if (n3 < i) {
                xmlWriter.writeSpaces(n2);
                xmlWriter.writeEscaped(this.text.substring(n3, i));
            }
            xmlWriter.writeLineSeparator();
        }
        xmlWriter.writeElementEnd("comment", n);
    }

    private static enum ErrorId implements AppException.Id
    {
        NO_ATTRIBUTE("The required attribute is missing."),
        INVALID_ATTRIBUTE("The attribute is invalid."),
        ATTRIBUTE_OUT_OF_BOUNDS("The attribute value is out of bounds.");

        private String message;

        private ErrorId(String string2) {
            this.message = string2;
        }

        @Override
        public String getMessage() {
            return this.message;
        }
    }

    private static interface AttrName {
        public static final String INDENT = "indent";
    }

    private static interface ElementName {
        public static final String COMMENT = "comment";
    }
}

