/*
 * Decompiled with CFR 0.152.
 */
package functionplotter.textfield;

import functionplotter.util.DataImporter;
import functionplotter.util.PropertyString;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;

public class PathnameField
extends JTextField {
    protected static final String USER_HOME_PREFIX = "~";
    private TransferHandler oldTransferHandler = this.getTransferHandler();
    private List<ImportListener> importListeners;
    private ImportEvent importEvent;

    public PathnameField(int n) {
        super(n);
        this.setTransferHandler(new FileTransferHandler());
    }

    public PathnameField(String string, int n) {
        this(n);
        this.setText(string);
    }

    public PathnameField(File file, int n) {
        this(n);
        if (file != null) {
            this.setFile(file);
        }
    }

    protected static String getPathname(File file) {
        String string = null;
        if (file != null) {
            try {
                try {
                    string = file.getCanonicalPath();
                }
                catch (Exception exception) {
                    PathnameField.writeError(exception);
                    string = file.getAbsolutePath();
                }
            }
            catch (SecurityException securityException) {
                PathnameField.writeError(securityException);
                string = file.getPath();
            }
        }
        return string;
    }

    protected static void writeError(Exception exception) {
        System.err.println(exception);
        StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
        if (stackTraceElementArray.length > 0) {
            System.err.println(stackTraceElementArray[0]);
        }
    }

    public String getPathname() {
        return PropertyString.parsePathname(this.getText());
    }

    public File getFile() {
        return new File(this.getPathname());
    }

    public File getCanonicalFile() {
        File file = this.getFile();
        try {
            try {
                file = file.getCanonicalFile();
            }
            catch (Exception exception) {
                PathnameField.writeError(exception);
                file = file.getAbsoluteFile();
            }
        }
        catch (SecurityException securityException) {
            PathnameField.writeError(securityException);
        }
        return file;
    }

    public boolean isEmpty() {
        return this.getText().isEmpty();
    }

    public void setFile(File file) {
        this.setFile(file, false);
    }

    public void setFile(File file, boolean bl) {
        String string = PathnameField.getPathname(file);
        if (bl && string != null) {
            try {
                String string2 = System.getProperty("user.home");
                if (string2 != null && string.startsWith(string2)) {
                    string = USER_HOME_PREFIX + string.substring(string2.length());
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            string = string.replace(File.separatorChar, '/');
        }
        this.setText(string);
    }

    public void addImportListener(ImportListener importListener) {
        if (this.importListeners == null) {
            this.importListeners = new ArrayList<ImportListener>();
        }
        this.importListeners.add(importListener);
    }

    public void removeImportListener(ImportListener importListener) {
        if (this.importListeners != null) {
            this.importListeners.remove(importListener);
        }
    }

    protected void fireDataImported() {
        if (this.importListeners != null) {
            if (this.importEvent == null) {
                this.importEvent = new ImportEvent(this);
            }
            for (int i = this.importListeners.size() - 1; i >= 0; --i) {
                this.importListeners.get(i).dataImported(this.importEvent);
            }
        }
    }

    private class FileTransferHandler
    extends TransferHandler
    implements Runnable {
        private Position p0;
        private Position p1;

        private FileTransferHandler() {
        }

        @Override
        public void run() {
            PathnameField.this.fireDataImported();
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport transferSupport) {
            return PathnameField.this.isEnabled() && (DataImporter.isFileList(transferSupport.getDataFlavors()) || PathnameField.this.oldTransferHandler != null && PathnameField.this.oldTransferHandler.canImport(transferSupport));
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport transferSupport) {
            if (DataImporter.isFileList(transferSupport.getDataFlavors())) {
                try {
                    File[] fileArray = DataImporter.getFiles(transferSupport.getTransferable());
                    if (fileArray != null) {
                        PathnameField.this.setFile(fileArray[0]);
                        SwingUtilities.invokeLater(this);
                        return true;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return false;
                }
            }
            return PathnameField.this.oldTransferHandler == null ? false : PathnameField.this.oldTransferHandler.importData(transferSupport);
        }

        @Override
        public int getSourceActions(JComponent jComponent) {
            return 3;
        }

        @Override
        protected Transferable createTransferable(JComponent jComponent) {
            int n;
            StringSelection stringSelection = null;
            int n2 = PathnameField.this.getSelectionStart();
            if (n2 < (n = PathnameField.this.getSelectionEnd())) {
                try {
                    Document document = PathnameField.this.getDocument();
                    this.p0 = document.createPosition(n2);
                    this.p1 = document.createPosition(n);
                    stringSelection = new StringSelection(PathnameField.this.getSelectedText());
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
            return stringSelection;
        }

        @Override
        protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
            if (n == 2 && this.p0 != null && this.p1 != null && this.p0.getOffset() != this.p1.getOffset()) {
                try {
                    PathnameField.this.getDocument().remove(this.p0.getOffset(), this.p1.getOffset() - this.p0.getOffset());
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
        }
    }

    public static class ImportEvent
    extends EventObject {
        private ImportEvent(PathnameField pathnameField) {
            super(pathnameField);
        }

        @Override
        public PathnameField getSource() {
            return (PathnameField)this.source;
        }
    }

    public static interface ImportListener {
        public void dataImported(ImportEvent var1);
    }
}

