/*
 * Decompiled with CFR 0.152.
 */
package functionplotter.gui;

import functionplotter.util.StringKeyed;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.util.Map;

public class TextRendering {
    private static final String DESKTOP_HINTS_PROPERTY_KEY = "awt.font.desktophints";
    private static Antialiasing antialiasing = Antialiasing.DEFAULT;
    private static FractionalMetrics fractionalMetrics = FractionalMetrics.DEFAULT;

    private TextRendering() {
    }

    public static Antialiasing getAntialiasing() {
        return antialiasing;
    }

    public static FractionalMetrics getFractionalMetrics() {
        return fractionalMetrics;
    }

    public static void setAntialiasing(Antialiasing antialiasing) {
        if (antialiasing != null) {
            TextRendering.antialiasing = antialiasing;
        }
    }

    public static void setFractionalMetrics(FractionalMetrics fractionalMetrics) {
        if (fractionalMetrics != null) {
            TextRendering.fractionalMetrics = fractionalMetrics;
        }
    }

    public static void setHints(Graphics2D graphics2D) {
        graphics2D.setRenderingHint(Antialiasing.getHintKey(), antialiasing.getHintValue());
        graphics2D.setRenderingHint(FractionalMetrics.getHintKey(), fractionalMetrics.getHintValue());
    }

    public static Object getDesktopHint(Object object) {
        Map map = (Map)Toolkit.getDefaultToolkit().getDesktopProperty(DESKTOP_HINTS_PROPERTY_KEY);
        return map == null ? null : map.get(object);
    }

    public static enum FractionalMetrics implements StringKeyed
    {
        DEFAULT("default", "Default", RenderingHints.VALUE_FRACTIONALMETRICS_DEFAULT),
        OFF("off", "Off", RenderingHints.VALUE_FRACTIONALMETRICS_OFF),
        ON("on", "On", RenderingHints.VALUE_FRACTIONALMETRICS_ON);

        private String key;
        private String text;
        private Object hintValue;

        private FractionalMetrics(String string2, String string3, Object object) {
            this.key = string2;
            this.text = string3;
            this.hintValue = object;
        }

        public static RenderingHints.Key getHintKey() {
            return RenderingHints.KEY_FRACTIONALMETRICS;
        }

        public static FractionalMetrics get(String string) {
            for (FractionalMetrics fractionalMetrics : FractionalMetrics.values()) {
                if (!fractionalMetrics.key.equals(string)) continue;
                return fractionalMetrics;
            }
            return null;
        }

        public static FractionalMetrics getForHintValue(Object object) {
            for (FractionalMetrics fractionalMetrics : FractionalMetrics.values()) {
                if (!fractionalMetrics.hintValue.equals(object)) continue;
                return fractionalMetrics;
            }
            return null;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        public String toString() {
            return this.text;
        }

        public Object getHintValue() {
            Object object;
            if (this == DEFAULT && (object = TextRendering.getDesktopHint(RenderingHints.KEY_FRACTIONALMETRICS)) != null) {
                return object;
            }
            return this.hintValue;
        }
    }

    public static enum Antialiasing implements StringKeyed
    {
        DEFAULT("default", "Default", RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT),
        NONE("none", "None", RenderingHints.VALUE_TEXT_ANTIALIAS_OFF),
        STANDARD("standard", "Standard", RenderingHints.VALUE_TEXT_ANTIALIAS_ON),
        SUBPIXEL_H_RGB("subpixelHRgb", "Subpixel, horizontal RGB", RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB),
        SUBPIXEL_H_BGR("subpixelHBgr", "Subpixel, horizontal BGR", RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HBGR),
        SUBPIXEL_V_RGB("subpixelVRgb", "Subpixel, vertical RGB", RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_VRGB),
        SUBPIXEL_V_BGR("subpixelVBgr", "Subpixel, vertical BGR", RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_VBGR);

        private String key;
        private String text;
        private Object hintValue;

        private Antialiasing(String string2, String string3, Object object) {
            this.key = string2;
            this.text = string3;
            this.hintValue = object;
        }

        public static RenderingHints.Key getHintKey() {
            return RenderingHints.KEY_TEXT_ANTIALIASING;
        }

        public static Antialiasing get(String string) {
            for (Antialiasing antialiasing : Antialiasing.values()) {
                if (!antialiasing.key.equals(string)) continue;
                return antialiasing;
            }
            return null;
        }

        public static Antialiasing getForHintValue(Object object) {
            for (Antialiasing antialiasing : Antialiasing.values()) {
                if (!antialiasing.hintValue.equals(object)) continue;
                return antialiasing;
            }
            return null;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        public String toString() {
            return this.text;
        }

        public Object getHintValue() {
            Object object;
            if (this == DEFAULT && (object = TextRendering.getDesktopHint(RenderingHints.KEY_TEXT_ANTIALIASING)) != null) {
                return object;
            }
            return this.hintValue;
        }
    }
}

