/*
 * Decompiled with CFR 0.152.
 */
package functionplotter.gui;

import functionplotter.gui.Colours;
import functionplotter.gui.GuiUtilities;
import functionplotter.gui.TextRendering;
import functionplotter.util.KeyAction;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SingleSelectionList<E>
extends JComponent
implements ActionListener,
FocusListener,
MouseListener,
MouseMotionListener,
MouseWheelListener,
Scrollable {
    public static final int DEFAULT_HORIZONTAL_MARGIN = 4;
    public static final int DEFAULT_VERTICAL_MARGIN = 1;
    private static final int UNIT_INCREMENT_ROWS = 1;
    private static final int BLOCK_INCREMENT_ROWS = 8;
    private static final int DRAG_BAR_HEIGHT = 6;
    private static final KeyAction.CommandMap[] KEY_COMMANDS = new KeyAction.CommandMap[]{new KeyAction.CommandMap(KeyStroke.getKeyStroke(10, 0), "editElement"), new KeyAction.CommandMap(KeyStroke.getKeyStroke(127, 0), "deleteElement"), new KeyAction.CommandMap(KeyStroke.getKeyStroke(127, 64), "deleteExElement"), new KeyAction.CommandMap(KeyStroke.getKeyStroke(38, 128), "moveElementUp"), new KeyAction.CommandMap(KeyStroke.getKeyStroke(40, 128), "moveElementDown"), new KeyAction.CommandMap(KeyStroke.getKeyStroke(38, 0), "selectUpUnit"), new KeyAction.CommandMap(KeyStroke.getKeyStroke(40, 0), "selectDownUnit"), new KeyAction.CommandMap(KeyStroke.getKeyStroke(33, 0), "selectUpBlock"), new KeyAction.CommandMap(KeyStroke.getKeyStroke(34, 0), "selectDownBlock"), new KeyAction.CommandMap(KeyStroke.getKeyStroke(36, 0), "selectUpMax"), new KeyAction.CommandMap(KeyStroke.getKeyStroke(35, 0), "selectDownMax")};
    private int columns;
    private int viewableRows;
    private int columnWidth;
    private int rowHeight;
    private int horizontalMargin;
    private int extraWidth;
    private int selectedIndex;
    private boolean dragEnabled;
    private int dragIndex;
    private int dragStartIndex;
    private int dragEndIndex;
    private Integer dragY;
    private JViewport viewport;
    private Model<E> model;
    private List<ActionListener> actionListeners;
    private List<ListSelectionListener> selectionListeners;
    private List<ModelListener> modelListeners;

    public SingleSelectionList(int n, int n2, Font font) {
        this(n, n2, 0, 0, font);
    }

    public SingleSelectionList(int n, int n2, Font font, E[] EArray) {
        this(n, n2, 0, 0, font);
        this.setElements(EArray);
    }

    public SingleSelectionList(int n, int n2, Font font, List<E> list) {
        this(n, n2, 0, 0, font);
        this.setElements(list);
    }

    public SingleSelectionList(int n, int n2, Font font, Model<E> model) {
        this(n, n2, 0, 0, font);
        this.setModel(model);
    }

    public SingleSelectionList(int n, int n2, int n3, int n4, Font font) {
        this.columns = n;
        this.viewableRows = n2;
        FontMetrics fontMetrics = this.getFontMetrics(font);
        this.columnWidth = n3 == 0 ? GuiUtilities.getCharWidth(48, fontMetrics) : n3;
        this.rowHeight = n4 == 0 ? 2 + fontMetrics.getAscent() + fontMetrics.getDescent() : n4;
        this.horizontalMargin = 4;
        this.selectedIndex = -1;
        this.dragEnabled = true;
        this.dragIndex = -1;
        this.dragStartIndex = -1;
        this.dragEndIndex = -1;
        this.model = new DefaultModel();
        this.setFont(font);
        this.setForeground(Colours.List.FOREGROUND.getColour());
        this.setBackground(Colours.List.BACKGROUND.getColour());
        this.setOpaque(true);
        this.setFocusable(true);
        this.setAutoscrolls(true);
        KeyAction.create((JComponent)this, 0, KEY_COMMANDS, (ActionListener)this);
        this.addFocusListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
    }

    public SingleSelectionList(int n, int n2, int n3, int n4, Font font, E[] EArray) {
        this(n, n2, n3, n4, font);
        this.setElements(EArray);
    }

    public SingleSelectionList(int n, int n2, int n3, int n4, Font font, List<E> list) {
        this(n, n2, n3, n4, font);
        this.setElements(list);
    }

    public SingleSelectionList(int n, int n2, int n3, int n4, Font font, Model<E> model) {
        this(n, n2, n3, n4, font);
        this.setModel(model);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("editElement")) {
            this.doEditElement();
        } else if (string.equals("deleteElement")) {
            this.doDeleteElement();
        } else if (string.equals("deleteExElement")) {
            this.doDeleteExElement();
        } else if (string.equals("moveElementUp")) {
            this.doMoveElementUp();
        } else if (string.equals("moveElementDown")) {
            this.doMoveElementDown();
        } else if (string.equals("selectUpUnit")) {
            this.doSelectUpUnit();
        } else if (string.equals("selectDownUnit")) {
            this.doSelectDownUnit();
        } else if (string.equals("selectUpBlock")) {
            this.doSelectUpBlock();
        } else if (string.equals("selectDownBlock")) {
            this.doSelectDownBlock();
        } else if (string.equals("selectUpMax")) {
            this.doSelectUpMax();
        } else if (string.equals("selectDownMax")) {
            this.doSelectDownMax();
        } else if (string.equals("scrollUpUnit")) {
            this.doScrollUpUnit();
        } else if (string.equals("scrollDownUnit")) {
            this.doScrollDownUnit();
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.repaint();
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        int n;
        if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2 && (n = mouseEvent.getY() / this.rowHeight) >= 0 && n < this.getNumElements()) {
            this.doEditElement();
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.requestFocusInWindow();
        int n = mouseEvent.getY() / this.rowHeight;
        if (n >= 0 && n < this.getNumElements()) {
            this.dragStartIndex = n;
            this.setSelectedIndex(n);
        } else {
            this.dragStartIndex = -1;
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent) && this.isDragging()) {
            this.dragEndIndex = this.dragIndex;
            this.setDragIndex(-1);
            if (this.dragEndIndex != this.selectedIndex) {
                this.fireActionPerformed("dragElement");
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            int n;
            boolean bl = this.isDragging();
            if (this.dragEnabled && !bl) {
                n = mouseEvent.getY() / this.rowHeight;
                if (this.dragStartIndex >= 0 && this.dragStartIndex != n) {
                    bl = true;
                }
            }
            if (bl) {
                n = Math.min(Math.max(0, (mouseEvent.getY() + this.rowHeight / 2) / this.rowHeight), this.getNumElements());
                this.scrollRectToVisible(new Rectangle(mouseEvent.getX(), n * this.rowHeight, 1, this.rowHeight));
                if (this.dragIndex != n) {
                    this.setDragIndex(n);
                }
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (this.viewport != null) {
            String string = null;
            int n = mouseWheelEvent.getWheelRotation();
            if (n < 0) {
                n = -n;
                string = "scrollUpUnit";
            } else {
                string = "scrollDownUnit";
            }
            while (--n >= 0) {
                this.actionPerformed(new ActionEvent(this, 1001, string));
            }
        }
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return new Dimension(2 * this.horizontalMargin + this.columns * this.columnWidth + this.extraWidth, this.viewableRows * this.rowHeight);
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        int n3 = 0;
        if (n == 1) {
            int n4 = rectangle.y;
            if (n2 < 0) {
                int n5 = (Math.max(0, n4) + this.rowHeight - 1) / this.rowHeight;
                n3 = n4 - Math.max(0, n5 - 1) * this.rowHeight;
            } else {
                int n6 = Math.max(0, n4) / this.rowHeight;
                int n7 = Math.max(0, this.getHeight() - rectangle.height) / this.rowHeight;
                n3 = Math.min(n6 + 1, n7) * this.rowHeight - n4;
            }
        }
        return n3;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        int n3 = 0;
        if (n == 1) {
            int n4 = rectangle.y;
            if (n2 < 0) {
                int n5 = (Math.max(0, n4) + this.rowHeight - 1) / this.rowHeight;
                n3 = n4 - Math.max(0, n5 - 8) * this.rowHeight;
            } else {
                int n6 = Math.max(0, n4) / this.rowHeight;
                int n7 = Math.max(0, this.getHeight() - rectangle.height) / this.rowHeight;
                n3 = Math.min(n6 + 8, n7) * this.rowHeight - n4;
            }
        }
        return n3;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(2 * this.horizontalMargin + this.columns * this.columnWidth + this.extraWidth, Math.max(this.viewableRows, this.getNumElements()) * this.rowHeight);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        int n;
        Rectangle rectangle = graphics.getClipBounds();
        graphics.setColor(this.getBackground());
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        int n2 = Math.max(0, rectangle.y / this.rowHeight);
        int n3 = Math.max(0, rectangle.y + rectangle.height + this.rowHeight - 1) / this.rowHeight;
        for (n = n2; n < n3; ++n) {
            if (n == this.selectedIndex) {
                graphics.setColor(this.getBackgroundColour(n));
                graphics.fillRect(rectangle.x, n * this.rowHeight, rectangle.width, this.rowHeight);
            }
            if (n >= this.getNumElements()) continue;
            this.drawElement(graphics, n);
        }
        if (this.isDragging()) {
            n = 0;
            int n4 = this.getWidth() - 1;
            int n5 = this.dragIndex * this.rowHeight - 3;
            graphics.setColor(Colours.List.DRAG_BAR.getColour());
            graphics.drawLine(n, n5, n, n5);
            graphics.drawLine(n4, n5, n4, n5);
            graphics.drawLine(n, ++n5, n + 1, n5);
            graphics.drawLine(n4 - 1, n5, n4, n5);
            graphics.drawLine(rectangle.x, ++n5, rectangle.x + rectangle.width - 1, n5);
            graphics.drawLine(rectangle.x, ++n5, rectangle.x + rectangle.width - 1, n5);
            graphics.drawLine(n, ++n5, n + 1, n5);
            graphics.drawLine(n4 - 1, n5, n4, n5);
            graphics.drawLine(n, ++n5, n, n5);
            graphics.drawLine(n4, n5, n4, n5);
        }
    }

    public int getColumns() {
        return this.columns;
    }

    public int getViewableRows() {
        return this.viewableRows;
    }

    public int getColumnWidth() {
        return this.columnWidth;
    }

    public int getRowHeight() {
        return this.rowHeight;
    }

    public int getHorizontalMargin() {
        return this.horizontalMargin;
    }

    public int getExtraWidth() {
        return this.extraWidth;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public boolean isDragging() {
        return this.dragIndex >= 0;
    }

    public int getDragEndIndex() {
        return this.dragEndIndex;
    }

    public JViewport getViewport() {
        return this.viewport;
    }

    public Model<E> getModel() {
        return this.model;
    }

    public boolean isEmpty() {
        return this.model.getNumElements() == 0;
    }

    public int getNumElements() {
        return this.model.getNumElements();
    }

    public E getElement(int n) {
        return this.model.getElement(n);
    }

    public List<E> getElements() {
        ArrayList<E> arrayList = new ArrayList<E>();
        for (int i = 0; i < this.getNumElements(); ++i) {
            arrayList.add(this.getElement(i));
        }
        return arrayList;
    }

    public E getSelectedElement() {
        return this.selectedIndex < 0 ? null : (E)this.getElement(this.selectedIndex);
    }

    public boolean isSelection() {
        return this.selectedIndex >= 0;
    }

    public boolean isDragEnabled() {
        return this.dragEnabled;
    }

    public void setColumnWidth(int n) {
        if (this.columnWidth != n) {
            this.columnWidth = n;
            this.resize();
            this.repaint();
        }
    }

    public void setRowHeight(int n) {
        if (this.rowHeight != n) {
            this.rowHeight = n;
            this.resize();
            this.repaint();
        }
    }

    public void setHorizontalMargin(int n) {
        if (this.horizontalMargin != n) {
            this.horizontalMargin = n;
            this.resize();
            this.repaint();
        }
    }

    public void setExtraWidth(int n) {
        if (this.extraWidth != n) {
            this.extraWidth = n;
            this.resize();
            this.repaint();
        }
    }

    public void setSelectedIndex(int n) {
        if (n != this.selectedIndex) {
            this.forceSelectedIndex(n);
        }
    }

    public void setDragEnabled(boolean bl) {
        this.dragEnabled = bl;
    }

    public void setViewport(JViewport jViewport) {
        this.viewport = jViewport;
    }

    public void setModel(Model<E> model) {
        this.model = model;
        this.resizeAndRedraw();
    }

    public void setElement(int n, E e) {
        this.model.setElement(n, e);
        this.redrawElements(n, 1);
        this.fireModelChanged();
    }

    public void setElements(E[] EArray) {
        if (this.model instanceof DefaultModel) {
            ((DefaultModel)this.model).setElements(EArray);
        } else {
            while (this.getNumElements() > 0) {
                this.model.removeElement(this.getNumElements() - 1);
            }
            if (EArray != null) {
                for (E e : EArray) {
                    this.model.addElement(this.getNumElements(), e);
                }
            }
        }
        this.resizeAndRedraw();
        this.fireModelChanged();
    }

    public void setElements(List<E> list) {
        if (this.model instanceof DefaultModel) {
            ((DefaultModel)this.model).setElements(list);
        } else {
            while (this.getNumElements() > 0) {
                this.model.removeElement(this.getNumElements() - 1);
            }
            if (list != null) {
                for (E e : list) {
                    this.model.addElement(this.getNumElements(), e);
                }
            }
        }
        this.resizeAndRedraw();
        this.fireModelChanged();
    }

    public void addElement(E e) {
        this.addElement(this.getNumElements(), e);
    }

    public void addElement(int n, E e) {
        this.model.addElement(n, e);
        this.resize();
        this.redrawElements(n, this.getNumElements() - n);
        this.forceSelectedIndex(n);
        this.fireModelChanged();
    }

    public void removeElement(int n) {
        int n2 = this.getNumElements() - n;
        this.model.removeElement(n);
        this.resize();
        this.redrawElements(n, n2);
        if (this.selectedIndex >= this.getNumElements()) {
            this.forceSelectedIndex(this.getNumElements() - 1);
        }
        this.fireModelChanged();
    }

    public void moveElement(int n, int n2) {
        if (n2 > n) {
            --n2;
        }
        if (n2 != n) {
            this.model.addElement(n2, this.model.removeElement(n));
            this.redrawElements(Math.min(n, n2), Math.abs(n - n2) + 1);
            this.forceSelectedIndex(n2);
            this.fireModelChanged();
        } else {
            this.forceSelectedIndex(n2);
        }
    }

    public void snapViewPosition() {
        if (this.viewport != null) {
            Point point = this.viewport.getViewPosition();
            int n = Math.max(0, point.y) / this.rowHeight * this.rowHeight;
            if (point.y != n) {
                point.y = n;
                this.viewport.setViewPosition(point);
            }
        }
    }

    public void addActionListener(ActionListener actionListener) {
        if (this.actionListeners == null) {
            this.actionListeners = new ArrayList<ActionListener>();
        }
        this.actionListeners.add(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        if (this.actionListeners != null) {
            this.actionListeners.remove(actionListener);
        }
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        if (this.selectionListeners == null) {
            this.selectionListeners = new ArrayList<ListSelectionListener>();
        }
        this.selectionListeners.add(listSelectionListener);
    }

    public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        if (this.selectionListeners != null) {
            this.selectionListeners.remove(listSelectionListener);
        }
    }

    public void addModelListener(ModelListener modelListener) {
        if (this.modelListeners == null) {
            this.modelListeners = new ArrayList<ModelListener>();
        }
        this.modelListeners.add(modelListener);
    }

    public void removeModelListener(ModelListener modelListener) {
        if (this.modelListeners != null) {
            this.modelListeners.remove(modelListener);
        }
    }

    protected void fireActionPerformed(String string) {
        if (this.actionListeners != null) {
            ActionEvent actionEvent = new ActionEvent(this, 1001, string);
            for (int i = this.actionListeners.size() - 1; i >= 0; --i) {
                this.actionListeners.get(i).actionPerformed(actionEvent);
            }
        }
    }

    protected void fireValueChanged() {
        if (this.selectionListeners != null) {
            ListSelectionEvent listSelectionEvent = new ListSelectionEvent(this, this.selectedIndex, this.selectedIndex, false);
            for (int i = this.selectionListeners.size() - 1; i >= 0; --i) {
                this.selectionListeners.get(i).valueChanged(listSelectionEvent);
            }
        }
    }

    protected void fireModelChanged() {
        if (this.modelListeners != null) {
            ModelEvent modelEvent = new ModelEvent(this);
            for (int i = this.modelListeners.size() - 1; i >= 0; --i) {
                this.modelListeners.get(i).modelChanged(modelEvent);
            }
        }
    }

    protected Color getBackgroundColour(int n) {
        return n == this.selectedIndex ? (this.isFocusOwner() ? Colours.List.FOCUSED_SELECTION_BACKGROUND.getColour() : Colours.List.SELECTION_BACKGROUND.getColour()) : this.getBackground();
    }

    protected Color getForegroundColour(int n) {
        return n == this.selectedIndex ? (this.isFocusOwner() ? Colours.List.FOCUSED_SELECTION_FOREGROUND.getColour() : Colours.List.SELECTION_FOREGROUND.getColour()) : this.getForeground();
    }

    protected void drawElement(Graphics graphics, int n) {
        graphics = graphics.create();
        TextRendering.setHints((Graphics2D)graphics);
        String string = this.getElement(n).toString();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n2 = this.getComponentOrientation().isLeftToRight() ? this.horizontalMargin : this.getWidth() - this.horizontalMargin - fontMetrics.stringWidth(string);
        int n3 = n * this.rowHeight + GuiUtilities.getBaselineOffset(this.rowHeight, fontMetrics);
        graphics.setColor(this.getForegroundColour(n));
        graphics.drawString(string, n2, n3);
    }

    protected void resize() {
        if (this.viewport != null) {
            this.viewport.setViewSize(this.getPreferredSize());
        }
        this.revalidate();
    }

    protected void resizeAndRedraw() {
        this.resize();
        this.selectedIndex = -1;
        this.repaint();
        this.forceSelectedIndex(this.getNumElements() > 0 ? 0 : -1);
    }

    protected void forceSelectedIndex(int n) {
        if (this.selectedIndex >= 0) {
            int n2 = this.selectedIndex;
            this.selectedIndex = -1;
            this.redrawElements(n2, 1);
        }
        if (n >= -1 && n < this.getNumElements()) {
            this.selectedIndex = n;
            this.makeSelectionViewable();
            if (this.selectedIndex >= 0) {
                this.redrawElements(this.selectedIndex, 1);
            }
            this.fireValueChanged();
        }
    }

    private void redrawElements(int n, int n2) {
        this.repaint(0, n * this.rowHeight, this.getWidth(), n2 * this.rowHeight);
    }

    private void setDragIndex(int n) {
        if (this.dragY != null) {
            this.dragIndex = -1;
            this.repaint(0, this.dragY, this.getWidth(), 6);
            this.dragY = null;
        }
        if (n >= 0) {
            this.dragIndex = n;
            int n2 = n * this.rowHeight - 3;
            this.repaint(0, n2, this.getWidth(), 6);
            this.dragY = new Integer(n2);
        }
    }

    private void incrementSelectedIndex(int n) {
        int n2 = this.selectedIndex < 0 ? 0 : this.selectedIndex;
        this.setSelectedIndex(Math.min(Math.max(0, n2 + n), this.getNumElements() - 1));
    }

    private void makeSelectionViewable() {
        if (this.viewport != null && this.selectedIndex >= 0) {
            Point point = this.viewport.getViewPosition();
            int n = point.y;
            int n2 = n / this.rowHeight;
            if (this.selectedIndex < n2) {
                n = this.selectedIndex * this.rowHeight;
            } else if (this.selectedIndex >= n2 + this.viewableRows) {
                n = Math.max(0, this.selectedIndex - this.viewableRows + 1) * this.rowHeight;
            }
            if (point.y != n) {
                point.y = n;
                this.viewport.setViewPosition(point);
            }
        }
    }

    private void incrementViewY(int n) {
        if (n != 0) {
            this.viewport.setViewPosition(new Point(this.viewport.getViewPosition().x, this.viewport.getViewPosition().y + n));
        }
    }

    private void doEditElement() {
        if (this.selectedIndex >= 0) {
            this.fireActionPerformed("editElement");
        }
    }

    private void doDeleteElement() {
        if (this.selectedIndex >= 0) {
            this.fireActionPerformed("deleteElement");
        }
    }

    private void doDeleteExElement() {
        if (this.selectedIndex >= 0) {
            this.fireActionPerformed("deleteExElement");
        }
    }

    private void doMoveElementUp() {
        if (this.selectedIndex > 0) {
            this.fireActionPerformed("moveElementUp");
        }
    }

    private void doMoveElementDown() {
        if (this.selectedIndex >= 0 && this.selectedIndex < this.getNumElements() - 1) {
            this.fireActionPerformed("moveElementDown");
        }
    }

    private void doSelectUpUnit() {
        this.incrementSelectedIndex(-1);
    }

    private void doSelectDownUnit() {
        this.incrementSelectedIndex(1);
    }

    private void doSelectUpBlock() {
        this.incrementSelectedIndex(-8);
    }

    private void doSelectDownBlock() {
        this.incrementSelectedIndex(8);
    }

    private void doSelectUpMax() {
        this.setSelectedIndex(0);
    }

    private void doSelectDownMax() {
        this.setSelectedIndex(this.getNumElements() - 1);
    }

    private void doScrollUpUnit() {
        if (this.viewport != null) {
            this.incrementViewY(-this.getScrollableUnitIncrement(this.viewport.getViewRect(), 1, -1));
        }
    }

    private void doScrollDownUnit() {
        if (this.viewport != null) {
            this.incrementViewY(this.getScrollableUnitIncrement(this.viewport.getViewRect(), 1, 1));
        }
    }

    public static class DefaultModel<E>
    extends ArrayList<E>
    implements Model<E> {
        @Override
        public int getNumElements() {
            return this.size();
        }

        @Override
        public E getElement(int n) {
            return this.get(n);
        }

        @Override
        public void setElement(int n, E e) {
            this.set(n, e);
        }

        @Override
        public void addElement(int n, E e) {
            this.add(n, e);
        }

        @Override
        public E removeElement(int n) {
            return this.remove(n);
        }

        public void setElements(E[] EArray) {
            this.clear();
            if (EArray != null) {
                Collections.addAll(this, EArray);
            }
        }

        public void setElements(List<E> list) {
            this.clear();
            if (list != null) {
                this.addAll(list);
            }
        }
    }

    public static class ModelEvent
    extends EventObject {
        private ModelEvent(SingleSelectionList<?> singleSelectionList) {
            super(singleSelectionList);
        }

        @Override
        public SingleSelectionList<?> getSource() {
            return (SingleSelectionList)this.source;
        }
    }

    public static interface ModelListener {
        public void modelChanged(ModelEvent var1);
    }

    public static interface Model<E> {
        public int getNumElements();

        public E getElement(int var1);

        public void setElement(int var1, E var2);

        public void addElement(int var1, E var2);

        public E removeElement(int var1);
    }

    private static interface ListCommand {
        public static final String SELECT_UP_UNIT = "selectUpUnit";
        public static final String SELECT_DOWN_UNIT = "selectDownUnit";
        public static final String SELECT_UP_BLOCK = "selectUpBlock";
        public static final String SELECT_DOWN_BLOCK = "selectDownBlock";
        public static final String SELECT_UP_MAX = "selectUpMax";
        public static final String SELECT_DOWN_MAX = "selectDownMax";
        public static final String SCROLL_UP_UNIT = "scrollUpUnit";
        public static final String SCROLL_DOWN_UNIT = "scrollDownUnit";
    }

    public static interface Command {
        public static final String EDIT_ELEMENT = "editElement";
        public static final String DELETE_ELEMENT = "deleteElement";
        public static final String DELETE_EX_ELEMENT = "deleteExElement";
        public static final String MOVE_ELEMENT_UP = "moveElementUp";
        public static final String MOVE_ELEMENT_DOWN = "moveElementDown";
        public static final String DRAG_ELEMENT = "dragElement";
    }
}

