/*
 * Decompiled with CFR 0.152.
 */
package functionplotter.gui;

import functionplotter.exception.ValueOutOfBoundsException;
import functionplotter.util.StringKeyed;
import functionplotter.util.TextUtilities;
import java.awt.Component;
import java.awt.Font;

public class FontEx {
    public static final int MIN_FONT_SIZE = 4;
    public static final int MAX_FONT_SIZE = 128;
    public static final char SEPARATOR_CHAR = ',';
    private static final String DEFAULT_FONT_NAME = "Dialog";
    private static final int DEFAULT_FONT_STYLE = 0;
    private static final int DEFAULT_FONT_SIZE = 12;
    private static final String MALFORMED_STR = "The font specifier is malformed.";
    private static final String INVALID_STYLE_STR = "The font style is invalid.";
    private static final String INVALID_SIZE_STR = "The font size is invalid.";
    private static final String SIZE_OUT_OF_BOUNDS_STR = "The font size must be between 4 and 128.";
    private String name;
    private Style style;
    private int size;

    public FontEx() {
    }

    public FontEx(String string, Style style, int n) {
        this.name = string;
        this.style = style;
        this.size = n;
    }

    public FontEx(Font font) {
        this.name = font.getFontName();
        this.style = Style.get(font.getStyle());
        this.size = font.getSize();
    }

    public FontEx(String string) throws IllegalArgumentException, ValueOutOfBoundsException {
        String[] stringArray = TextUtilities.splitString(string, ',');
        if (stringArray.length != 3) {
            throw new IllegalArgumentException(MALFORMED_STR);
        }
        String string2 = stringArray[0].trim();
        if (!string2.isEmpty()) {
            this.name = string2;
        }
        if (!(string2 = stringArray[1].trim()).isEmpty()) {
            this.style = Style.get(string2);
            if (this.style == null) {
                throw new IllegalArgumentException(INVALID_STYLE_STR);
            }
        }
        if (!(string2 = stringArray[2].trim()).isEmpty()) {
            try {
                this.size = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException(INVALID_SIZE_STR);
            }
            if (this.size < 4 || this.size > 128) {
                throw new ValueOutOfBoundsException(SIZE_OUT_OF_BOUNDS_STR);
            }
        }
    }

    public boolean equals(Object object) {
        if (object instanceof FontEx) {
            FontEx fontEx = (FontEx)object;
            return (this.name == null && fontEx.name == null || this.name != null && this.name.equals(fontEx.name)) && this.style == fontEx.style && this.size == fontEx.size;
        }
        return false;
    }

    public int hashCode() {
        int n = this.name == null ? 0 : this.name.hashCode();
        n = n * 31 + this.style.ordinal();
        n = n * 31 + this.size;
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.name != null) {
            stringBuilder.append(TextUtilities.escapeSeparator(this.name, ','));
        }
        stringBuilder.append(',');
        stringBuilder.append(' ');
        if (this.style != null) {
            stringBuilder.append(this.style.getKey());
        }
        stringBuilder.append(',');
        stringBuilder.append(' ');
        if (this.size > 0) {
            stringBuilder.append(this.size);
        }
        return stringBuilder.toString();
    }

    public String getName() {
        return this.name;
    }

    public Style getStyle() {
        return this.style;
    }

    public int getSize() {
        return this.size;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public void setSize(int n) {
        this.size = n;
    }

    public Font toFont() {
        return new Font(this.name == null ? DEFAULT_FONT_NAME : this.name, this.style == null ? 0 : this.style.getAwtStyle(), this.size == 0 ? 12 : this.size);
    }

    public void applyFont(Component component) {
        if (component != null) {
            int n;
            int n2;
            String string;
            Font font = component.getFont();
            if (font == null) {
                font = new Font(DEFAULT_FONT_NAME, 0, 12);
            }
            if ((string = this.name) == null && (string = font.getFontName()) == null) {
                string = DEFAULT_FONT_NAME;
            }
            int n3 = n2 = this.style == null ? 0 : this.style.getAwtStyle();
            if (this.style == null && (n2 = font.getStyle()) < 0) {
                n2 = 0;
            }
            if ((n = this.size) == 0 && (n = font.getSize()) <= 0) {
                n = 12;
            }
            component.setFont(new Font(string, n2, n));
        }
    }

    public static enum Style implements StringKeyed
    {
        PLAIN("plain", "Plain", 0),
        BOLD("bold", "Bold", 1),
        ITALIC("italic", "Italic", 2),
        BOLD_ITALIC("boldItalic", "Bold italic", 3);

        private String key;
        private String text;
        private int awtStyle;

        private Style(String string2, String string3, int n2) {
            this.key = string2;
            this.text = string3;
            this.awtStyle = n2;
        }

        public static Style get(String string) {
            for (Style style : Style.values()) {
                if (!style.key.equals(string)) continue;
                return style;
            }
            return null;
        }

        public static Style get(int n) {
            for (Style style : Style.values()) {
                if (style.awtStyle != n) continue;
                return style;
            }
            return null;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        public String toString() {
            return this.text;
        }

        public int getAwtStyle() {
            return this.awtStyle;
        }
    }
}

