/*
 * Decompiled with CFR 0.152.
 */
package functionplotter;

import functionplotter.AppFont;
import functionplotter.exception.AppException;
import functionplotter.gui.GuiUtilities;
import functionplotter.textfield.ConstrainedTextField;
import java.awt.Font;
import java.awt.datatransfer.StringSelection;
import javax.swing.JOptionPane;
import javax.swing.text.BadLocationException;

class SurrogateMinus {
    private static final char[] MINUS_CHARS = new char[]{'\u2212', '\u2013'};

    private SurrogateMinus() {
    }

    public static char getMinusChar(Font font) {
        for (char c : MINUS_CHARS) {
            if (!font.canDisplay(c)) continue;
            return c;
        }
        return '-';
    }

    public static String minusToSurrogate(String string, char c) {
        return string == null ? null : (c == '-' ? string : string.replace('-', c));
    }

    public static String surrogateToMinus(String string, char c) {
        return string == null ? null : (c == '-' ? string : string.replace(c, '-'));
    }

    public static class Field
    extends ConstrainedTextField {
        private char minusChar;

        public Field(int n, int n2) {
            super(n, n2);
            AppFont.TEXT_FIELD.apply(this);
            GuiUtilities.setTextComponentMargins(this);
            this.minusChar = SurrogateMinus.getMinusChar(this.getFont());
        }

        @Override
        protected String translateInsertString(String string, int n) {
            return SurrogateMinus.minusToSurrogate(string, this.minusChar);
        }

        @Override
        public void cut() {
            this.copySelection();
            int n = this.getSelectionStart();
            int n2 = this.getSelectionEnd();
            if (n < n2) {
                String string = this.getText();
                this.setText(string.substring(0, n) + string.substring(n2));
                this.getCaret().setDot(n);
            }
        }

        @Override
        public void copy() {
            this.copySelection();
        }

        @Override
        public String getText() {
            return SurrogateMinus.surrogateToMinus(super.getText(), this.minusChar);
        }

        @Override
        public String getText(int n, int n2) throws BadLocationException {
            return SurrogateMinus.surrogateToMinus(super.getText(n, n2), this.minusChar);
        }

        protected boolean isMinusCharacter(char c) {
            return c == this.minusChar;
        }

        private void copySelection() {
            int n;
            int n2 = this.getSelectionStart();
            if (n2 < (n = this.getSelectionEnd())) {
                try {
                    StringSelection stringSelection = new StringSelection(this.getText().substring(n2, n));
                    this.getToolkit().getSystemClipboard().setContents(stringSelection, stringSelection);
                }
                catch (IllegalStateException illegalStateException) {
                    JOptionPane.showMessageDialog(this, new AppException(ErrorId.CLIPBOARD_UNAVAILABLE), "FuncPlotter", 0);
                }
            }
        }
    }

    private static enum ErrorId implements AppException.Id
    {
        CLIPBOARD_UNAVAILABLE("The clipboard is currently unavailable.");

        private String message;

        private ErrorId(String string2) {
            this.message = string2;
        }

        @Override
        public String getMessage() {
            return this.message;
        }
    }
}

