/*
 * Decompiled with CFR 0.152.
 */
package functionplotter;

import functionplotter.App;
import functionplotter.AppConfig;
import functionplotter.AppConstants;
import functionplotter.AppFont;
import functionplotter.FPathnameField;
import functionplotter.FileKind;
import functionplotter.Operation;
import functionplotter.OperationDialog;
import functionplotter.Util;
import functionplotter.exception.AppException;
import functionplotter.exception.FileException;
import functionplotter.gui.BooleanComboBox;
import functionplotter.gui.ColourSampleIcon;
import functionplotter.gui.FButton;
import functionplotter.gui.FCheckBox;
import functionplotter.gui.FComboBox;
import functionplotter.gui.FIntegerSpinner;
import functionplotter.gui.FLabel;
import functionplotter.gui.FTabbedPane;
import functionplotter.gui.FontEx;
import functionplotter.gui.GuiUtilities;
import functionplotter.gui.IntegerSpinner;
import functionplotter.gui.PathnamePanel;
import functionplotter.gui.TextRendering;
import functionplotter.gui.TitledBorder;
import functionplotter.textfield.IntegerValueField;
import functionplotter.util.IntegerRange;
import functionplotter.util.KeyAction;
import functionplotter.util.NoYesAsk;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class PreferencesDialog
extends JDialog
implements ActionListener,
ChangeListener {
    private static final String TITLE_STR = "Preferences";
    private static final String SAVE_CONFIGURATION_STR = "Save Configuration";
    private static final String SAVE_CONFIG_FILE_STR = "Save Configuration File";
    private static final String WRITE_CONFIG_FILE_STR = "Write Configuration File";
    private static final String GENERAL_STR = "General";
    private static final String DEFAULT_FILE_TYPE_STR = "Default file type:";
    private static final String NEW_DOCUMENT_ON_STARTUP_STR = "New document on startup:";
    private static final String SAVE_FUNCTION_COLOURS_STR = "Save function colours in document:";
    private static final String SHOW_UNIX_PATHNAMES_STR = "Display UNIX-style pathnames:";
    private static final String SAVE_MAIN_WINDOW_LOCATION_STR = "Save location of main window:";
    private static final String APPEARANCE_STR = "Appearance";
    private static final String LOOK_AND_FEEL_STR = "Look-and-feel:";
    private static final String ORIENTATION_BY_LOCALE_STR = "Orientation by locale:";
    private static final String TEXT_ANTIALIASING_STR = "Text antialiasing:";
    private static final String BACKGROUND_COLOUR_STR = "Background colour:";
    private static final String NO_LOOK_AND_FEELS_STR = "<no look-and-feels>";
    private static final int PLOT_SIZE_FIELD_LENGTH = 4;
    private static final int NUM_FRACTION_DIGITS_FIELD_LENGTH = 2;
    private static final int NUM_Y_SCALE_DIGITS_FIELD_LENGTH = 2;
    private static final int FIXED_POINT_RANGE_FIELD_LENGTH = 3;
    private static final String PLOT_STR = "Plot";
    private static final String PLOT_SIZE_STR = "Plot size:";
    private static final String TIMES_STR = "\u00d7";
    private static final String SHOW_GRID_STR = "Show grid:";
    private static final String NUM_FRACTION_DIGITS_STR = "Maximum number of fraction digits:";
    private static final String NUM_Y_SCALE_DIGITS_STR = "Number of y-scale digits:";
    private static final String FIXED_POINT_EXPONENT_RANGE_STR = "Fixed-point exponent range:";
    private static final String TO_STR = "to";
    private static final String NORMALISE_SCI_NOTATION_STR = "Normalise scientific notation:";
    private static final String TRUNCATE_X_SCALE_TEXT_STR = "Truncate x-scale text:";
    private static final String PLOT_COLOURS_STR = "Plot colours";
    private static final String FOCUSED_BORDER_STR = "Focused border:";
    private static final String IMAGE_MARGIN_STR = "Image margin:";
    private static final String BACKGROUND_STR = "Background:";
    private static final String GRID_STR = "Grid:";
    private static final String AXIS_STR = "Axis:";
    private static final String SCALE_MARKINGS_STR = "Scale markings:";
    private static final String BACKGROUND_COLOUR_TITLE_STR = "Background Colour";
    private static final String PLOT_COLOUR_STR = "Plot Colour | ";
    private static final String FOCUSED_BORDER_TITLE_STR = "Focused Border";
    private static final String IMAGE_MARGIN_TITLE_STR = "Image Margin";
    private static final String BACKGROUND_TITLE_STR = "Background";
    private static final String GRID_TITLE_STR = "Grid";
    private static final String AXIS_TITLE_STR = "Axis";
    private static final String SCALE_MARKINGS_TITLE_STR = "Scale Markings";
    private static final int LIST_WIDTH_FIELD_LENGTH = 2;
    private static final int LIST_HEIGHT_FIELD_LENGTH = 2;
    private static final int FUNCTION_COLOUR_ROWS = 2;
    private static final int FUNCTION_COLOUR_BUTTON_ICON_WIDTH = 20;
    private static final int FUNCTION_COLOUR_BUTTON_ICON_HEIGHT = 12;
    private static final Insets FUNCTION_COLOUR_BUTTON_MARGINS = new Insets(1, 1, 1, 1);
    private static final String FUNCTION_STR = "Function";
    private static final String DIRECTORY_STR = "Directory:";
    private static final String LIST_SIZE_STR = "Function list size:";
    private static final String COLUMNS_BY_ROWS_STR = "(columns \u00d7 rows)";
    private static final String FUNCTION_COLOURS_STR = "Default function colours";
    private static final String FUNCTION_COLOUR_TITLE_STR = "Default Function Colour ";
    private static final String DIRECTORY_TITLE_STR = "Select Directory";
    private static final String SELECT_STR = "Select";
    private static final String SELECT_DIRECTORY_STR = "Select directory";
    private static final String FONTS_STR = "Fonts";
    private static final String PT_STR = "pt";
    private static Point location;
    private static int tabIndex;
    private boolean accepted;
    private JTabbedPane tabbedPane;
    private JComboBox defaultFileKindComboBox;
    private BooleanComboBox newDocOnStartupComboBox;
    private JComboBox saveFunctionColoursComboBox;
    private BooleanComboBox showUnixPathnamesComboBox;
    private BooleanComboBox saveMainWindowLocationComboBox;
    private JComboBox lookAndFeelComboBox;
    private BooleanComboBox orientationByLocaleComboBox;
    private JComboBox textAntialiasingComboBox;
    private JCheckBox backgroundColourCheckBox;
    private JButton backgroundColourButton;
    private FIntegerSpinner plotWidthSpinner;
    private FIntegerSpinner plotHeightSpinner;
    private BooleanComboBox showGridComboBox;
    private FIntegerSpinner numFractionDigitsSpinner;
    private FIntegerSpinner numYScaleDigitsSpinner;
    private FIntegerSpinner fixedPointLowerLimitSpinner;
    private FIntegerSpinner fixedPointUpperLimitSpinner;
    private BooleanComboBox normaliseSciNotationComboBox;
    private BooleanComboBox truncateXScaleTextComboBox;
    private JButton plotColourFocusedBorderButton;
    private JButton plotColourImageMarginButton;
    private JButton plotColourBackgroundButton;
    private JButton plotColourGridButton;
    private JButton plotColourAxisButton;
    private JButton plotColourScaleMarkingsButton;
    private FPathnameField directoryField;
    private JFileChooser directoryFileChooser;
    private FIntegerSpinner listWidthSpinner;
    private FIntegerSpinner listHeightSpinner;
    private JButton[] functionColourButtons;
    private FontPanel[] fontPanels;

    private PreferencesDialog(Window window) {
        super(window, TITLE_STR, Dialog.ModalityType.APPLICATION_MODAL);
        this.setIconImages(window.getIconImages());
        this.tabbedPane = new FTabbedPane();
        AppFont.MAIN.apply(this.tabbedPane);
        this.tabbedPane.addTab(GENERAL_STR, this.getPanelGeneral());
        this.tabbedPane.addTab(APPEARANCE_STR, this.getPanelAppearance());
        this.tabbedPane.addTab(PLOT_STR, this.getPanelPlot());
        this.tabbedPane.addTab(FUNCTION_STR, this.getPanelFunction());
        this.tabbedPane.addTab(FONTS_STR, this.getPanelFonts());
        this.tabbedPane.setSelectedIndex(tabIndex);
        this.tabbedPane.addChangeListener(this);
        JPanel jPanel = new JPanel(new GridLayout(1, 0, 8, 0));
        FButton fButton = new FButton("Save Configuration...");
        fButton.setActionCommand("saveConfiguration");
        fButton.addActionListener(this);
        jPanel.add(fButton);
        JPanel jPanel2 = new JPanel(new GridLayout(1, 0, 8, 0));
        FButton fButton2 = new FButton("OK");
        fButton2.setActionCommand("accept");
        fButton2.addActionListener(this);
        jPanel2.add(fButton2);
        FButton fButton3 = new FButton("Cancel");
        fButton3.setActionCommand("close");
        fButton3.addActionListener(this);
        jPanel2.add(fButton3);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel3 = new JPanel(gridBagLayout);
        jPanel3.setBorder(BorderFactory.createEmptyBorder(2, 24, 3, 24));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        jPanel3.add(jPanel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel3.add(jPanel2);
        JPanel jPanel4 = new JPanel(gridBagLayout);
        jPanel4.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagLayout.setConstraints(this.tabbedPane, gridBagConstraints);
        jPanel4.add(this.tabbedPane);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        jPanel4.add(jPanel3);
        KeyAction.create(jPanel4, 1, KeyStroke.getKeyStroke(27, 0), "close", this);
        this.setContentPane(jPanel4);
        App.applyOrientationByLocale(this);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowEventHandler());
        this.setResizable(false);
        this.pack();
        if (location == null) {
            location = GuiUtilities.getComponentLocation((Component)this, window);
        }
        this.setLocation(location);
        this.getRootPane().setDefaultButton(fButton2);
        this.setVisible(true);
    }

    public static PreferencesDialog showDialog(Component component) {
        return new PreferencesDialog(GuiUtilities.getWindow(component));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("enableBackgroundColour")) {
            this.doEnableBackgroundColour();
        } else if (string.equals("chooseBackgroundColour")) {
            this.doChooseBackgroundColour();
        } else if (string.equals("choosePlotColourFocusedBorder")) {
            this.doChoosePlotColourFocusedBorder();
        } else if (string.equals("choosePlotColourImageMargin")) {
            this.doChoosePlotColourImageMargin();
        } else if (string.equals("choosePlotColourBackground")) {
            this.doChoosePlotColourBackground();
        } else if (string.equals("choosePlotColourGrid")) {
            this.doChoosePlotColourGrid();
        } else if (string.equals("choosePlotColourAxis")) {
            this.doChoosePlotColourAxis();
        } else if (string.equals("choosePlotColourScale")) {
            this.doChoosePlotColourScale();
        } else if (string.equals("chooseFunctionDirectory")) {
            this.doChooseFunctionDirectory();
        } else if (string.startsWith("chooseFunctionColour")) {
            this.doChooseFunctionColour(string.substring("chooseFunctionColour".length()));
        } else if (string.equals("saveConfiguration")) {
            this.doSaveConfiguration();
        } else if (string.equals("accept")) {
            this.doAccept();
        } else if (string.equals("close")) {
            this.doClose();
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        tabIndex = this.tabbedPane.getSelectedIndex();
    }

    public boolean isAccepted() {
        return this.accepted;
    }

    private void validatePreferences() throws AppException {
        this.validatePreferencesGeneral();
        this.validatePreferencesAppearance();
        this.validatePreferencesPlot();
        this.validatePreferencesFunction();
        this.validatePreferencesFonts();
    }

    private void setPreferences() {
        this.setPreferencesGeneral();
        this.setPreferencesAppearance();
        this.setPreferencesPlot();
        this.setPreferencesFunction();
        this.setPreferencesFonts();
    }

    private void doEnableBackgroundColour() {
        this.backgroundColourButton.setEnabled(this.backgroundColourCheckBox.isSelected());
    }

    private void doChooseBackgroundColour() {
        Color color = JColorChooser.showDialog(this, BACKGROUND_COLOUR_TITLE_STR, this.backgroundColourButton.getForeground());
        if (color != null) {
            this.backgroundColourButton.setForeground(color);
        }
    }

    private void doChoosePlotColourFocusedBorder() {
        Color color = JColorChooser.showDialog(this, "Plot Colour | Focused Border", this.plotColourFocusedBorderButton.getForeground());
        if (color != null) {
            this.plotColourFocusedBorderButton.setForeground(color);
        }
    }

    private void doChoosePlotColourImageMargin() {
        Color color = JColorChooser.showDialog(this, "Plot Colour | Image Margin", this.plotColourImageMarginButton.getForeground());
        if (color != null) {
            this.plotColourImageMarginButton.setForeground(color);
        }
    }

    private void doChoosePlotColourBackground() {
        Color color = JColorChooser.showDialog(this, "Plot Colour | Background", this.plotColourBackgroundButton.getForeground());
        if (color != null) {
            this.plotColourBackgroundButton.setForeground(color);
        }
    }

    private void doChoosePlotColourGrid() {
        Color color = JColorChooser.showDialog(this, "Plot Colour | Grid", this.plotColourGridButton.getForeground());
        if (color != null) {
            this.plotColourGridButton.setForeground(color);
        }
    }

    private void doChoosePlotColourAxis() {
        Color color = JColorChooser.showDialog(this, "Plot Colour | Axis", this.plotColourAxisButton.getForeground());
        if (color != null) {
            this.plotColourAxisButton.setForeground(color);
        }
    }

    private void doChoosePlotColourScale() {
        Color color = JColorChooser.showDialog(this, "Plot Colour | Scale Markings", this.plotColourScaleMarkingsButton.getForeground());
        if (color != null) {
            this.plotColourScaleMarkingsButton.setForeground(color);
        }
    }

    private void doChooseFunctionDirectory() {
        if (this.directoryFileChooser == null) {
            this.directoryFileChooser = new JFileChooser();
            this.directoryFileChooser.setDialogTitle(DIRECTORY_TITLE_STR);
            this.directoryFileChooser.setFileSelectionMode(1);
            this.directoryFileChooser.setApproveButtonMnemonic(83);
            this.directoryFileChooser.setApproveButtonToolTipText(SELECT_DIRECTORY_STR);
            App.applyOrientationByLocale(this.directoryFileChooser);
        }
        this.directoryFileChooser.setCurrentDirectory(this.directoryField.getCanonicalFile());
        this.directoryFileChooser.rescanCurrentDirectory();
        if (this.directoryFileChooser.showDialog(this, SELECT_STR) == 0) {
            this.directoryField.setFile(this.directoryFileChooser.getSelectedFile(), AppConfig.getInstance().isShowUnixPathnames());
        }
    }

    private void doChooseFunctionColour(String string) {
        int n = Integer.parseInt(string);
        Color color = JColorChooser.showDialog(this, FUNCTION_COLOUR_TITLE_STR + (n + 1), this.functionColourButtons[n].getForeground());
        if (color != null) {
            this.functionColourButtons[n].setForeground(color);
        }
    }

    private void doSaveConfiguration() {
        try {
            this.validatePreferences();
            File file = AppConfig.getInstance().chooseFile(this);
            if (!(file == null || file.exists() && JOptionPane.showOptionDialog(this, App.getPathname(file) + "\nThe file already exists.\nDo you want to replace it?", SAVE_CONFIG_FILE_STR, 2, 2, null, AppConstants.RC_OPTION_STRS, AppConstants.RC_OPTION_STRS[1]) != 0)) {
                this.setPreferences();
                this.accepted = true;
                OperationDialog.showDialog(this, WRITE_CONFIG_FILE_STR, new Operation.WriteConfig(file));
            }
        }
        catch (AppException appException) {
            JOptionPane.showMessageDialog(this, appException, "FuncPlotter", 0);
        }
        if (this.accepted) {
            this.doClose();
        }
    }

    private void doAccept() {
        try {
            this.validatePreferences();
            this.setPreferences();
            this.accepted = true;
            this.doClose();
        }
        catch (AppException appException) {
            JOptionPane.showMessageDialog(this, appException, "FuncPlotter", 0);
        }
    }

    private void doClose() {
        location = this.getLocation();
        this.setVisible(false);
        this.dispose();
    }

    private JPanel getPanelGeneral() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(gridBagLayout);
        GuiUtilities.setPaddedLineBorder(jPanel);
        int n = 0;
        AppConfig appConfig = AppConfig.getInstance();
        FLabel fLabel = new FLabel(DEFAULT_FILE_TYPE_STR);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = AppConstants.COMPONENT_INSETS;
        gridBagLayout.setConstraints(fLabel, gridBagConstraints);
        jPanel.add(fLabel);
        this.defaultFileKindComboBox = new FComboBox(FileKind.values());
        this.defaultFileKindComboBox.setSelectedItem(appConfig.getDefaultFileKind());
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = AppConstants.COMPONENT_INSETS;
        gridBagLayout.setConstraints(this.defaultFileKindComboBox, gridBagConstraints);
        jPanel.add(this.defaultFileKindComboBox);
        FLabel fLabel2 = new FLabel(NEW_DOCUMENT_ON_STARTUP_STR);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = AppConstants.COMPONENT_INSETS;
        gridBagLayout.setConstraints(fLabel2, gridBagConstraints);
        jPanel.add(fLabel2);
        this.newDocOnStartupComboBox = new BooleanComboBox(appConfig.isNewDocumentOnStartup());
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = AppConstants.COMPONENT_INSETS;
        gridBagLayout.setConstraints(this.newDocOnStartupComboBox, gridBagConstraints);
        jPanel.add(this.newDocOnStartupComboBox);
        FLabel fLabel3 = new FLabel(SAVE_FUNCTION_COLOURS_STR);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = AppConstants.COMPONENT_INSETS;
        gridBagLayout.setConstraints(fLabel3, gridBagConstraints);
        jPanel.add(fLabel3);
        this.saveFunctionColoursComboBox = new FComboBox(NoYesAsk.values());
        this.saveFunctionColoursComboBox.setSelectedItem(appConfig.getSaveFunctionColours());
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = AppConstants.COMPONENT_INSETS;
        gridBagLayout.setConstraints(this.saveFunctionColoursComboBox, gridBagConstraints);
        jPanel.add(this.saveFunctionColoursComboBox);
        FLabel fLabel4 = new FLabel(SHOW_UNIX_PATHNAMES_STR);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = AppConstants.COMPONENT_INSETS;
        gridBagLayout.setConstraints(fLabel4, gridBagConstraints);
        jPanel.add(fLabel4);
        this.showUnixPathnamesComboBox = new BooleanComboBox(appConfig.isShowUnixPathnames());
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = AppConstants.COMPONENT_INSETS;
        gridBagLayout.setConstraints(this.showUnixPathnamesComboBox, gridBagConstraints);
        jPanel.add(this.showUnixPathnamesComboBox);
        FLabel fLabel5 = new FLabel(SAVE_MAIN_WINDOW_LOCATION_STR);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = AppConstants.COMPONENT_INSETS;
        gridBagLayout.setConstraints(fLabel5, gridBagConstraints);
        jPanel.add(fLabel5);
        this.saveMainWindowLocationComboBox = new BooleanComboBox(appConfig.isMainWindowLocation());
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = AppConstants.COMPONENT_INSETS;
        gridBagLayout.setConstraints(this.saveMainWindowLocationComboBox, gridBagConstraints);
        jPanel.add(this.saveMainWindowLocationComboBox);
        JPanel jPanel2 = new JPanel(gridBagLayout);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        jPanel2.add(jPanel);
        return jPanel2;
    }

    private JPanel getPanelAppearance() {
        Object object;
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(gridBagLayout);
        GuiUtilities.setPaddedLineBorder(jPanel);
        int n = 0;
        AppConfig appConfig = AppConfig.getInstance();
        FLabel fLabel = new FLabel(LOOK_AND_FEEL_STR);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = AppConstants.COMPONENT_INSETS;
        gridBagLayout.setConstraints(fLabel, gridBagConstraints);
        jPanel.add(fLabel);
        this.lookAndFeelComboBox = new FComboBox();
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        if (lookAndFeelInfoArray.length == 0) {
            this.lookAndFeelComboBox.addItem(NO_LOOK_AND_FEELS_STR);
            this.lookAndFeelComboBox.setSelectedIndex(0);
            this.lookAndFeelComboBox.setEnabled(false);
        } else {
            object = new String[lookAndFeelInfoArray.length];
            for (int i = 0; i < lookAndFeelInfoArray.length; ++i) {
                object[i] = lookAndFeelInfoArray[i].getName();
                this.lookAndFeelComboBox.addItem(object[i]);
            }
            this.lookAndFeelComboBox.setSelectedIndex(Util.indexOf(object, appConfig.getLookAndFeel()));
        }
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = AppConstants.COMPONENT_INSETS;
        gridBagLayout.setConstraints(this.lookAndFeelComboBox, gridBagConstraints);
        jPanel.add(this.lookAndFeelComboBox);
        object = new FLabel(ORIENTATION_BY_LOCALE_STR);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = AppConstants.COMPONENT_INSETS;
        gridBagLayout.setConstraints((Component)object, gridBagConstraints);
        jPanel.add((Component)object);
        this.orientationByLocaleComboBox = new BooleanComboBox(appConfig.isOrientationByLocale());
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = AppConstants.COMPONENT_INSETS;
        gridBagLayout.setConstraints(this.orientationByLocaleComboBox, gridBagConstraints);
        jPanel.add(this.orientationByLocaleComboBox);
        FLabel fLabel2 = new FLabel(TEXT_ANTIALIASING_STR);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = AppConstants.COMPONENT_INSETS;
        gridBagLayout.setConstraints(fLabel2, gridBagConstraints);
        jPanel.add(fLabel2);
        this.textAntialiasingComboBox = new FComboBox(TextRendering.Antialiasing.values());
        this.textAntialiasingComboBox.setSelectedItem(appConfig.getTextAntialiasing());
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = AppConstants.COMPONENT_INSETS;
        gridBagLayout.setConstraints(this.textAntialiasingComboBox, gridBagConstraints);
        jPanel.add(this.textAntialiasingComboBox);
        this.backgroundColourCheckBox = new FCheckBox(BACKGROUND_COLOUR_STR);
        this.backgroundColourCheckBox.setSelected(appConfig.isBackgroundColour());
        this.backgroundColourCheckBox.setActionCommand("enableBackgroundColour");
        this.backgroundColourCheckBox.addActionListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = AppConstants.COMPONENT_INSETS;
        gridBagLayout.setConstraints(this.backgroundColourCheckBox, gridBagConstraints);
        jPanel.add(this.backgroundColourCheckBox);
        this.backgroundColourButton = new ColourSampleButton(appConfig.getBackgroundColour());
        this.backgroundColourButton.setEnabled(this.backgroundColourCheckBox.isSelected());
        this.backgroundColourButton.setActionCommand("chooseBackgroundColour");
        this.backgroundColourButton.addActionListener(this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = AppConstants.COMPONENT_INSETS;
        gridBagLayout.setConstraints(this.backgroundColourButton, gridBagConstraints);
        jPanel.add(this.backgroundColourButton);
        JPanel jPanel2 = new JPanel(gridBagLayout);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        jPanel2.add(jPanel);
        return jPanel2;
    }

    private JPanel getPanelPlot() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(gridBagLayout);
        GuiUtilities.setPaddedLineBorder(jPanel);
        int n = 0;
        AppConfig appConfig = AppConfig.getInstance();
        FLabel fLabel = new FLabel(PLOT_SIZE_STR);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = AppConstants.COMPONENT_INSETS;
        gridBagLayout.setConstraints(fLabel, gridBagConstraints);
        jPanel.add(fLabel);
        JPanel jPanel2 = new JPanel(gridBagLayout);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = AppConstants.COMPONENT_INSETS;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        this.plotWidthSpinner = new FIntegerSpinner(appConfig.getPlotSize().width, 128, 2048, 4);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagLayout.setConstraints(this.plotWidthSpinner, gridBagConstraints);
        jPanel2.add(this.plotWidthSpinner);
        FLabel fLabel2 = new FLabel(TIMES_STR);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        gridBagLayout.setConstraints(fLabel2, gridBagConstraints);
        jPanel2.add(fLabel2);
        this.plotHeightSpinner = new FIntegerSpinner(appConfig.getPlotSize().height, 128, 2048, 4);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        gridBagLayout.setConstraints(this.plotHeightSpinner, gridBagConstraints);
        jPanel2.add(this.plotHeightSpinner);
        FLabel fLabel3 = new FLabel(SHOW_GRID_STR);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = AppConstants.COMPONENT_INSETS;
        gridBagLayout.setConstraints(fLabel3, gridBagConstraints);
        jPanel.add(fLabel3);
        this.showGridComboBox = new BooleanComboBox(appConfig.isShowGrid());
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = AppConstants.COMPONENT_INSETS;
        gridBagLayout.setConstraints(this.showGridComboBox, gridBagConstraints);
        jPanel.add(this.showGridComboBox);
        FLabel fLabel4 = new FLabel(NUM_FRACTION_DIGITS_STR);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = AppConstants.COMPONENT_INSETS;
        gridBagLayout.setConstraints(fLabel4, gridBagConstraints);
        jPanel.add(fLabel4);
        this.numFractionDigitsSpinner = new FIntegerSpinner(appConfig.getNumFractionDigits(), 1, 12, 2);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = AppConstants.COMPONENT_INSETS;
        gridBagLayout.setConstraints(this.numFractionDigitsSpinner, gridBagConstraints);
        jPanel.add(this.numFractionDigitsSpinner);
        FLabel fLabel5 = new FLabel(NUM_Y_SCALE_DIGITS_STR);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = AppConstants.COMPONENT_INSETS;
        gridBagLayout.setConstraints(fLabel5, gridBagConstraints);
        jPanel.add(fLabel5);
        this.numYScaleDigitsSpinner = new FIntegerSpinner(appConfig.getNumYScaleDigits(), 4, 20, 2);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = AppConstants.COMPONENT_INSETS;
        gridBagLayout.setConstraints(this.numYScaleDigitsSpinner, gridBagConstraints);
        jPanel.add(this.numYScaleDigitsSpinner);
        FLabel fLabel6 = new FLabel(FIXED_POINT_EXPONENT_RANGE_STR);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = AppConstants.COMPONENT_INSETS;
        gridBagLayout.setConstraints(fLabel6, gridBagConstraints);
        jPanel.add(fLabel6);
        JPanel jPanel3 = new JPanel(gridBagLayout);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = AppConstants.COMPONENT_INSETS;
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        jPanel.add(jPanel3);
        this.fixedPointLowerLimitSpinner = new FIntegerSpinner(appConfig.getFixedPointExponentRange().lowerLimit, -12, 12, 3, true);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagLayout.setConstraints(this.fixedPointLowerLimitSpinner, gridBagConstraints);
        jPanel3.add(this.fixedPointLowerLimitSpinner);
        FLabel fLabel7 = new FLabel(TO_STR);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        gridBagLayout.setConstraints(fLabel7, gridBagConstraints);
        jPanel3.add(fLabel7);
        this.fixedPointUpperLimitSpinner = new FIntegerSpinner(appConfig.getFixedPointExponentRange().upperLimit, -12, 12, 3, true);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        gridBagLayout.setConstraints(this.fixedPointUpperLimitSpinner, gridBagConstraints);
        jPanel3.add(this.fixedPointUpperLimitSpinner);
        FLabel fLabel8 = new FLabel(NORMALISE_SCI_NOTATION_STR);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = AppConstants.COMPONENT_INSETS;
        gridBagLayout.setConstraints(fLabel8, gridBagConstraints);
        jPanel.add(fLabel8);
        this.normaliseSciNotationComboBox = new BooleanComboBox(appConfig.isNormaliseScientificNotation());
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = AppConstants.COMPONENT_INSETS;
        gridBagLayout.setConstraints(this.normaliseSciNotationComboBox, gridBagConstraints);
        jPanel.add(this.normaliseSciNotationComboBox);
        FLabel fLabel9 = new FLabel(TRUNCATE_X_SCALE_TEXT_STR);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = AppConstants.COMPONENT_INSETS;
        gridBagLayout.setConstraints(fLabel9, gridBagConstraints);
        jPanel.add(fLabel9);
        this.truncateXScaleTextComboBox = new BooleanComboBox(appConfig.isTruncateXScaleText());
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = AppConstants.COMPONENT_INSETS;
        gridBagLayout.setConstraints(this.truncateXScaleTextComboBox, gridBagConstraints);
        jPanel.add(this.truncateXScaleTextComboBox);
        JPanel jPanel4 = new JPanel(gridBagLayout);
        TitledBorder.setPaddedBorder(jPanel4, PLOT_COLOURS_STR);
        JPanel jPanel5 = new JPanel(gridBagLayout);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagLayout.setConstraints(jPanel5, gridBagConstraints);
        jPanel4.add(jPanel5);
        n = 0;
        FLabel fLabel10 = new FLabel(FOCUSED_BORDER_STR);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = AppConstants.COMPONENT_INSETS;
        gridBagLayout.setConstraints(fLabel10, gridBagConstraints);
        jPanel5.add(fLabel10);
        this.plotColourFocusedBorderButton = new ColourSampleButton(appConfig.getPlotColourFocusedBorder());
        this.plotColourFocusedBorderButton.setActionCommand("choosePlotColourFocusedBorder");
        this.plotColourFocusedBorderButton.addActionListener(this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = AppConstants.COMPONENT_INSETS;
        gridBagLayout.setConstraints(this.plotColourFocusedBorderButton, gridBagConstraints);
        jPanel5.add(this.plotColourFocusedBorderButton);
        FLabel fLabel11 = new FLabel(IMAGE_MARGIN_STR);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = AppConstants.COMPONENT_INSETS;
        gridBagLayout.setConstraints(fLabel11, gridBagConstraints);
        jPanel5.add(fLabel11);
        this.plotColourImageMarginButton = new ColourSampleButton(appConfig.getPlotColourImageMargin());
        this.plotColourImageMarginButton.setActionCommand("choosePlotColourImageMargin");
        this.plotColourImageMarginButton.addActionListener(this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = AppConstants.COMPONENT_INSETS;
        gridBagLayout.setConstraints(this.plotColourImageMarginButton, gridBagConstraints);
        jPanel5.add(this.plotColourImageMarginButton);
        FLabel fLabel12 = new FLabel(BACKGROUND_STR);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = AppConstants.COMPONENT_INSETS;
        gridBagLayout.setConstraints(fLabel12, gridBagConstraints);
        jPanel5.add(fLabel12);
        this.plotColourBackgroundButton = new ColourSampleButton(appConfig.getPlotColourBackground());
        this.plotColourBackgroundButton.setActionCommand("choosePlotColourBackground");
        this.plotColourBackgroundButton.addActionListener(this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = AppConstants.COMPONENT_INSETS;
        gridBagLayout.setConstraints(this.plotColourBackgroundButton, gridBagConstraints);
        jPanel5.add(this.plotColourBackgroundButton);
        JPanel jPanel6 = new JPanel(gridBagLayout);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        gridBagLayout.setConstraints(jPanel6, gridBagConstraints);
        jPanel4.add(jPanel6);
        n = 0;
        FLabel fLabel13 = new FLabel(GRID_STR);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = AppConstants.COMPONENT_INSETS;
        gridBagLayout.setConstraints(fLabel13, gridBagConstraints);
        jPanel6.add(fLabel13);
        this.plotColourGridButton = new ColourSampleButton(appConfig.getPlotColourGrid());
        this.plotColourGridButton.setActionCommand("choosePlotColourGrid");
        this.plotColourGridButton.addActionListener(this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = AppConstants.COMPONENT_INSETS;
        gridBagLayout.setConstraints(this.plotColourGridButton, gridBagConstraints);
        jPanel6.add(this.plotColourGridButton);
        FLabel fLabel14 = new FLabel(AXIS_STR);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = AppConstants.COMPONENT_INSETS;
        gridBagLayout.setConstraints(fLabel14, gridBagConstraints);
        jPanel6.add(fLabel14);
        this.plotColourAxisButton = new ColourSampleButton(appConfig.getPlotColourAxis());
        this.plotColourAxisButton.setActionCommand("choosePlotColourAxis");
        this.plotColourAxisButton.addActionListener(this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = AppConstants.COMPONENT_INSETS;
        gridBagLayout.setConstraints(this.plotColourAxisButton, gridBagConstraints);
        jPanel6.add(this.plotColourAxisButton);
        FLabel fLabel15 = new FLabel(SCALE_MARKINGS_STR);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = AppConstants.COMPONENT_INSETS;
        gridBagLayout.setConstraints(fLabel15, gridBagConstraints);
        jPanel6.add(fLabel15);
        this.plotColourScaleMarkingsButton = new ColourSampleButton(appConfig.getPlotColourScale());
        this.plotColourScaleMarkingsButton.setActionCommand("choosePlotColourScale");
        this.plotColourScaleMarkingsButton.addActionListener(this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = AppConstants.COMPONENT_INSETS;
        gridBagLayout.setConstraints(this.plotColourScaleMarkingsButton, gridBagConstraints);
        jPanel6.add(this.plotColourScaleMarkingsButton);
        JPanel jPanel7 = new JPanel(gridBagLayout);
        jPanel7.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        n = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        jPanel7.add(jPanel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        gridBagLayout.setConstraints(jPanel4, gridBagConstraints);
        jPanel7.add(jPanel4);
        return jPanel7;
    }

    private JPanel getPanelFunction() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(gridBagLayout);
        GuiUtilities.setPaddedLineBorder(jPanel);
        int n = 0;
        AppConfig appConfig = AppConfig.getInstance();
        FLabel fLabel = new FLabel(DIRECTORY_STR);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = AppConstants.COMPONENT_INSETS;
        gridBagLayout.setConstraints(fLabel, gridBagConstraints);
        jPanel.add(fLabel);
        this.directoryField = new FPathnameField(appConfig.getFunctionPathname());
        PathnamePanel pathnamePanel = new PathnamePanel(this.directoryField, "chooseFunctionDirectory", this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = AppConstants.COMPONENT_INSETS;
        gridBagLayout.setConstraints(pathnamePanel, gridBagConstraints);
        jPanel.add(pathnamePanel);
        FLabel fLabel2 = new FLabel(LIST_SIZE_STR);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = AppConstants.COMPONENT_INSETS;
        gridBagLayout.setConstraints(fLabel2, gridBagConstraints);
        jPanel.add(fLabel2);
        JPanel jPanel2 = new JPanel(gridBagLayout);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = AppConstants.COMPONENT_INSETS;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        this.listWidthSpinner = new FIntegerSpinner(appConfig.getFunctionListSize().width, 8, 80, 2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagLayout.setConstraints(this.listWidthSpinner, gridBagConstraints);
        jPanel2.add(this.listWidthSpinner);
        FLabel fLabel3 = new FLabel(TIMES_STR);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        gridBagLayout.setConstraints(fLabel3, gridBagConstraints);
        jPanel2.add(fLabel3);
        this.listHeightSpinner = new FIntegerSpinner(appConfig.getFunctionListSize().height, 1, 20, 2);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        gridBagLayout.setConstraints(this.listHeightSpinner, gridBagConstraints);
        jPanel2.add(this.listHeightSpinner);
        FLabel fLabel4 = new FLabel(COLUMNS_BY_ROWS_STR);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        gridBagLayout.setConstraints(fLabel4, gridBagConstraints);
        jPanel2.add(fLabel4);
        int n2 = 20;
        JPanel jPanel3 = new JPanel(new GridLayout(2, n2 / 2, 6, 2));
        TitledBorder.setPaddedBorder(jPanel3, FUNCTION_COLOURS_STR);
        ColourButtonPanel[] colourButtonPanelArray = new ColourButtonPanel[n2];
        this.functionColourButtons = new JButton[n2];
        for (int i = 0; i < n2; ++i) {
            this.functionColourButtons[i] = new JButton(new ColourSampleIcon(20, 12));
            this.functionColourButtons[i].setMargin(FUNCTION_COLOUR_BUTTON_MARGINS);
            this.functionColourButtons[i].setForeground(appConfig.getFunctionColour(i));
            this.functionColourButtons[i].setActionCommand("chooseFunctionColour" + i);
            this.functionColourButtons[i].addActionListener(this);
            colourButtonPanelArray[i] = new ColourButtonPanel(i + 1, this.functionColourButtons[i]);
            jPanel3.add(colourButtonPanelArray[i]);
        }
        JPanel jPanel4 = new JPanel(gridBagLayout);
        jPanel4.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        jPanel4.add(jPanel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        jPanel4.add(jPanel3);
        return jPanel4;
    }

    private JPanel getPanelFonts() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(gridBagLayout);
        GuiUtilities.setPaddedLineBorder(jPanel);
        String[] stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        this.fontPanels = new FontPanel[AppFont.getNumFonts()];
        for (int i = 0; i < this.fontPanels.length; ++i) {
            FontEx fontEx = AppConfig.getInstance().getFont(i);
            this.fontPanels[i] = new FontPanel(fontEx, stringArray);
            int n = 0;
            FLabel fLabel = new FLabel(AppFont.values()[i].toString() + ":");
            gridBagConstraints.gridx = n++;
            gridBagConstraints.gridy = i;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 22;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = AppConstants.COMPONENT_INSETS;
            gridBagLayout.setConstraints(fLabel, gridBagConstraints);
            jPanel.add(fLabel);
            gridBagConstraints.gridx = n++;
            gridBagConstraints.gridy = i;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 21;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = AppConstants.COMPONENT_INSETS;
            gridBagLayout.setConstraints(this.fontPanels[i].nameComboBox, gridBagConstraints);
            jPanel.add(this.fontPanels[i].nameComboBox);
            gridBagConstraints.gridx = n++;
            gridBagConstraints.gridy = i;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 21;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = AppConstants.COMPONENT_INSETS;
            gridBagLayout.setConstraints(this.fontPanels[i].styleComboBox, gridBagConstraints);
            jPanel.add(this.fontPanels[i].styleComboBox);
            JPanel jPanel2 = new JPanel(gridBagLayout);
            gridBagConstraints.gridx = n++;
            gridBagConstraints.gridy = i;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 21;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = AppConstants.COMPONENT_INSETS;
            gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
            jPanel.add(jPanel2);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 21;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagLayout.setConstraints(this.fontPanels[i].sizeSpinner, gridBagConstraints);
            jPanel2.add(this.fontPanels[i].sizeSpinner);
            FLabel fLabel2 = new FLabel(PT_STR);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 21;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(0, 4, 0, 0);
            gridBagLayout.setConstraints(fLabel2, gridBagConstraints);
            jPanel2.add(fLabel2);
        }
        JPanel jPanel3 = new JPanel(gridBagLayout);
        jPanel3.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        jPanel3.add(jPanel);
        return jPanel3;
    }

    private void setFocus(Tab tab, JComponent jComponent) {
        this.tabbedPane.setSelectedIndex(tab.ordinal());
        GuiUtilities.setFocus(jComponent);
    }

    private void validatePreferencesGeneral() {
    }

    private void validatePreferencesAppearance() {
    }

    private void validatePreferencesPlot() throws AppException {
        try {
            if (this.fixedPointLowerLimitSpinner.getIntValue() > this.fixedPointUpperLimitSpinner.getIntValue()) {
                throw new AppException(ErrorId.FIXED_POINT_LIMITS_OUT_OF_ORDER);
            }
        }
        catch (AppException appException) {
            this.setFocus(Tab.PLOT, this.fixedPointUpperLimitSpinner);
            throw appException;
        }
    }

    private void validateDirectory(File file) throws AppException {
        try {
            if (!file.exists()) {
                throw new FileException((AppException.Id)ErrorId.DIRECTORY_DOES_NOT_EXIST, file);
            }
            if (!file.isDirectory()) {
                throw new FileException((AppException.Id)ErrorId.NOT_A_DIRECTORY, file);
            }
        }
        catch (SecurityException securityException) {
            throw new FileException((AppException.Id)ErrorId.DIRECTORY_ACCESS_NOT_PERMITTED, file, securityException);
        }
    }

    private void validatePreferencesFunction() throws AppException {
        try {
            if (!this.directoryField.isEmpty()) {
                this.validateDirectory(this.directoryField.getFile());
            }
        }
        catch (AppException appException) {
            this.setFocus(Tab.FUNCTION, this.directoryField);
            throw appException;
        }
    }

    private void validatePreferencesFonts() {
    }

    private void setPreferencesGeneral() {
        AppConfig appConfig = AppConfig.getInstance();
        appConfig.setDefaultFileKind((FileKind)this.defaultFileKindComboBox.getSelectedItem());
        appConfig.setNewDocumentOnStartup(this.newDocOnStartupComboBox.getSelectedValue());
        appConfig.setSaveFunctionColours((NoYesAsk)this.saveFunctionColoursComboBox.getSelectedItem());
        appConfig.setShowUnixPathnames(this.showUnixPathnamesComboBox.getSelectedValue());
        appConfig.setMainWindowLocation(this.saveMainWindowLocationComboBox.getSelectedValue() ? new Point() : null);
    }

    private void setPreferencesAppearance() {
        AppConfig appConfig = AppConfig.getInstance();
        if (this.lookAndFeelComboBox.isEnabled() && this.lookAndFeelComboBox.getSelectedIndex() >= 0) {
            appConfig.setLookAndFeel(UIManager.getInstalledLookAndFeels()[this.lookAndFeelComboBox.getSelectedIndex()].getName());
        }
        appConfig.setOrientationByLocale(this.orientationByLocaleComboBox.getSelectedValue());
        appConfig.setTextAntialiasing((TextRendering.Antialiasing)this.textAntialiasingComboBox.getSelectedItem());
        appConfig.setBackgroundColour(this.backgroundColourCheckBox.isSelected() ? this.backgroundColourButton.getForeground() : null);
    }

    private void setPreferencesPlot() {
        AppConfig appConfig = AppConfig.getInstance();
        appConfig.setPlotSize(new Dimension(this.plotWidthSpinner.getIntValue(), this.plotHeightSpinner.getIntValue()));
        appConfig.setShowGrid(this.showGridComboBox.getSelectedValue());
        appConfig.setNumFractionDigits(this.numFractionDigitsSpinner.getIntValue());
        appConfig.setNumYScaleDigits(this.numYScaleDigitsSpinner.getIntValue());
        appConfig.setFixedPointExponentRange(new IntegerRange(this.fixedPointLowerLimitSpinner.getIntValue(), this.fixedPointUpperLimitSpinner.getIntValue()));
        appConfig.setNormaliseScientificNotation(this.normaliseSciNotationComboBox.getSelectedValue());
        appConfig.setTruncateXScaleText(this.truncateXScaleTextComboBox.getSelectedValue());
        appConfig.setPlotColourFocusedBorder(this.plotColourFocusedBorderButton.getForeground());
        appConfig.setPlotColourImageMargin(this.plotColourImageMarginButton.getForeground());
        appConfig.setPlotColourBackground(this.plotColourBackgroundButton.getForeground());
        appConfig.setPlotColourGrid(this.plotColourGridButton.getForeground());
        appConfig.setPlotColourAxis(this.plotColourAxisButton.getForeground());
        appConfig.setPlotColourScale(this.plotColourScaleMarkingsButton.getForeground());
    }

    private void setPreferencesFunction() {
        AppConfig appConfig = AppConfig.getInstance();
        appConfig.setFunctionPathname(this.directoryField.getText());
        appConfig.setFunctionListSize(new Dimension(this.listWidthSpinner.getIntValue(), this.listHeightSpinner.getIntValue()));
        for (int i = 0; i < this.functionColourButtons.length; ++i) {
            appConfig.setFunctionColour(i, this.functionColourButtons[i].getForeground());
        }
    }

    private void setPreferencesFonts() {
        for (int i = 0; i < this.fontPanels.length; ++i) {
            if (this.fontPanels[i].nameComboBox.getSelectedIndex() < 0) continue;
            AppConfig.getInstance().setFont(i, this.fontPanels[i].getFont());
        }
    }

    private class WindowEventHandler
    extends WindowAdapter {
        private WindowEventHandler() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            PreferencesDialog.this.doClose();
        }
    }

    private static class FontPanel {
        private static final int MIN_SIZE = 0;
        private static final int MAX_SIZE = 99;
        private static final int SIZE_FIELD_LENGTH = 2;
        private static final String DEFAULT_FONT_STR = "<default font>";
        JComboBox nameComboBox = new FComboBox();
        JComboBox styleComboBox;
        SizeSpinner sizeSpinner;

        private FontPanel(FontEx fontEx, String[] stringArray) {
            this.nameComboBox.addItem(DEFAULT_FONT_STR);
            for (String string : stringArray) {
                this.nameComboBox.addItem(string);
            }
            this.nameComboBox.setSelectedIndex(Util.indexOf(stringArray, fontEx.getName()) + 1);
            this.styleComboBox = new FComboBox(FontEx.Style.values());
            this.styleComboBox.setSelectedItem(fontEx.getStyle());
            this.sizeSpinner = new SizeSpinner(fontEx.getSize());
        }

        public FontEx getFont() {
            String string = this.nameComboBox.getSelectedIndex() <= 0 ? null : (String)this.nameComboBox.getSelectedItem();
            return new FontEx(string, (FontEx.Style)this.styleComboBox.getSelectedItem(), this.sizeSpinner.getIntValue());
        }

        private static class SizeSpinner
        extends IntegerSpinner {
            private SizeSpinner(int n) {
                super(n, 0, 99, 2);
                AppFont.TEXT_FIELD.apply(this);
            }

            @Override
            protected int getEditorValue() throws NumberFormatException {
                IntegerValueField integerValueField = (IntegerValueField)this.getEditor();
                return integerValueField.isEmpty() ? 0 : integerValueField.getValue();
            }

            @Override
            protected void setEditorValue(int n) {
                IntegerValueField integerValueField = (IntegerValueField)this.getEditor();
                if (n == 0) {
                    integerValueField.setText(null);
                } else {
                    integerValueField.setValue(n);
                }
            }
        }
    }

    private static class ColourButtonPanel
    extends JPanel {
        private ColourButtonPanel(int n, JButton jButton) {
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout);
            FLabel fLabel = new FLabel(Integer.toString(n));
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 22;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 4);
            gridBagLayout.setConstraints(fLabel, gridBagConstraints);
            this.add(fLabel);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 21;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagLayout.setConstraints(jButton, gridBagConstraints);
            this.add(jButton);
        }
    }

    private static class ColourSampleButton
    extends JButton {
        private static final int ICON_WIDTH = 32;
        private static final int ICON_HEIGHT = 16;
        private static final Insets MARGINS = new Insets(2, 2, 2, 2);

        private ColourSampleButton(Color color) {
            super(new ColourSampleIcon(32, 16));
            this.setMargin(MARGINS);
            this.setForeground(color);
        }
    }

    private static enum ErrorId implements AppException.Id
    {
        DIRECTORY_DOES_NOT_EXIST("The specified directory does not exist."),
        NOT_A_DIRECTORY("The pathname does not specify a directory."),
        DIRECTORY_ACCESS_NOT_PERMITTED("Access to the directory was not permitted."),
        FIXED_POINT_LIMITS_OUT_OF_ORDER("The upper limit of the fixed-point exponent range is less than the lower limit.");

        private String message;

        private ErrorId(String string2) {
            this.message = string2;
        }

        @Override
        public String getMessage() {
            return this.message;
        }
    }

    private static interface Command {
        public static final String ENABLE_BACKGROUND_COLOUR = "enableBackgroundColour";
        public static final String CHOOSE_BACKGROUND_COLOUR = "chooseBackgroundColour";
        public static final String CHOOSE_PLOT_COLOUR_FOCUSED_BORDER = "choosePlotColourFocusedBorder";
        public static final String CHOOSE_PLOT_COLOUR_IMAGE_MARGIN = "choosePlotColourImageMargin";
        public static final String CHOOSE_PLOT_COLOUR_BACKGROUND = "choosePlotColourBackground";
        public static final String CHOOSE_PLOT_COLOUR_GRID = "choosePlotColourGrid";
        public static final String CHOOSE_PLOT_COLOUR_AXIS = "choosePlotColourAxis";
        public static final String CHOOSE_PLOT_COLOUR_SCALE = "choosePlotColourScale";
        public static final String CHOOSE_FUNCTION_DIRECTORY = "chooseFunctionDirectory";
        public static final String CHOOSE_FUNCTION_COLOUR = "chooseFunctionColour";
        public static final String SAVE_CONFIGURATION = "saveConfiguration";
        public static final String ACCEPT = "accept";
        public static final String CLOSE = "close";
    }

    private static enum Tab {
        GENERAL,
        APPEARANCE,
        PLOT,
        FUNCTION,
        FONTS;

    }
}

