/*
 * Decompiled with CFR 0.152.
 */
package functionplotter;

import functionplotter.AppConfig;
import functionplotter.AppFont;
import functionplotter.Expression;
import functionplotter.Function;
import functionplotter.FunctionDocument;
import functionplotter.PlotInterval;
import functionplotter.SurrogateMinus;
import functionplotter.gui.Colours;
import functionplotter.gui.CrosshairCursor;
import functionplotter.gui.GuiUtilities;
import functionplotter.gui.TextRendering;
import functionplotter.util.IntegerRange;
import functionplotter.util.StringUtilities;
import functionplotter.util.TextUtilities;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class PlotPanel
extends JComponent
implements FocusListener,
MouseListener,
MouseMotionListener {
    public static final int MIN_PLOT_WIDTH = 128;
    public static final int MAX_PLOT_WIDTH = 2048;
    public static final int MIN_PLOT_HEIGHT = 128;
    public static final int MAX_PLOT_HEIGHT = 2048;
    public static final int MIN_NUM_Y_SCALE_DIGITS = 4;
    public static final int MAX_NUM_Y_SCALE_DIGITS = 20;
    private static final int LEFT_MARGIN = 4;
    private static final int RIGHT_MARGIN = 4;
    private static final int TOP_MARGIN = 8;
    private static final int BOTTOM_MARGIN = 4;
    private static final int SCALE_LINE_LENGTH = 4;
    private static final int X_SCALE_TOP_MARGIN = 1;
    private static final int X_SCALE_GAP = 3;
    private static final int Y_SCALE_LEFT_MARGIN = 3;
    private static final int MIN_PIXELS_PER_DIVISION = 32;
    private static final double SCROLL_FACTOR = 0.5;
    private static final double ONE_OVER_LOG_10 = 1.0 / Math.log(10.0);
    private static final String ZERO_STR = "0";
    private static final Color POP_UP_TEXT_COLOUR = Color.BLACK;
    private static final Color POP_UP_BORDER_COLOUR = Colours.LINE_BORDER;
    private static int numYScaleDigits;
    private FunctionDocument document;
    private int panelWidth;
    private int panelHeight;
    private int maxYScaleStrWidth;
    private Insets borderInsets;
    private Rectangle plotRect;
    private PlotParams xParams;
    private PlotParams yParams;
    private List<ChangeListener> changeListeners;
    private ChangeEvent changeEvent;
    private char minusChar;
    private boolean gridVisible;
    private boolean drawingImage;
    private List<ScaleText> scaleTexts;
    private Popup scalePopUp;

    public PlotPanel(FunctionDocument functionDocument, int n, int n2, boolean bl) {
        this.setBorder(false);
        this.borderInsets = this.getBorder().getBorderInsets(this);
        AppFont.PLOT.apply(this);
        if (numYScaleDigits == 0) {
            numYScaleDigits = AppConfig.getInstance().getNumYScaleDigits();
        }
        this.setCursor(false);
        this.document = functionDocument;
        this.gridVisible = bl;
        this.minusChar = SurrogateMinus.getMinusChar(this.getFont());
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        char[] cArray = StringUtilities.createCharArray('0', numYScaleDigits);
        this.maxYScaleStrWidth = fontMetrics.charsWidth(cArray, 0, cArray.length);
        int n3 = 3 + this.maxYScaleStrWidth + 4;
        int n4 = 5 + fontMetrics.getAscent() + fontMetrics.getDescent();
        this.plotRect = new Rectangle(this.borderInsets.left + 4 + n3, this.borderInsets.top + 8, n, n2);
        this.panelWidth = this.borderInsets.left + 4 + n3 + n + this.maxYScaleStrWidth / 2 + 4 + this.borderInsets.right;
        this.panelHeight = this.borderInsets.top + 8 + n2 + n4 + 4 + this.borderInsets.bottom;
        this.xParams = new PlotParams(functionDocument.getXInterval(), n);
        this.yParams = new PlotParams(functionDocument.getYInterval(), n2);
        this.changeListeners = new ArrayList<ChangeListener>();
        this.scaleTexts = new ArrayList<ScaleText>();
        this.setOpaque(true);
        this.setFocusable(true);
        this.addFocusListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.setBorder(true);
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.setBorder(false);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (mouseEvent.getComponent() != this && this.scalePopUp != null) {
            this.scalePopUp.hide();
            this.scalePopUp = null;
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.requestFocusInWindow();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.scalePopUp == null) {
            for (ScaleText scaleText : this.scaleTexts) {
                String string = scaleText.getText(mouseEvent.getPoint());
                if (string == null) continue;
                PopUpComponent popUpComponent = new PopUpComponent(string);
                popUpComponent.addMouseListener(this);
                int n = scaleText.markX;
                if (n != 0) {
                    n -= popUpComponent.getPreferredSize().width / 2;
                }
                Point point = new Point(n, ((ScaleText)scaleText).rect.y);
                SwingUtilities.convertPointToScreen(point, this);
                this.scalePopUp = PopupFactory.getSharedInstance().getPopup(this, popUpComponent, point.x, point.y);
                this.scalePopUp.show();
                break;
            }
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(this.panelWidth, this.panelHeight);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        int n;
        String string;
        Object object;
        int n2;
        int n3;
        graphics = graphics.create();
        Rectangle rectangle = graphics.getClipBounds();
        AppConfig appConfig = AppConfig.getInstance();
        graphics.setColor(this.drawingImage ? appConfig.getPlotColourImageMargin() : this.getBackground());
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setColor(appConfig.getPlotColourBackground());
        graphics.fillRect(this.plotRect.x, this.plotRect.y, this.plotRect.width, this.plotRect.height);
        TextRendering.setHints((Graphics2D)graphics);
        int n4 = appConfig.getNumFractionDigits();
        IntegerRange integerRange = appConfig.getFixedPointExponentRange();
        boolean bl = !appConfig.isNormaliseScientificNotation();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n5 = fontMetrics.getAscent();
        int n6 = fontMetrics.getAscent() + fontMetrics.getDescent();
        this.scaleTexts.clear();
        int n7 = 0;
        int n8 = -1;
        Object object2 = null;
        for (n3 = this.xParams.divisionOffset; n3 < this.plotRect.width; n3 += this.xParams.pixelsPerDivision) {
            n2 = this.plotRect.x + n3;
            double d = this.xParams.start + (double)n3 * this.xParams.pixelDelta;
            object = PlotInterval.doubleToString(d, n4, integerRange, bl, this.xParams.intervalExponent);
            if (Math.abs(d) < 0.5 * this.xParams.pixelDelta) {
                object = ZERO_STR;
                n8 = n2;
            } else if (this.gridVisible) {
                graphics.setColor(appConfig.getPlotColourGrid());
                graphics.drawLine(n2, this.plotRect.y, n2, this.plotRect.y + this.plotRect.height - 1);
            }
            graphics.setColor(appConfig.getPlotColourScale());
            graphics.drawLine(n2, this.plotRect.y + this.plotRect.height, n2, this.plotRect.y + this.plotRect.height + 4 - 1);
            if (!((String)object).equals(object2)) {
                string = SurrogateMinus.minusToSurrogate((String)object, this.minusChar);
                int n9 = fontMetrics.stringWidth(string);
                int n10 = n2 - n9 / 2;
                n = this.plotRect.y + this.plotRect.height + 4 + 1 + n5;
                if (n10 < n7) {
                    String string2 = null;
                    if (appConfig.isTruncateXScaleText()) {
                        string2 = TextUtilities.getLimitedWidthString(string, fontMetrics, 2 * (n2 - n7), true);
                        n9 = fontMetrics.stringWidth(string2);
                    } else {
                        n9 = 2 * (n2 - n7);
                    }
                    n10 = n2 - n9 / 2;
                    this.scaleTexts.add(new ScaleText(string, n10, n - n5, n9, n6, n2));
                    string = string2;
                }
                if (string != null) {
                    graphics.drawString(string, n10, n);
                    n7 = n10 + n9 + 3;
                }
            }
            object2 = object;
        }
        n2 = -1;
        object2 = null;
        for (n3 = this.yParams.divisionOffset; n3 < this.plotRect.height; n3 += this.yParams.pixelsPerDivision) {
            int n11 = this.plotRect.y + (this.plotRect.height - 1) - n3;
            double d = this.yParams.start + (double)n3 * this.yParams.pixelDelta;
            string = PlotInterval.doubleToString(d, n4, integerRange, bl, this.yParams.intervalExponent);
            if (Math.abs(d) < 0.5 * this.yParams.pixelDelta) {
                string = ZERO_STR;
                n2 = n11;
            } else if (this.gridVisible) {
                graphics.setColor(appConfig.getPlotColourGrid());
                graphics.drawLine(this.plotRect.x, n11, this.plotRect.x + this.plotRect.width - 1, n11);
            }
            graphics.setColor(appConfig.getPlotColourScale());
            graphics.drawLine(this.plotRect.x - 4, n11, this.plotRect.x - 1, n11);
            if (!string.equals(object2)) {
                String string3 = SurrogateMinus.minusToSurrogate(string, this.minusChar);
                String string4 = TextUtilities.getLimitedWidthString(string3, fontMetrics, this.maxYScaleStrWidth, true);
                n = fontMetrics.stringWidth(string4);
                int n12 = this.plotRect.x - (n + 3 + 4);
                int n13 = n11 + n5 / 2;
                if (string4 != string3) {
                    this.scaleTexts.add(new ScaleText(string3, n12, n13 - n5, n, n6, 0));
                }
                graphics.drawString(string4, n12, n13);
            }
            object2 = string;
        }
        graphics.setColor(appConfig.getPlotColourAxis());
        if (n8 >= 0) {
            graphics.drawLine(n8, this.plotRect.y, n8, this.plotRect.y + this.plotRect.height - 1);
        }
        if (n2 >= 0) {
            graphics.drawLine(this.plotRect.x, n2, this.plotRect.x + this.plotRect.width - 1, n2);
        }
        Graphics graphics2 = graphics.create(this.plotRect.x, this.plotRect.y, this.plotRect.width, this.plotRect.height);
        for (int i = this.document.getNumFunctions() - 1; i >= 0; --i) {
            object = this.document.getFunction(i);
            if (!((Function)object).isVisible()) continue;
            graphics2.setColor(((Function)object).getColour());
            this.drawExpression(graphics2, ((Function)object).getExpression(), 0, this.plotRect.width);
        }
    }

    public boolean isGridVisible() {
        return this.gridVisible;
    }

    public Point2D.Double pointToCoords(Point point) {
        Point2D.Double double_ = null;
        if (point.x >= this.plotRect.x && point.x < this.plotRect.x + this.plotRect.width && point.y >= this.plotRect.y && point.y < this.plotRect.y + this.plotRect.height) {
            double_ = new Point2D.Double(this.xParams.start + (double)(point.x - this.plotRect.x) * this.xParams.pixelDelta, this.yParams.start + (double)(this.plotRect.y + this.plotRect.height - 1 - point.y) * this.yParams.pixelDelta);
        }
        return double_;
    }

    public double getXScrollIncrement() {
        return this.xParams.divisionDelta * 0.5;
    }

    public double getXScrollIncrement(int n) {
        return (double)((n << 1) / this.xParams.pixelsPerDivision) * this.getXScrollIncrement();
    }

    public double getYScrollIncrement() {
        return this.yParams.divisionDelta * 0.5;
    }

    public double getYScrollIncrement(int n) {
        return (double)((n << 1) / this.yParams.pixelsPerDivision) * this.getYScrollIncrement();
    }

    public void setXInterval(PlotInterval plotInterval) {
        PlotParams plotParams = new PlotParams(plotInterval, this.plotRect.width);
        if (!this.xParams.equals(plotParams)) {
            this.xParams = plotParams;
            this.repaint();
            this.fireStateChanged();
        }
    }

    public void setYInterval(PlotInterval plotInterval) {
        PlotParams plotParams = new PlotParams(plotInterval, this.plotRect.height);
        if (!this.yParams.equals(plotParams)) {
            this.yParams = plotParams;
            this.repaint();
            this.fireStateChanged();
        }
    }

    public void setIntervals(PlotInterval plotInterval, PlotInterval plotInterval2) {
        PlotParams plotParams = new PlotParams(plotInterval, this.plotRect.width);
        PlotParams plotParams2 = new PlotParams(plotInterval2, this.plotRect.height);
        if (!this.xParams.equals(plotParams) || !this.yParams.equals(plotParams2)) {
            this.xParams = plotParams;
            this.yParams = plotParams2;
            this.repaint();
            this.fireStateChanged();
        }
    }

    public void setCursor(boolean bl) {
        this.setCursor(bl ? Cursor.getPredefinedCursor(13) : CrosshairCursor.getCursor());
    }

    public void setGridVisible(boolean bl) {
        if (this.gridVisible != bl) {
            this.gridVisible = bl;
            this.repaint();
        }
    }

    public void drawPanel(Graphics graphics) {
        graphics.setFont(this.getFont());
        graphics.setClip(0, 0, this.panelWidth, this.panelHeight);
        this.drawingImage = true;
        this.paintComponent(graphics);
        this.drawingImage = false;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(changeListener);
    }

    private void fireStateChanged() {
        for (int i = this.changeListeners.size() - 1; i >= 0; --i) {
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            this.changeListeners.get(i).stateChanged(this.changeEvent);
        }
    }

    private void drawExpression(Graphics graphics, Expression expression, int n, int n2) {
        double d = 0.0;
        double d2 = Double.NaN;
        int n3 = 0;
        for (int i = n - 1; i <= n2; ++i) {
            double d3 = this.xParams.start + (double)i * this.xParams.pixelDelta;
            double d4 = expression.evaluate(d3);
            if (!Double.isNaN(d4)) {
                double d5;
                int n4 = (int)Math.min(Math.max(-1073741824L, Math.round((d4 - this.yParams.start) / this.yParams.pixelDelta)), 0x3FFFFFFFL);
                if (!Double.isNaN(d2) && ((d5 = expression.evaluate(0.5 * (d + d3))) >= d2 && d5 <= d4 || d5 >= d4 && d5 <= d2 || d4 == d2)) {
                    graphics.drawLine(i - 1, this.plotRect.height - 1 - n3, i, this.plotRect.height - 1 - n4);
                }
                n3 = n4;
            }
            d = d3;
            d2 = d4;
        }
    }

    private void setBorder(boolean bl) {
        if (bl) {
            this.setBorder(BorderFactory.createMatteBorder(this.borderInsets.top, this.borderInsets.left, this.borderInsets.bottom, this.borderInsets.right, AppConfig.getInstance().getPlotColourFocusedBorder()));
        } else {
            GuiUtilities.setPaddedLineBorder((JComponent)this, 1);
        }
    }

    private class PopUpComponent
    extends JComponent {
        private static final int VERTICAL_MARGIN = 2;
        private static final int HORIZONTAL_MARGIN = 3;
        private String text;

        private PopUpComponent(String string) {
            this.text = string;
            AppFont.PLOT.apply(this);
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            this.setPreferredSize(new Dimension(6 + fontMetrics.stringWidth(string), 4 + fontMetrics.getAscent() + fontMetrics.getDescent()));
            this.setOpaque(true);
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            graphics = graphics.create();
            int n = this.getWidth();
            int n2 = this.getHeight();
            graphics.setColor(PlotPanel.this.getBackground());
            graphics.fillRect(0, 0, n, n2);
            TextRendering.setHints((Graphics2D)graphics);
            graphics.setColor(POP_UP_TEXT_COLOUR);
            graphics.drawString(this.text, 3, GuiUtilities.getBaselineOffset(n2, graphics.getFontMetrics()));
            graphics.setColor(POP_UP_BORDER_COLOUR);
            graphics.drawRect(0, 0, n - 1, n2 - 1);
        }
    }

    private static class ScaleText {
        private String text;
        private Rectangle rect;
        private int markX;

        private ScaleText(String string, int n, int n2, int n3, int n4, int n5) {
            this.text = string;
            this.rect = new Rectangle(n, n2 - 2, n3, n4 + 4);
            this.markX = n5;
        }

        private String getText(Point point) {
            return this.rect.contains(point) ? this.text : null;
        }
    }

    private static class PlotParams {
        private double start;
        private double pixelDelta;
        private int pixelsPerDivision;
        private int divisionOffset;
        private double divisionDelta;
        private int intervalExponent;

        private PlotParams(PlotInterval plotInterval, int n) {
            this.pixelDelta = plotInterval.getInterval() / (double)n;
            this.divisionDelta = this.pixelDelta * 32.0;
            int n2 = (int)Math.floor(Math.log(this.divisionDelta) * ONE_OVER_LOG_10);
            this.divisionDelta *= Math.pow(10.0, -n2);
            int n3 = 1;
            if (this.divisionDelta > 1.0078125) {
                if (this.divisionDelta <= 2.0078125) {
                    n3 = 2;
                } else if (this.divisionDelta <= 5.0078125) {
                    n3 = 5;
                } else {
                    ++n2;
                }
            }
            this.divisionDelta = (double)n3 * Math.pow(10.0, n2);
            this.pixelsPerDivision = (int)(this.divisionDelta / this.pixelDelta);
            this.pixelDelta = this.divisionDelta / (double)this.pixelsPerDivision;
            this.start = Math.floor(plotInterval.getLowerEndpoint() / this.pixelDelta);
            this.divisionOffset = this.pixelsPerDivision - (int)this.start % this.pixelsPerDivision;
            if (this.divisionOffset >= this.pixelsPerDivision) {
                this.divisionOffset -= this.pixelsPerDivision;
            }
            this.start *= this.pixelDelta;
            this.intervalExponent = plotInterval.getExponent();
        }

        public boolean equals(PlotParams plotParams) {
            return plotParams != null && this.start == plotParams.start && this.pixelDelta == plotParams.pixelDelta && this.pixelsPerDivision == plotParams.pixelsPerDivision && this.divisionOffset == plotParams.divisionOffset && this.divisionDelta == plotParams.divisionDelta && this.intervalExponent == plotParams.intervalExponent;
        }
    }
}

