/*
 * Decompiled with CFR 0.152.
 */
package functionplotter;

import functionplotter.App;
import functionplotter.AppCommand;
import functionplotter.AppConfig;
import functionplotter.AppIcon;
import functionplotter.FunctionDocument;
import functionplotter.FunctionView;
import functionplotter.exception.AppException;
import functionplotter.gui.FCheckBoxMenuItem;
import functionplotter.gui.FMenu;
import functionplotter.gui.FMenuItem;
import functionplotter.gui.GuiUtilities;
import functionplotter.gui.TabbedPanel;
import functionplotter.util.DataImporter;
import java.awt.Dimension;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

class MainWindow
extends JFrame
implements ChangeListener,
MenuListener,
WindowFocusListener {
    private static final String FILE_STR = "File";
    private static final String EDIT_STR = "Edit";
    private static final String VIEW_STR = "View";
    private static final String OPTIONS_STR = "Options";
    private Dimension contentPaneSize;
    private JMenu fileMenu;
    private JMenu editMenu;
    private JMenu viewMenu;
    private JMenu optionsMenu;
    private TabbedPanel tabbedPanel;

    public MainWindow() {
        this.setIconImages(AppIcon.getAppIconImages());
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.setBorder(null);
        this.fileMenu = new FMenu(FILE_STR, 70);
        this.fileMenu.addMenuListener(this);
        this.fileMenu.add(new FMenuItem((Action)AppCommand.NEW_FILE, 78));
        this.fileMenu.add(new FMenuItem((Action)AppCommand.OPEN_FILE, 79));
        this.fileMenu.add(new FMenuItem((Action)AppCommand.RELOAD_FILE, 82));
        this.fileMenu.add(new FMenuItem((Action)AppCommand.CLOSE_FILE, 67));
        this.fileMenu.add(new FMenuItem((Action)AppCommand.CLOSE_ALL_FILES, 76));
        this.fileMenu.addSeparator();
        this.fileMenu.add(new FMenuItem((Action)AppCommand.SAVE_FILE, 83));
        this.fileMenu.add(new FMenuItem((Action)AppCommand.SAVE_FILE_AS, 65));
        this.fileMenu.addSeparator();
        this.fileMenu.add(new FMenuItem((Action)AppCommand.EXPORT_IMAGE, 69));
        this.fileMenu.addSeparator();
        this.fileMenu.add(new FMenuItem((Action)AppCommand.EXIT, 88));
        jMenuBar.add(this.fileMenu);
        this.editMenu = new FMenu(EDIT_STR, 69);
        this.editMenu.addMenuListener(this);
        this.editMenu.add(new FMenuItem((Action)FunctionDocument.Command.UNDO, 85));
        this.editMenu.add(new FMenuItem((Action)FunctionDocument.Command.REDO, 82));
        this.editMenu.add(new FMenuItem((Action)FunctionDocument.Command.CLEAR_EDIT_LIST, 76));
        this.editMenu.addSeparator();
        this.editMenu.add(new FMenuItem((Action)FunctionDocument.Command.EDIT_COMMENT, 67));
        this.editMenu.addSeparator();
        this.editMenu.add(new FMenuItem((Action)FunctionDocument.Command.REVERSE_FUNCTIONS, 86));
        this.editMenu.add(new FMenuItem((Action)AppCommand.COPY_INTERVALS, 73));
        jMenuBar.add(this.editMenu);
        this.viewMenu = new FMenu(VIEW_STR, 86);
        this.viewMenu.addMenuListener(this);
        this.viewMenu.add(new FCheckBoxMenuItem((Action)FunctionDocument.Command.SHOW_GRID, 71));
        jMenuBar.add(this.viewMenu);
        this.optionsMenu = new FMenu(OPTIONS_STR, 79);
        this.optionsMenu.addMenuListener(this);
        this.optionsMenu.add(new FMenuItem((Action)AppCommand.EDIT_PREFERENCES, 80));
        this.optionsMenu.add(new FCheckBoxMenuItem((Action)AppCommand.SHOW_FULL_PATHNAMES, 70));
        jMenuBar.add(this.optionsMenu);
        this.setJMenuBar(jMenuBar);
        this.tabbedPanel = new TabbedPanel();
        this.tabbedPanel.setIgnoreCase(true);
        App.applyOrientationByLocale(this.tabbedPanel);
        this.tabbedPanel.addChangeListener(this);
        this.addView(new String(), null, new FunctionView(new FunctionDocument()));
        this.tabbedPanel.setPreferredSize(this.tabbedPanel.getPreferredSize());
        this.tabbedPanel.setTransferHandler(new FileTransferHandler());
        App.applyOrientationByLocale(this);
        this.setContentPane(this.tabbedPanel);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowEventHandler());
        this.addWindowFocusListener(this);
        this.setResizable(false);
        this.pack();
        AppConfig appConfig = AppConfig.getInstance();
        if (appConfig.isMainWindowLocation()) {
            this.setLocation(GuiUtilities.getLocationWithinScreen(this, appConfig.getMainWindowLocation()));
        }
        this.contentPaneSize = this.tabbedPanel.getSize();
        this.removeView(0);
        this.updateTitleAndMenus();
        this.setVisible(true);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.tabbedPanel && this.isVisible()) {
            this.updateTitleAndMenus();
        }
    }

    @Override
    public void menuCanceled(MenuEvent menuEvent) {
    }

    @Override
    public void menuDeselected(MenuEvent menuEvent) {
    }

    @Override
    public void menuSelected(MenuEvent menuEvent) {
        Object object = menuEvent.getSource();
        if (object == this.fileMenu) {
            this.updateFileMenu();
        } else if (object == this.editMenu) {
            this.updateEditMenu();
        } else if (object == this.viewMenu) {
            this.updateViewMenu();
        } else if (object == this.optionsMenu) {
            this.updateOptionsMenu();
        }
    }

    @Override
    public void windowGainedFocus(WindowEvent windowEvent) {
        FunctionView functionView = App.getInstance().getView();
        if (functionView != null) {
            functionView.showMouseCursorCoords(true);
        }
    }

    @Override
    public void windowLostFocus(WindowEvent windowEvent) {
        FunctionView functionView = App.getInstance().getView();
        if (functionView != null) {
            functionView.showMouseCursorCoords(false);
        }
    }

    public int getTabIndex() {
        return this.tabbedPanel.getSelectedIndex();
    }

    public void addView(String string, String string2, FunctionView functionView) {
        this.tabbedPanel.addComponent(string, new CloseAction(), functionView);
        functionView.setDefaultFocus();
        int n = this.tabbedPanel.getNumTabs() - 1;
        this.tabbedPanel.setToolTipText(n, string2);
        this.tabbedPanel.setSelectedIndex(n);
    }

    public void removeView(int n) {
        this.tabbedPanel.removeComponent(n);
    }

    public void setView(int n, FunctionView functionView) {
        this.tabbedPanel.setComponent(n, functionView);
    }

    public void selectView(int n) {
        this.tabbedPanel.setSelectedIndex(n);
    }

    public void setTabText(int n, String string, String string2) {
        this.tabbedPanel.setTitle(n, string);
        this.tabbedPanel.setToolTipText(n, string2);
    }

    public void updateTitleAndMenus() {
        this.updateTitle();
        this.updateMenus();
    }

    private void updateTitle() {
        FunctionDocument functionDocument = App.getInstance().getDocument();
        boolean bl = AppConfig.getInstance().isShowFullPathnames();
        this.setTitle(functionDocument == null ? "Function Plotter " + App.getInstance().getVersionString() : "FuncPlotter  [" + functionDocument.getTitleString(bl) + "]");
    }

    private void updateMenus() {
        this.updateFileMenu();
        this.updateEditMenu();
        this.updateViewMenu();
        this.updateOptionsMenu();
    }

    private void updateFileMenu() {
        this.updateAppCommands();
    }

    private void updateEditMenu() {
        this.editMenu.setEnabled(App.getInstance().hasDocuments());
        this.updateAppCommands();
        this.updateDocumentCommands();
    }

    private void updateViewMenu() {
        this.viewMenu.setEnabled(App.getInstance().hasDocuments());
        this.updateDocumentCommands();
    }

    private void updateOptionsMenu() {
        this.updateAppCommands();
    }

    private void updateAppCommands() {
        App.getInstance().updateCommands();
    }

    private void updateDocumentCommands() {
        FunctionDocument functionDocument = App.getInstance().getDocument();
        if (functionDocument == null) {
            FunctionDocument.Command.setAllEnabled(false);
        } else {
            functionDocument.updateCommands();
        }
    }

    private class WindowEventHandler
    extends WindowAdapter {
        private WindowEventHandler() {
        }

        @Override
        public void windowOpened(WindowEvent windowEvent) {
            MainWindow.this.tabbedPanel.setSize(MainWindow.this.contentPaneSize);
            MainWindow.this.tabbedPanel.revalidate();
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            AppCommand.EXIT.execute();
        }
    }

    private class FileTransferHandler
    extends TransferHandler
    implements Runnable {
        @Override
        public void run() {
            AppCommand.IMPORT_FILES.execute();
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport transferSupport) {
            return DataImporter.isFileList(transferSupport.getDataFlavors());
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport transferSupport) {
            if (this.canImport(transferSupport)) {
                try {
                    try {
                        File[] fileArray = DataImporter.getFiles(transferSupport.getTransferable());
                        if (fileArray != null) {
                            MainWindow.this.toFront();
                            AppCommand.IMPORT_FILES.putValue("files", fileArray);
                            SwingUtilities.invokeLater(this);
                            return true;
                        }
                    }
                    catch (UnsupportedFlavorException unsupportedFlavorException) {
                        throw new AppException(ErrorId.FILE_TRANSFER_NOT_SUPPORTED);
                    }
                    catch (IOException iOException) {
                        throw new AppException(ErrorId.ERROR_TRANSFERRING_DATA);
                    }
                }
                catch (AppException appException) {
                    App.getInstance().showErrorMessage("FuncPlotter", appException);
                }
            }
            return false;
        }
    }

    private static class CloseAction
    extends AbstractAction {
        private CloseAction() {
            this.putValue("ActionCommandKey", new String());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            App.getInstance().closeDocument(Integer.parseInt(actionEvent.getActionCommand()));
        }
    }

    private static enum ErrorId implements AppException.Id
    {
        FILE_TRANSFER_NOT_SUPPORTED("The file transfer operation is not supported."),
        ERROR_TRANSFERRING_DATA("An error occurred while transferring data.");

        private String message;

        private ErrorId(String string2) {
            this.message = string2;
        }

        @Override
        public String getMessage() {
            return this.message;
        }
    }
}

